/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.PowerChannel;

public class ManualPowerChannel
extends PowerChannel {
    private boolean promptsUser = true;
    private float volts;
    private float amps;

    public ManualPowerChannel(String channelName, boolean promptsUser) {
        this.name = channelName;
        this.promptsUser = promptsUser;
    }

    @Override
    public float readVoltage() {
        return this.volts;
    }

    @Override
    public float getVoltageSetpoint() {
        return this.volts;
    }

    @Override
    public void setVoltageNoWait(float volts) {
        if (this.promptsUser) {
            System.out.print("Set voltage " + this.getName() + " to " + volts + " V and hit return:");
            Infrastructure.readln();
        } else {
            System.out.println("Setting voltage " + this.getName() + " to " + volts + " V");
        }
        this.volts = volts;
    }

    @Override
    public void setCurrent(float amps) {
        if (this.promptsUser) {
            System.out.print("Set current limit " + this.getName() + " to " + amps + " A and hit return:");
            Infrastructure.readln();
        } else {
            System.out.println("Setting current limit " + this.getName() + " to " + amps + " A");
        }
        this.amps = amps;
    }

    @Override
    public float getCurrentSetpoint() {
        return this.amps;
    }

    @Override
    public float readCurrent() {
        float amps = Float.parseFloat(Infrastructure.readln("Enter current on " + this.getName() + ": "));
        return amps;
    }

    public static void main(String[] args) {
        float volts;
        ManualPowerChannel channel = new ManualPowerChannel("chan", false);
        for (volts = 1.0f; volts < 1.85f; volts += 0.1f) {
            channel.setVoltageWait(volts);
            System.out.println(channel);
        }
        channel = new ManualPowerChannel("chan_prompts", true);
        for (volts = 1.0f; volts < 1.85f; volts += 0.1f) {
            channel.setVoltageWait(volts);
            System.out.println(channel);
        }
    }
}

