/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.util.math.DBMath;

public class StdCellParams350
extends StdCellParams {
    private static final double minGateWid = 0.6;
    private static final double maxMosWidth = Double.POSITIVE_INFINITY;
    private static final double m1OverhangsDiffCont = 0.15;
    private static final double m1Space = 0.45;
    private TechType tech = this.getTechType();

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static StdCellParams invParams(Technology technology, EditingPreferences ep) {
        StdCellParams350 stdCell = new StdCellParams350(technology, ep);
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(5.5);
        stdCell.setGndY(-4.1);
        stdCell.setPmosWellHeight(6.4);
        stdCell.setNmosWellHeight(5.0);
        stdCell.setSimpleName(true);
        stdCell.enableNCC("purpleFour");
        return stdCell;
    }

    private StdCellParams350(Technology tech, EditingPreferences ep) {
        super(tech, ep);
        this.setGndWidth(1.4);
        this.setVddWidth(1.4);
    }

    @Override
    public FoldsAndWidth calcFoldsAndWidth(double spaceAvailWid, double totWid, int groupSz) {
        if (totWid == 0.0) {
            return null;
        }
        double maxAvailWid = Math.min(spaceAvailWid, Double.POSITIVE_INFINITY);
        int nbGroups = this.calcNbGroups(maxAvailWid, totWid, groupSz);
        double gateWid = this.roundGateWidth(totWid / (double)groupSz / (double)nbGroups);
        if (gateWid > maxAvailWid) {
            nbGroups = this.calcNbGroups(maxAvailWid - 0.5, totWid, groupSz);
            gateWid = this.roundGateWidth(totWid / (double)groupSz / (double)nbGroups);
        }
        double physWid = Math.max(this.tech.getDiffContWidth(), gateWid);
        if (gateWid < 0.6) {
            return null;
        }
        return new FoldsAndWidth(nbGroups * groupSz, gateWid, physWid);
    }

    private int calcNbGroups(double maxAvailWid, double totWid, int groupSz) {
        int nbGroups = (int)Math.ceil(totWid / maxAvailWid / (double)groupSz);
        if (groupSz % 2 == 0) {
            return nbGroups;
        }
        if (nbGroups % 2 == 0) {
            return nbGroups;
        }
        if (totWid < maxAvailWid && groupSz == 1) {
            return 1;
        }
        int roundupGroups = nbGroups + 1;
        double wid = totWid / (double)groupSz / (double)roundupGroups;
        if (wid >= this.tech.getDiffContWidth()) {
            nbGroups = roundupGroups;
        }
        return nbGroups;
    }

    @Override
    public void wireVddGnd(FoldedMos[] moss, StdCellParams.SelectSrcDrn select, Cell p) {
        String exportNm;
        FoldedMos mos = moss[0];
        PortInst leftDiff = mos.getSrcDrn(0);
        Cell f = leftDiff.getNodeInst().getParent();
        double busWid = mos instanceof FoldedPmos ? this.getVddWidth() : this.getGndWidth();
        double busY = mos instanceof FoldedPmos ? this.getVddY() : this.getGndY();
        TrackRouterH net = new TrackRouterH(this.tech.m1(), busWid, busY, this.tech, this.ep, p);
        String string2 = exportNm = mos instanceof FoldedPmos ? this.getVddExportName() : this.getGndExportName();
        if (f.findPortProto(exportNm) == null) {
            double x = leftDiff.getBounds().getCenterX();
            NodeInst pinProt = LayoutLib.newNodeInst(this.tech.m1pin(), this.ep, x, busY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, f);
            PortInst pin = pinProt.getOnlyPortInst();
            Export e = Export.newInstance(f, pin, exportNm, this.ep);
            PortCharacteristic role = mos instanceof FoldedPmos ? this.getVddExportRole() : this.getGndExportRole();
            e.setCharacteristic(role);
            LayoutLib.newArcInst(this.tech.m1(), this.ep, busWid, pin, pin);
            net.connect(pin);
        }
        double diffY = LayoutLib.roundCenterY(leftDiff);
        double notchLoY = Math.min(busY - busWid / 2.0, diffY);
        double notchHiY = Math.max(busY + busWid / 2.0, diffY);
        PortInst lastDiff = null;
        for (int i = 0; i < moss.length; ++i) {
            for (int j = 0; j < moss[i].nbSrcDrns(); ++j) {
                if (!select.connectThisOne(i, j)) continue;
                PortInst thisDiff = moss[i].getSrcDrn(j);
                net.connect(thisDiff);
                if (lastDiff != null) {
                    double rightX;
                    double leftX = LayoutLib.roundCenterX(lastDiff);
                    StdCellParams350.error(leftX > (rightX = LayoutLib.roundCenterX(thisDiff)), "wireVddGnd: trans not sorted left to right");
                    double deltaX = rightX - leftX;
                    if (deltaX > 0.0 && deltaX < 0.75) {
                        double dY = Math.ceil(notchHiY - notchLoY);
                        NodeInst patchNode = LayoutLib.newNodeInst(this.tech.m1Node(), this.ep, (leftX + rightX) / 2.0, notchLoY + dY / 2.0, deltaX, dY, 0.0, f);
                        PortInst patch2 = patchNode.getOnlyPortInst();
                        LayoutLib.newArcInst(this.tech.m1(), this.ep, Double.POSITIVE_INFINITY, patch2, thisDiff);
                    }
                }
                lastDiff = thisDiff;
            }
        }
    }

    @Override
    public void addEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, loX, this.getGndY(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, hiX, this.getVddY(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    @Override
    public double roundGateWidth(double w) {
        return DBMath.round(Math.ceil(w * 10.0) / 10.0);
    }

    @Override
    public double getDRCRingSpacing() {
        return 2.3;
    }
}

