/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.metrics.DetouringAmountMetric;
import com.sun.electric.tool.routing.metrics.EvennessMetric;
import com.sun.electric.tool.routing.metrics.HalfPerimeterWireLengthMetric;
import com.sun.electric.tool.routing.metrics.RoutingMetric;
import com.sun.electric.tool.routing.metrics.StackedViasAmountMetric;
import com.sun.electric.tool.routing.metrics.UnroutedNetsMetric;
import com.sun.electric.tool.routing.metrics.ViaAmountMetric;
import com.sun.electric.tool.routing.metrics.WireLengthMetric;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireQualityMetric
extends RoutingMetric<QualityResults> {
    protected static Logger logger = LoggerFactory.getLogger(WireQualityMetric.class);
    protected ElapseTimer timer;
    private String name;
    protected boolean regression = false;
    private PrintStream printWriter = null;
    protected double avgHpwlReal = 0.0;
    protected double avgHpwlIdeal = 0.0;
    protected double totalWL = 0.0;
    protected double avgWlDivHpwlReal = 0.0;
    protected double avgWlDivHpwlIdeal = 0.0;
    protected int avgVias = 0;
    public int numberOfRoutedNets = 0;
    public int numberOfTotalNets = 0;
    public int numRoutedSegments = 0;
    public int numFailedSegments = 0;
    public int numFailedBatches = 0;
    protected HashMap<WLBucket, BucketInstance> wlMapIdeal = new HashMap();
    protected HashMap<WLBucket, BucketInstance> wlMapReal = new HashMap();
    protected HashMap<ZPBucket, BucketInstance> viasMap = new HashMap();

    public WireQualityMetric() {
        this.name = this.getClass().getName();
    }

    public WireQualityMetric(String s2, ElapseTimer t) {
        this.name = s2;
        this.timer = t;
        this.regression = true;
    }

    public void addViaZeroBucket(int val, String netName) {
        ZPBucket zb = ZPBucket.findBucket(val);
        assert (zb != null);
        BucketInstance b = this.viasMap.get((Object)zb);
        if (b == null) {
            b = new BucketInstance();
            this.viasMap.put(zb, b);
        }
        b.nets.add(netName);
    }

    public void addWLLengthToBucket(double val, String netName, boolean real) {
        BucketInstance b;
        WLBucket wlb = WLBucket.findBucket(val);
        assert (wlb != null);
        BucketInstance bucketInstance = b = real ? this.wlMapReal.get((Object)wlb) : this.wlMapIdeal.get((Object)wlb);
        if (b == null) {
            b = new BucketInstance();
            if (real) {
                this.wlMapReal.put(wlb, b);
            } else {
                this.wlMapIdeal.put(wlb, b);
            }
        }
        b.nets.add(netName);
    }

    public double getTotalWireLength() {
        return this.totalWL;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public QualityResults calculate(Cell cell) {
        QualityResults result2 = null;
        try {
            result2 = this.startLogging(cell.getName());
            logger.trace("calculate wire length");
            result2.wireLength = new WireLengthMetric().calculate(cell);
            logger.debug("wire length metric: " + result2.wireLength);
            logger.trace("calculate unrouted nets");
            result2.unroutedSegments = new UnroutedNetsMetric().calculate(cell);
            logger.debug("unrouted nets metric: " + result2.unroutedSegments);
            logger.trace("calculate via amount metric...");
            result2.vias = new ViaAmountMetric().calculate(cell);
            logger.debug("via amount metric: " + result2.vias);
            logger.trace("calculate stacked via amount metric...");
            result2.stackedVias = new StackedViasAmountMetric().calculate(cell);
            logger.debug("stacked via amount metric: " + result2.stackedVias);
            logger.trace("calculate detouring amount metric...");
            result2.detourings = new DetouringAmountMetric().calculate(cell);
            logger.debug("detouring amount metric: " + result2.detourings);
            logger.trace("calculate evenness metric...");
            result2.evenness = new EvennessMetric().calculate(cell);
            logger.debug("evenness metric: " + result2.evenness);
            logger.debug("============================");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return result2;
    }

    protected void info(String data) {
        if (this.printWriter != null) {
            this.printWriter.println(data);
        }
        if (Job.getDebug()) {
            logger.info(data);
        }
    }

    public void setOutput(PrintStream out) {
        this.printWriter = out;
    }

    public String printAverageResults() {
        String val;
        BucketInstance mi;
        if (this.numberOfRoutedNets == 0) {
            this.info("Error: no results found");
            return "";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("Routing Statistics for '" + this.name + "':\n");
        this.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        BigDecimal reg = new BigDecimal(GenMath.toNearest(this.totalWL, 0.1)).setScale(2, 6);
        String temp = "\tTotal wire length " + TextUtils.formatDistance(reg.doubleValue()) + "\n";
        buff.append(temp);
        this.info(temp);
        for (WLBucket wLBucket : WLBucket.values()) {
            mi = this.wlMapReal.get((Object)wLBucket);
            val = "\tReal" + (Object)((Object)wLBucket) + " = " + (mi != null ? mi : Integer.valueOf(0)) + "\n";
            buff.append(val);
            this.info(val);
        }
        for (WLBucket wLBucket : WLBucket.values()) {
            mi = this.wlMapIdeal.get((Object)wLBucket);
            val = "\tIdeal" + (Object)((Object)wLBucket) + " = " + (mi != null ? mi : Integer.valueOf(0)) + "\n";
            buff.append(val);
            this.info(val);
        }
        reg = new BigDecimal(GenMath.toNearest(this.avgVias / this.numberOfRoutedNets, 0.1)).setScale(1, 6);
        temp = "\tAverage number of vias " + reg.doubleValue() + "\t";
        buff.append(temp);
        this.info(temp);
        reg = new BigDecimal(GenMath.toNearest(this.avgVias / this.numRoutedSegments, 0.1)).setScale(1, 6);
        temp = "\tAverage number of vias based on routed segments " + reg.doubleValue() + "\n";
        buff.append(temp);
        this.info(temp);
        for (Enum enum_ : ZPBucket.values()) {
            mi = this.viasMap.get(enum_);
            val = "\t" + enum_ + " = " + (mi != null ? mi : Integer.valueOf(0)) + "\n";
            buff.append(val);
            this.info(val);
        }
        reg = new BigDecimal(GenMath.toNearest(this.avgHpwlReal / (double)this.numberOfRoutedNets, 0.01)).setScale(2, 6);
        temp = "\tAverage Real HPWL " + TextUtils.formatDistance(reg.doubleValue()) + "\t";
        buff.append(temp);
        this.info(temp);
        reg = new BigDecimal(GenMath.toNearest(this.avgHpwlIdeal / (double)this.numberOfRoutedNets, 0.01)).setScale(2, 6);
        temp = "\tAverage Ideal HPWL " + TextUtils.formatDistance(reg.doubleValue()) + "\n";
        buff.append(temp);
        this.info(temp);
        reg = new BigDecimal(GenMath.toNearest(this.avgWlDivHpwlReal / (double)this.numberOfRoutedNets, 0.001)).setScale(3, 6);
        temp = "\tAverage Real WL v/s HPWL " + reg.doubleValue() + "\t";
        buff.append(temp);
        this.info(temp);
        reg = new BigDecimal(GenMath.toNearest(this.avgWlDivHpwlIdeal / (double)this.numberOfRoutedNets, 0.001)).setScale(3, 6);
        temp = "\tAverage Ideal WL v/s HPWL " + reg.doubleValue();
        buff.append(temp);
        this.info(temp);
        this.info("\nXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        return buff.toString();
    }

    protected QualityResults startLogging(String name) throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        String hostname = addr.getHostName();
        Date now = new Date();
        this.info("============================");
        if (this.regression) {
            logger.debug("metric name: " + name);
            logger.debug("machine: " + hostname);
            logger.debug("date: " + TextUtils.formatDate(now));
            logger.debug("Electric's version: " + Version.getVersion());
        }
        if (this.timer != null) {
            logger.debug("execution time: " + this.timer);
        }
        return new QualityResults(name);
    }

    @Override
    public QualityResults calculate(Network net) {
        QualityResults result2 = null;
        ++this.numberOfTotalNets;
        ++this.numberOfRoutedNets;
        try {
            result2 = this.startLogging(net.getName());
            result2.wireLength = new WireLengthMetric().reduce(result2.wireLength, net);
            this.totalWL += result2.wireLength.doubleValue();
            this.info("wire length metric for net '" + net.getName() + "': " + result2.wireLength);
            result2.vias = new ViaAmountMetric().calculate(net);
            this.avgVias += result2.vias.intValue();
            this.info("via amount metric for net '" + net.getName() + "': " + result2.vias);
            double val = new HalfPerimeterWireLengthMetric().calculate(net);
            result2.addSegmentHPWL(val, true);
            this.avgHpwlReal += val;
            this.info("Real HPWL amount metric for net '" + net.getName() + "': " + val);
            val = result2.getWLDivHPWL(true);
            this.avgWlDivHpwlReal += val;
            this.info("Real WL v/s HPWL for net '" + net.getName() + "': " + val);
            this.info("============================");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return result2;
    }

    @Override
    protected QualityResults reduce(QualityResults result2, ArcInst instance, Network net) {
        throw new UnsupportedOperationException();
    }

    public static class QualityResults {
        public Integer vias;
        public Integer stackedVias;
        public Integer detourings;
        public Double evenness;
        public Double wireLength;
        public Integer unroutedSegments;
        public String resultName;
        private List<Double> segmentIdealHPWL = new ArrayList<Double>();
        private List<Double> segmentRealHPWL = new ArrayList<Double>();
        private List<Integer> segmentTotalVias = new ArrayList<Integer>();
        private List<Integer> segmentZeroVias = new ArrayList<Integer>();

        private QualityResults(String name) {
            this.resultName = name;
        }

        public int numOfSegments(boolean real) {
            return real ? this.segmentRealHPWL.size() : this.segmentIdealHPWL.size();
        }

        public void addSegmentViaValues(int totalVias, int zeroValue) {
            this.segmentTotalVias.add(totalVias);
            this.segmentZeroVias.add(zeroValue);
        }

        public int getSegmentViaValue() {
            int total = 0;
            for (int i = 0; i < this.segmentTotalVias.size(); ++i) {
                total = this.segmentTotalVias.get(i) - this.segmentZeroVias.get(i);
            }
            return total;
        }

        public void addSegmentHPWL(double val, boolean real) {
            if (real) {
                this.segmentRealHPWL.add(val);
            } else {
                this.segmentIdealHPWL.add(val);
            }
        }

        public double getSegmentHPWL(boolean avg, boolean real) {
            double val = 0.0;
            List<Double> segmentHPWL = real ? this.segmentRealHPWL : this.segmentIdealHPWL;
            int num = segmentHPWL.size();
            if (num == 0) {
                return val;
            }
            for (int i = 0; i < segmentHPWL.size(); ++i) {
                val += segmentHPWL.get(i).doubleValue();
            }
            return avg ? val / (double)num : val;
        }

        public double getWLDivHPWL(boolean real) {
            List<Double> segmentHPWL;
            List<Double> list = segmentHPWL = real ? this.segmentRealHPWL : this.segmentIdealHPWL;
            assert (segmentHPWL.size() > 0 && this.wireLength != null);
            double val = this.wireLength / this.getSegmentHPWL(true, real);
            if (GenMath.doublesLessThan(val, 1.0)) {
                System.out.println("Check WL v/s HPWL calculation in '" + this.resultName + "' is less than 1:" + val);
            }
            return val;
        }
    }

    public static enum ZPBucket {
        ZPZero(0, 0),
        ZPUntil2(1, 2),
        ZPUntil4(3, 4),
        ZPUntil6(5, 6),
        ZPMoreThan6(6, Integer.MAX_VALUE);

        private int minV;
        private int maxV;

        private ZPBucket(int min2, int max2) {
            this.minV = min2;
            this.maxV = max2;
        }

        public String toString() {
            if (this == ZPMoreThan6) {
                return "Via >+6";
            }
            return "Via +" + this.maxV;
        }

        public static ZPBucket findBucket(int value) {
            for (ZPBucket wl : ZPBucket.values()) {
                if (!DBMath.isLessThanOrEqualTo(wl.minV, value) || !DBMath.isLessThanOrEqualTo(value, wl.maxV)) continue;
                return wl;
            }
            return null;
        }
    }

    public static enum WLBucket {
        WLSmaller110(0.0, 1.1),
        WL110_130(1.1, 1.3),
        WL130_160(1.3, 1.6),
        WL160AndLarger(1.6, Double.MAX_VALUE);

        private double minV;
        private double maxV;

        private WLBucket(double min2, double max2) {
            this.minV = min2;
            this.maxV = max2;
        }

        public String toString() {
            if (this == WLSmaller110) {
                return "WL (< 1.1)";
            }
            if (this == WL160AndLarger) {
                return "WL (> 1.6)";
            }
            return "WL (" + this.minV + ", " + this.maxV + ")";
        }

        public static WLBucket findBucket(double value) {
            for (WLBucket wl : WLBucket.values()) {
                if (!DBMath.isLessThanOrEqualTo(wl.minV, value) || !DBMath.isLessThanOrEqualTo(value, wl.maxV)) continue;
                return wl;
            }
            return null;
        }
    }

    private class BucketInstance {
        private List<String> nets = new ArrayList<String>();

        private BucketInstance() {
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(this.nets.size() + " ");
            if (Job.getDebug()) {
                buffer.append(this.nets.toString());
            }
            return buffer.toString();
        }
    }
}

