/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlacementMinCut
extends PlacementFrame {
    private final double PADDING = 5.0;
    private final boolean DEBUG = false;
    private Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, MutableInteger>> connectivityMap;

    @Override
    public String getAlgorithmName() {
        return "Min-Cut";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        this.connectivityMap = new HashMap<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, MutableInteger>>();
        for (PlacementFrame.PlacementNetwork plNet : allNetworks) {
            List<PlacementFrame.PlacementPort> portsInNetwork = plNet.getPortsOnNet();
            for (int i = 0; i < portsInNetwork.size(); ++i) {
                PlacementFrame.PlacementPort plPort1 = (PlacementFrame.PlacementPort)portsInNetwork.get(i);
                PlacementFrame.PlacementNode plNode1 = plPort1.getPlacementNode();
                for (int j = i + 1; j < portsInNetwork.size(); ++j) {
                    PlacementFrame.PlacementPort plPort2 = (PlacementFrame.PlacementPort)portsInNetwork.get(j);
                    PlacementFrame.PlacementNode plNode2 = plPort2.getPlacementNode();
                    this.incrementMap(plNode1, plNode2);
                    this.incrementMap(plNode2, plNode1);
                }
            }
        }
        ArrayList<PlacementFrame.PlacementNode> singletons = new ArrayList<PlacementFrame.PlacementNode>();
        Partition topPart = new Partition(0);
        for (PlacementFrame.PlacementNode plNode : nodesToPlace) {
            boolean connected = false;
            for (PlacementFrame.PlacementPort plPort : plNode.getPorts()) {
                PlacementFrame.PlacementNetwork net = plPort.getPlacementNetwork();
                if (net == null) continue;
                for (PlacementFrame.PlacementPort otherPort : net.getPortsOnNet()) {
                    if (otherPort.getPlacementNode() == plNode) continue;
                    connected = true;
                    break;
                }
                if (!connected) continue;
                break;
            }
            if (connected) {
                topPart.allNodes.add(plNode);
                continue;
            }
            singletons.add(plNode);
        }
        ArrayList<Partition> partitionsToOrganize = new ArrayList<Partition>();
        partitionsToOrganize.add(topPart);
        while (partitionsToOrganize.size() > 0) {
            Partition part = (Partition)partitionsToOrganize.get(0);
            partitionsToOrganize.remove(0);
            if (part.allNodes.size() <= 2) continue;
            part.splitRandomly();
            part.organize();
            if (part.part1.allNodes.size() > 2) {
                partitionsToOrganize.add(part.part1);
            }
            if (part.part2.allNodes.size() <= 2) continue;
            partitionsToOrganize.add(part.part2);
        }
        Point2D lastOffset = this.placePartitions(topPart, new Point2D.Double(0.0, 0.0));
        double x = lastOffset.getX();
        double y = lastOffset.getY();
        for (PlacementFrame.PlacementNode plNode : singletons) {
            plNode.setPlacement(x, y);
            x += 5.0;
        }
    }

    private Point2D placePartitions(Partition part, Point2D offset) {
        Point2D.Double off;
        String indent = "";
        if (part.part1 != null && part.part2 != null) {
            Point2D off1 = this.placePartitions(part.part1, offset);
            if ((part.depth & 1) == 0) {
                Point2D.Double nextOff = new Point2D.Double(offset.getX(), offset.getY() + off1.getY());
                Point2D off2 = this.placePartitions(part.part2, nextOff);
                off = new Point2D.Double(Math.max(off1.getX(), off2.getX()), off1.getY() + off2.getY());
            } else {
                Point2D.Double nextOff = new Point2D.Double(offset.getX() + off1.getX(), offset.getY());
                Point2D off2 = this.placePartitions(part.part2, nextOff);
                off = new Point2D.Double(off1.getX() + off2.getX(), Math.max(off1.getY(), off2.getY()));
            }
        } else {
            double widestX = 0.0;
            double widestY = 0.0;
            double placeX = offset.getX();
            double placeY = offset.getY();
            for (PlacementFrame.PlacementNode plNode : part.allNodes) {
                double width = plNode.getWidth();
                double height = plNode.getHeight();
                width = height = Math.max(width, height);
                Point2D.Double thisOff = new Point2D.Double(placeX, placeY);
                if ((part.depth & 1) != 0) {
                    widestX += width + 5.0;
                    placeX += width + 5.0;
                    widestY = Math.max(widestY, height + 5.0);
                } else {
                    widestX = Math.max(widestX, width + 5.0);
                    widestY += height + 5.0;
                    placeY += height + 5.0;
                }
                plNode.setPlacement(((Point2D)thisOff).getX(), ((Point2D)thisOff).getY());
            }
            Map<PlacementFrame.PlacementNode, Orientation> properOrientation = this.findOrientations(part.allNodes);
            for (PlacementFrame.PlacementNode plNode : part.allNodes) {
                Orientation or = properOrientation.get(plNode);
                if (or == null) continue;
                plNode.setOrientation(or);
            }
            off = new Point2D.Double(widestX, widestY);
        }
        return off;
    }

    private Map<PlacementFrame.PlacementNode, Orientation> findOrientations(List<PlacementFrame.PlacementNode> allNodes) {
        HashMap<PlacementFrame.PlacementNode, Orientation> properOrientation = new HashMap<PlacementFrame.PlacementNode, Orientation>();
        if (allNodes.size() > 1) {
            List<OrientationConnection> oc;
            HashMap allPossibilities = new HashMap();
            for (PlacementFrame.PlacementNode plNode : allNodes) {
                oc = new ArrayList();
                allPossibilities.put(plNode, oc);
            }
            for (PlacementFrame.PlacementNode plNode : allNodes) {
                oc = (List)allPossibilities.get(plNode);
                for (PlacementFrame.PlacementPort plPort : plNode.getPorts()) {
                    PlacementFrame.PlacementNetwork plNet = plPort.getPlacementNetwork();
                    if (plNet == null) continue;
                    for (PlacementFrame.PlacementPort otherPlPort : plNet.getPortsOnNet()) {
                        PlacementFrame.PlacementNode otherPlNode = otherPlPort.getPlacementNode();
                        if (otherPlNode == plNode || allPossibilities.get(otherPlNode) == null) continue;
                        OrientationConnection orc = new OrientationConnection();
                        orc.thisPP = plPort;
                        orc.otherPN = otherPlNode;
                        orc.otherPP = otherPlPort;
                        oc.add(orc);
                    }
                }
            }
            Orientation[] standardEight = new Orientation[]{Orientation.IDENT, Orientation.R, Orientation.RR, Orientation.RRR, Orientation.X, Orientation.XR, Orientation.XRR, Orientation.XRRR};
            for (PlacementFrame.PlacementNode plNode : allNodes) {
                List oc2 = (List)allPossibilities.get(plNode);
                double bestDist = Double.MAX_VALUE;
                Orientation betterOrientation = null;
                for (int i = 0; i < standardEight.length; ++i) {
                    plNode.setOrientation(standardEight[i]);
                    double length = 0.0;
                    for (OrientationConnection con : oc2) {
                        Point2D.Double pt = new Point2D.Double(plNode.getPlacementX() + con.thisPP.getRotatedOffX(), plNode.getPlacementY() + con.thisPP.getRotatedOffY());
                        Point2D.Double otherPt = new Point2D.Double(con.otherPN.getPlacementX() + con.otherPP.getRotatedOffX(), con.otherPN.getPlacementY() + con.otherPP.getRotatedOffY());
                        double dist = pt.distance(otherPt);
                        length += dist;
                    }
                    if (betterOrientation != null && !(length < bestDist)) continue;
                    bestDist = length;
                    betterOrientation = standardEight[i];
                }
                if (betterOrientation == null) continue;
                plNode.setOrientation(betterOrientation);
                properOrientation.put(plNode, betterOrientation);
            }
        }
        return properOrientation;
    }

    private int getConnectivity(PlacementFrame.PlacementNode plNode1, PlacementFrame.PlacementNode plNode2) {
        Map<PlacementFrame.PlacementNode, MutableInteger> destMap = this.connectivityMap.get(plNode1);
        if (destMap == null) {
            return 0;
        }
        MutableInteger mi = destMap.get(plNode2);
        if (mi == null) {
            return 0;
        }
        return mi.intValue();
    }

    private void incrementMap(PlacementFrame.PlacementNode plNode1, PlacementFrame.PlacementNode plNode2) {
        MutableInteger mi;
        Map<PlacementFrame.PlacementNode, MutableInteger> destMap = this.connectivityMap.get(plNode1);
        if (destMap == null) {
            destMap = new HashMap<PlacementFrame.PlacementNode, MutableInteger>();
            this.connectivityMap.put(plNode1, destMap);
        }
        if ((mi = destMap.get(plNode2)) == null) {
            mi = new MutableInteger(0);
            destMap.put(plNode2, mi);
        }
        mi.increment();
    }

    private class Partition {
        List<PlacementFrame.PlacementNode> allNodes;
        Partition part1;
        Partition part2;
        int depth;

        Partition(int depth) {
            this.depth = depth;
            this.allNodes = new ArrayList<PlacementFrame.PlacementNode>();
        }

        void splitRandomly() {
            this.part1 = new Partition(this.depth + 1);
            this.part2 = new Partition(this.depth + 1);
            boolean putIn1 = true;
            for (PlacementFrame.PlacementNode plNode : this.allNodes) {
                if (putIn1) {
                    this.part1.allNodes.add(plNode);
                } else {
                    this.part2.allNodes.add(plNode);
                }
                putIn1 = !putIn1;
            }
        }

        void organize() {
            ArrayList<SwapNodes> allSwaps = new ArrayList<SwapNodes>();
            while (true) {
                int startingCuts = this.findNumCuts();
                int bestGain = 0;
                int group1Member = -1;
                int group2Member = -1;
                for (int i = 0; i < this.part1.allNodes.size(); ++i) {
                    PlacementFrame.PlacementNode plNode1 = this.part1.allNodes.get(i);
                    for (int j = 0; j < this.part2.allNodes.size(); ++j) {
                        PlacementFrame.PlacementNode plNode2 = this.part2.allNodes.get(j);
                        this.part1.allNodes.set(i, plNode2);
                        this.part2.allNodes.set(j, plNode1);
                        int newCuts = this.findNumCuts();
                        int gain = startingCuts - newCuts;
                        if (gain > bestGain) {
                            bestGain = gain;
                            group1Member = i;
                            group2Member = j;
                        }
                        this.part1.allNodes.set(i, plNode1);
                        this.part2.allNodes.set(j, plNode2);
                    }
                }
                if (bestGain == 0) break;
                PlacementFrame.PlacementNode plNode1 = this.part1.allNodes.get(group1Member);
                PlacementFrame.PlacementNode plNode2 = this.part2.allNodes.get(group2Member);
                this.part1.allNodes.remove(group1Member);
                this.part2.allNodes.remove(group2Member);
                SwapNodes g = new SwapNodes(plNode1, plNode2);
                allSwaps.add(g);
            }
            for (SwapNodes g : allSwaps) {
                this.part1.allNodes.add(g.plNode2);
                this.part2.allNodes.add(g.plNode1);
            }
        }

        private int findNumCuts() {
            int cuts = 0;
            for (PlacementFrame.PlacementNode plNode1 : this.part1.allNodes) {
                for (PlacementFrame.PlacementNode plNode2 : this.part2.allNodes) {
                    cuts += PlacementMinCut.this.getConnectivity(plNode1, plNode2);
                }
            }
            return cuts;
        }
    }

    private static class OrientationConnection {
        PlacementFrame.PlacementPort thisPP;
        PlacementFrame.PlacementNode otherPN;
        PlacementFrame.PlacementPort otherPP;

        private OrientationConnection() {
        }
    }

    private static class SwapNodes {
        PlacementFrame.PlacementNode plNode1;
        PlacementFrame.PlacementNode plNode2;

        SwapNodes(PlacementFrame.PlacementNode n1, PlacementFrame.PlacementNode n2) {
            this.plNode1 = n1;
            this.plNode2 = n2;
        }
    }
}

