/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex;

import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class SvexQuote<N extends SvarName>
extends Svex<N> {
    public final Vec4 val;
    private final int hashCode;
    private static final int SMALL_CACHE_EXP_LIMIT = 10;
    private static final List<SvexQuote<?>> smallCache = new ArrayList();
    private static final Map<Vec4, SvexQuote<?>> INTERN = new HashMap();
    private static final SvexQuote<?> X = new SvexQuote(Vec4.X);
    private static final SvexQuote<?> Z = new SvexQuote(Vec4.Z);

    private SvexQuote(Vec4 val) {
        if (val == null) {
            throw new NullPointerException();
        }
        this.val = val;
        this.hashCode = val.isVec2() ? val.hashCode() : ACL2Object.hashCodeOfCons(ACL2.QUOTE.hashCode(), ACL2Object.hashCodeOfCons(val.hashCode(), ACL2Object.HASH_CODE_NIL));
    }

    public <N1 extends SvarName> SvexQuote<N1> cast() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <N extends SvarName> Svex<N> valueOf(Vec4 val) {
        BigInteger bv;
        if (val.isVec2() && (bv = ((Vec2)val).getVal()).signum() >= 0 && bv.bitLength() < 10) {
            return smallCache.get(bv.intValueExact());
        }
        Map<Vec4, SvexQuote<?>> map = INTERN;
        synchronized (map) {
            SvexQuote<Object> sv = INTERN.get(val);
            if (sv == null) {
                sv = new SvexQuote<N>(val);
                INTERN.put(val, sv);
            }
            return sv;
        }
    }

    public static <N extends SvarName> Svex<N> valueOf(BigInteger val) {
        if (val.signum() >= 0 && val.bitLength() < 10) {
            return smallCache.get(val.intValueExact());
        }
        return SvexQuote.valueOf(Vec2.valueOf(val));
    }

    public static <N extends SvarName> Svex<N> valueOf(int val) {
        if (val >= 0 && val < 1024) {
            return smallCache.get(val);
        }
        return SvexQuote.valueOf(BigInteger.valueOf(val));
    }

    public static <N extends SvarName> Svex<N> X() {
        return X;
    }

    public static <N extends SvarName> Svex<N> Z() {
        return Z;
    }

    @Override
    public <N1 extends SvarName> Svex<N1> convertVars(Function<N, N1> rename, SvexManager<N1> sm, Map<Svex<N>, Svex<N1>> cache) {
        return this.cast();
    }

    @Override
    public Svex<N> addDelay(int delay, SvexManager<N> sm, Map<Svex<N>, Svex<N>> cache) {
        return this;
    }

    @Override
    protected void collectVarsRev(Set<Svar<N>> result, Set<SvexCall<N>> visited) {
    }

    @Override
    public <R, D> R accept(Svex.Visitor<N, R, D> visitor, D data) {
        return visitor.visitConst(this.val, data);
    }

    @Override
    <R> R traverse(Svex.TraverseVisitor<N, R> visitor, Map<Svex<N>, R> cache) {
        R result = cache.get(this);
        if (result == null) {
            result = visitor.visitQuote(this.val);
            cache.put(this, result);
        }
        return result;
    }

    @Override
    public Vec4 xeval(Map<Svex<N>, Vec4> memoize) {
        return this.val;
    }

    @Override
    public Svex<N> patch(Map<Svar<N>, Vec4> subst, SvexManager<N> sm, Map<SvexCall<N>, SvexCall<N>> memoize) {
        return this;
    }

    @Override
    public boolean isLhsUnbounded() {
        return this.val.equals(Vec4.Z);
    }

    @Override
    public boolean isLhs() {
        return this.val.equals(Vec4.Z);
    }

    @Override
    public Lhs<N> lhsBound(int w) {
        return new Lhs(Collections.emptyList());
    }

    @Override
    public Lhs<N> toLhs() {
        return new Lhs(Collections.emptyList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SvexQuote) {
            SvexQuote that = (SvexQuote)o;
            return this.hashCode == that.hashCode && this.val.equals(that.val);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ACL2Object getACL2Object() {
        ACL2Object result = this.val.isVec2() ? ACL2.honscopy(this.val.getACL2Object()) : ACL2.hons(ACL2.QUOTE, ACL2.hons(this.val.getACL2Object(), ACL2.NIL));
        assert (result.hashCode() == this.hashCode);
        return result;
    }

    static {
        for (int v = 0; v < 1024; ++v) {
            SvexQuote sq = new SvexQuote(Vec2.valueOf(v));
            smallCache.add(sq);
        }
        INTERN.put(SvexQuote.X.val, X);
        INTERN.put(SvexQuote.Z.val, Z);
    }
}

