/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.runtime.taskParallel;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.datastructures.LockFreeQueue;
import com.sun.electric.tool.util.concurrent.debug.Debug;
import com.sun.electric.tool.util.concurrent.debug.LoadBalancing;
import com.sun.electric.tool.util.concurrent.exceptions.PoolExistsException;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.Scheduler;
import com.sun.electric.tool.util.concurrent.runtime.ThreadID;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.IThreadPool;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.PoolWorkerStrategy;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.SimpleWorker;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.SynchronizedWorker;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import com.sun.electric.util.UniqueIDGenerator;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class ThreadPool
extends IThreadPool {
    private IStructure<PTask> taskPool = null;
    private int numOfThreads = 0;
    private ArrayList<Worker> workers = null;
    private ThreadPoolState state = ThreadPoolState.New;
    private UniqueIDGenerator generator;
    private ThreadPoolType type;
    private static ThreadPool instance = null;

    protected ThreadPool(IStructure<PTask> taskPool, int numOfThreads, ThreadPoolType type) {
        this.taskPool = taskPool;
        this.numOfThreads = numOfThreads;
        this.generator = new UniqueIDGenerator(0);
        this.type = type;
        ThreadID.reset();
        this.workers = ConcurrentCollectionFactory.createArrayList();
        for (int i = 0; i < numOfThreads; ++i) {
            this.workers.add(new Worker(this));
        }
        this.state = ThreadPoolState.Init;
    }

    @Override
    public void start() {
        if (this.state == ThreadPoolState.Init) {
            for (Worker worker : this.workers) {
                worker.start();
            }
        }
        this.state = ThreadPoolState.Started;
    }

    @Override
    public void shutdown() throws InterruptedException {
        for (Worker worker : this.workers) {
            worker.shutdown();
        }
        this.taskPool.shutdown();
        if (this.workers.size() > 0) {
            this.workers.get((int)0).strategy.trigger();
        }
        this.join();
        this.state = ThreadPoolState.Closed;
        if (Debug.isDebug()) {
            LoadBalancing.getInstance().printStatistics();
            LoadBalancing.getInstance().reset();
        }
    }

    @Override
    public void join() throws InterruptedException {
        for (Worker worker : this.workers) {
            worker.join();
        }
    }

    @Override
    public void sleep() {
        if (this.state == ThreadPoolState.Started) {
            for (Worker worker : this.workers) {
                worker.sleep();
            }
            this.state = ThreadPoolState.Sleeps;
        }
    }

    @Override
    public void weakUp() {
        if (this.state == ThreadPoolState.Sleeps) {
            for (Worker worker : this.workers) {
                worker.weakUp();
            }
            this.state = ThreadPoolState.Started;
        }
    }

    @Override
    public void trigger() {
        if (this.workers.size() > 0) {
            this.workers.get((int)0).strategy.trigger();
        }
    }

    @Override
    public void add(PTask item) {
        this.taskPool.add(item);
    }

    @Override
    public void add(PTask item, int threadId) {
        this.taskPool.add(item, threadId);
    }

    @Override
    public int getPoolSize() {
        return this.numOfThreads;
    }

    public static ThreadPool initialize() throws PoolExistsException, Scheduler.UnknownSchedulerException {
        IStructure<PTask> scheduler = Scheduler.createScheduler(Scheduler.SchedulingStrategy.queue, ThreadPool.getNumOfThreads());
        return ThreadPool.initialize(scheduler);
    }

    public static ThreadPool initialize(int num) throws PoolExistsException {
        LockFreeQueue<PTask> taskPool = ConcurrentCollectionFactory.createLockFreeQueue();
        return ThreadPool.initialize(taskPool, num);
    }

    public static ThreadPool initialize(IStructure<PTask> taskPool) throws PoolExistsException {
        return ThreadPool.initialize(taskPool, ThreadPool.getNumOfThreads());
    }

    public static synchronized ThreadPool initialize(Scheduler.SchedulingStrategy taskPool, int numOfThreads) throws Scheduler.UnknownSchedulerException, PoolExistsException {
        IStructure<PTask> scheduler = Scheduler.createScheduler(taskPool, numOfThreads);
        return ThreadPool.initialize(scheduler, numOfThreads);
    }

    public static synchronized ThreadPool initialize(Scheduler.SchedulingStrategy taskPool, int numOfThreads, ThreadPoolType type) throws Scheduler.UnknownSchedulerException, PoolExistsException {
        IStructure<PTask> scheduler = Scheduler.createScheduler(taskPool, numOfThreads);
        return ThreadPool.initialize(scheduler, numOfThreads, type);
    }

    public static synchronized ThreadPool initialize(IStructure<PTask> taskPool, int numOfThreads) throws PoolExistsException {
        return ThreadPool.initialize(taskPool, numOfThreads, ThreadPoolType.simplePool);
    }

    public static synchronized ThreadPool initialize(IStructure<PTask> taskPool, int numOfThreads, ThreadPoolType type) throws PoolExistsException {
        if (instance == null || ThreadPool.instance.state != ThreadPoolState.Started) {
            System.out.println("ThreadPool: start thread pool");
            instance = new ThreadPool(taskPool, numOfThreads, type);
            instance.start();
        }
        return instance;
    }

    public static synchronized ThreadPool[] initialize(IStructure<PTask> taskPool1, int numOfThreads1, ThreadPoolType type1, IStructure<PTask> taskPool2, int numOfThreads2, ThreadPoolType type2) {
        ThreadPool[] result = new ThreadPool[]{new ThreadPool(taskPool1, numOfThreads1, type1), new ThreadPool(taskPool2, numOfThreads2, type2)};
        result[0].start();
        result[1].start();
        return result;
    }

    public static synchronized void killPool() {
        try {
            instance.shutdown();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        instance = null;
        IThreadPool.NUM_THREADS = null;
    }

    private static int getNumOfThreads() {
        if (IThreadPool.NUM_THREADS == null) {
            return Runtime.getRuntime().availableProcessors();
        }
        return IThreadPool.NUM_THREADS;
    }

    public static ThreadPool getThreadPool() {
        return instance;
    }

    public ThreadPoolState getState() {
        return this.state;
    }

    public static enum ThreadPoolState {
        New,
        Init,
        Started,
        Closed,
        Sleeps;

    }

    public static enum ThreadPoolType {
        simplePool,
        synchronizedPool,
        userDefined;

    }

    protected class Worker
    extends Thread {
        private ThreadPool pool;
        private PoolWorkerStrategy strategy;

        public Worker(ThreadPool pool) {
            this.pool = pool;
            ThreadID.set(ThreadPool.this.generator.getUniqueId());
            this.strategy = PoolWorkerStrategyFactory.createStrategy(ThreadPool.this.taskPool, ThreadPool.this.type);
            if (Debug.isDebug()) {
                LoadBalancing.getInstance().registerWorker(this.strategy);
            }
        }

        @Override
        public void run() {
            this.pool.taskPool.registerThread();
            this.strategy.execute();
        }

        public void shutdown() {
            this.strategy.shutdown();
            this.interrupt();
        }

        public void sleep() {
            this.strategy.pleaseWait();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void weakUp() {
            this.strategy.pleaseWakeUp();
            PoolWorkerStrategy poolWorkerStrategy = this.strategy;
            synchronized (poolWorkerStrategy) {
                this.strategy.notifyAll();
            }
        }
    }

    public static class PoolWorkerStrategyFactory {
        private static Semaphore trigger = new Semaphore(0);
        public static PoolWorkerStrategy userDefinedStrategy = null;

        public static PoolWorkerStrategy createStrategy(IStructure<PTask> taskPool, ThreadPoolType type) {
            if (type == ThreadPoolType.synchronizedPool) {
                return new SynchronizedWorker(taskPool, trigger);
            }
            if (type == ThreadPoolType.simplePool) {
                return new SimpleWorker(taskPool);
            }
            if (userDefinedStrategy == null) {
                return PoolWorkerStrategyFactory.createStrategy(taskPool, ThreadPoolType.simplePool);
            }
            userDefinedStrategy.setTaskPool(taskPool);
            return userDefinedStrategy;
        }
    }
}

