/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Exec;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

public class ExecDialog
extends EDialog
implements Exec.FinishedListener {
    private ProcessOutput outStream;
    private ProcessOutput errStream;
    private Exec exec;
    private List<Exec.FinishedListener> finishedListenersToAdd;
    private JTextField inputTextField;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JTextArea outputTextArea;
    private JLabel statusLabel;

    public ExecDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.exec = null;
        this.finishedListenersToAdd = new ArrayList<Exec.FinishedListener>();
        this.finishInitialization();
    }

    public synchronized void addFinishedListener(Exec.FinishedListener l) {
        this.finishedListenersToAdd.add(l);
    }

    public synchronized void removeFinishedListener(Exec.FinishedListener l) {
        this.finishedListenersToAdd.remove(l);
    }

    public synchronized void startProcess(String[] command, String[] envVars, File dir) {
        if (this.exec != null) {
            System.out.println("ERROR: ExecDialog can only execute one process at a time.");
            return;
        }
        this.outStream = new ProcessOutput(this.outputTextArea);
        this.errStream = new ProcessOutput(this.outputTextArea);
        this.exec = new Exec(command, envVars, dir, this.outStream, this.errStream);
        this.exec.addFinishedListener(this);
        for (Exec.FinishedListener l : this.finishedListenersToAdd) {
            this.exec.addFinishedListener(l);
        }
        this.finishedListenersToAdd.clear();
        this.setTitle("External Process");
        this.statusLabel.setText("Running " + command[0] + "...");
        this.setVisible(true);
        this.exec.start();
    }

    @Override
    public void processFinished(Exec.FinishedEvent e) {
        this.endProcess(e);
    }

    private synchronized void writeln(String line) {
        if (this.exec != null) {
            this.outputTextArea.append(">>> " + line + "\n");
            this.exec.writeln(line);
        }
    }

    private synchronized void endProcess(Exec.FinishedEvent e) {
        String str;
        this.exec.removeFinishedListener(this);
        this.exec = null;
        if (e.getExitValue() != 0) {
            JOptionPane.showMessageDialog(this, this.exec, "Exec '" + e.getExec() + "' failed: return value: " + e.getExitValue(), 0);
            str = "Process FAILED [exit=" + e.getExitValue() + "]: '" + e.getExec() + "'\n";
        } else {
            str = "Process Done [exit=" + e.getExitValue() + "]: '" + e.getExec() + "'\n";
        }
        this.statusLabel.setText(str);
        this.outputTextArea.append("*****" + str);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.inputTextField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.outputTextArea = new JTextArea();
        this.statusLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExecDialog.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(new GridBagLayout());
        this.inputTextField.setColumns(8);
        this.inputTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExecDialog.this.inputTextFieldActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.inputTextField, gridBagConstraints);
        this.outputTextArea.setColumns(40);
        this.outputTextArea.setRows(20);
        this.jScrollPane1.setViewportView(this.outputTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.statusLabel.setText("Status:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.statusLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void inputTextFieldActionPerformed(ActionEvent evt) {
        this.writeln(this.inputTextField.getText());
        this.inputTextField.setText("");
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        if (this.exec != null) {
            this.exec.removeFinishedListener(this);
            this.exec.destroyProcess();
        }
        this.dispose();
    }

    private static class ProcessOutput
    extends OutputStream {
        private JTextArea area;
        private boolean processLineFeed;
        private int prevChar;

        private ProcessOutput(JTextArea area) {
            DefaultCaret caret = (DefaultCaret)area.getCaret();
            caret.setUpdatePolicy(2);
            this.area = area;
            this.processLineFeed = true;
            if (System.getProperty("line.separator") == "\r") {
                this.processLineFeed = false;
            }
            this.prevChar = 0;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            byte[] bytes = new byte[]{(byte)b};
            String str = new String(bytes);
            if (this.prevChar == 13 && b != 10 && this.processLineFeed) {
                try {
                    int start = this.area.getLineStartOffset(this.area.getLineCount() - 1);
                    int end = this.area.getLineEndOffset(this.area.getLineCount() - 1);
                    this.area.replaceRange(str, start, end);
                }
                catch (BadLocationException e) {
                    e.printStackTrace(System.out);
                    ActivityLogger.logException(e);
                }
            } else {
                this.area.append(str);
            }
            this.prevChar = b;
        }
    }
}

