/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.kawa.functions.DisplayFormat;
import gnu.lists.Consumer;
import gnu.lists.FormatToConsumer;
import gnu.mapping.OutPort;
import gnu.text.ReportFormat;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.ParsePosition;
import kawa.standard.Scheme;

public class ObjectFormat
extends ReportFormat {
    int maxChars;
    boolean readable;
    private static ObjectFormat readableFormat;
    private static ObjectFormat plainFormat;

    public static ObjectFormat getInstance(boolean bl) {
        if (bl) {
            if (readableFormat == null) {
                readableFormat = new ObjectFormat(true);
            }
            return readableFormat;
        }
        if (plainFormat == null) {
            plainFormat = new ObjectFormat(false);
        }
        return plainFormat;
    }

    public ObjectFormat(boolean bl) {
        this.readable = bl;
        this.maxChars = -1073741824;
    }

    public ObjectFormat(boolean bl, int n) {
        this.readable = bl;
        this.maxChars = n;
    }

    public int format(Object[] objectArray, int n, Writer writer, FieldPosition fieldPosition) throws IOException {
        int n2 = ObjectFormat.getParam(this.maxChars, -1, objectArray, n);
        if (this.maxChars == -1610612736) {
            ++n;
        }
        return ObjectFormat.format(objectArray, n, writer, n2, this.readable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(Object object2, OutPort outPort, boolean bl) {
        boolean bl2 = outPort.printReadable;
        FormatToConsumer formatToConsumer = outPort.objectFormat;
        try {
            outPort.printReadable = bl;
            DisplayFormat displayFormat = bl ? Scheme.writeFormat : Scheme.displayFormat;
            outPort.objectFormat = displayFormat;
            displayFormat.writeObject(object2, (Consumer)outPort);
        }
        finally {
            outPort.printReadable = bl2;
            outPort.objectFormat = formatToConsumer;
        }
    }

    public static boolean format(Object object2, Writer writer, int n, boolean bl) throws IOException {
        if (n < 0 && writer instanceof OutPort) {
            ObjectFormat.print(object2, (OutPort)writer, bl);
            return true;
        }
        if (n < 0 && writer instanceof CharArrayWriter) {
            OutPort outPort = new OutPort(writer);
            ObjectFormat.print(object2, outPort, bl);
            outPort.flush();
            return true;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        OutPort outPort = new OutPort(charArrayWriter);
        ObjectFormat.print(object2, outPort, bl);
        outPort.flush();
        int n2 = charArrayWriter.size();
        if (n < 0 || n2 <= n) {
            charArrayWriter.writeTo(writer);
            return true;
        }
        writer.write(charArrayWriter.toCharArray(), 0, n);
        return false;
    }

    public static int format(Object[] objectArray, int n, Writer writer, int n2, boolean bl) throws IOException {
        ObjectFormat.format(objectArray[n], writer, n2, bl);
        return n + 1;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new RuntimeException("ObjectFormat.parseObject - not implemented");
    }
}

