/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Initializer;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.Target;

public class ProcInitializer
extends Initializer {
    LambdaExp proc;

    public ProcInitializer(LambdaExp lambdaExp, Compilation compilation) {
        this.field = lambdaExp.allocFieldFor(compilation);
        this.proc = lambdaExp;
        LambdaExp lambdaExp2 = lambdaExp.getOwningLambda();
        if (lambdaExp2 instanceof ModuleExp && compilation.instanceField != null) {
            this.next = compilation.clinitChain;
            compilation.clinitChain = this;
        } else {
            this.next = lambdaExp2.initChain;
            lambdaExp2.initChain = this;
        }
    }

    public static void emitLoadModuleMethod(LambdaExp lambdaExp, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        ClassType classType = Compilation.getMethodProcType(compilation.curClass);
        codeAttr.emitNew(classType);
        codeAttr.emitDup(1);
        if (compilation.method.getStaticFlag()) {
            codeAttr.emitGetStatic(compilation.instanceField);
        } else {
            codeAttr.emitPushThis();
        }
        codeAttr.emitPushInt(lambdaExp.getSelectorValue(compilation));
        String string = lambdaExp.getName();
        if (string == null) {
            codeAttr.emitPushNull();
        } else {
            codeAttr.emitPushString(string);
        }
        codeAttr.emitPushInt(lambdaExp.min_args | lambdaExp.max_args << 12);
        Method method = classType.getDeclaredMethod("<init>", 4);
        codeAttr.emitInvokeSpecial(method);
    }

    public void emit(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (!this.field.getStaticFlag()) {
            codeAttr.emitPushThis();
        }
        ProcInitializer.emitLoadModuleMethod(this.proc, compilation);
        if (this.proc.properties != null) {
            int n = this.proc.properties.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.proc.properties[n2];
                if (object2 != null) {
                    Object object3 = this.proc.properties[n2 + 1];
                    codeAttr.emitDup(1);
                    compilation.compileConstant(object2);
                    Target target = Target.pushObject;
                    if (object3 instanceof Expression) {
                        ((Expression)object3).compile(compilation, target);
                    } else {
                        compilation.compileConstant(object3, target);
                    }
                    Method method = Compilation.typeProcedure.getDeclaredMethod("setProperty", 2);
                    codeAttr.emitInvokeVirtual(method);
                }
                n2 += 2;
            }
        }
        if (this.field.getStaticFlag()) {
            codeAttr.emitPutStatic(this.field);
        } else {
            codeAttr.emitPutField(this.field);
        }
    }
}

