/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.kawa.reflect.InstanceOf;
import gnu.lists.ElementPredicate;
import gnu.mapping.Values;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OccurrenceType
extends Type
implements Externalizable,
TypeValue {
    Type base;
    int minOccurs;
    int maxOccurs;
    public static final ClassType typeOccurrenceType = ClassType.make("gnu.kawa.reflect.OccurrenceType");
    static final Method isInstanceMethod = typeOccurrenceType.getDeclaredMethod("isInstance", 1);

    public OccurrenceType(Type type, int n, int n2) {
        this.base = type;
        this.minOccurs = n;
        this.maxOccurs = n2;
    }

    public Type getImplementationType() {
        return Type.pointer_type;
    }

    public int compare(Type type) {
        throw new Error("compare not implemented");
    }

    public Object coerceFromObject(Object object2) {
        if (!this.isInstance(object2)) {
            throw new ClassCastException();
        }
        return object2;
    }

    public boolean isInstance(Object object2) {
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.startPos();
            int n2 = 0;
            if (this.base instanceof ElementPredicate) {
                ElementPredicate elementPredicate = (ElementPredicate)((Object)this.base);
                while (true) {
                    boolean bl = elementPredicate.isInstancePos(values, n);
                    if ((n = values.nextPos(n)) == 0) {
                        return n2 >= this.minOccurs && (this.maxOccurs < 0 || n2 <= this.maxOccurs);
                    }
                    if (!bl) {
                        return false;
                    }
                    ++n2;
                }
            }
            while (true) {
                if ((n = values.nextPos(n)) == 0) {
                    return n2 >= this.minOccurs && (this.maxOccurs < 0 || n2 <= this.maxOccurs);
                }
                Object object3 = values.getPosPrevious(n);
                if (!this.base.isInstance(object3)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.minOccurs > 1 || this.maxOccurs == 0) {
            return false;
        }
        return this.base.isInstance(object2);
    }

    public void emitTestIf(Variable variable, Declaration declaration, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (variable != null) {
            codeAttr.emitLoad(variable);
        }
        if (declaration != null) {
            codeAttr.emitDup();
            declaration.compileStore(compilation);
        }
        compilation.compileConstant(this);
        codeAttr.emitSwap();
        codeAttr.emitInvokeVirtual(isInstanceMethod);
        codeAttr.emitIfIntNotZero();
    }

    public void emitIsInstance(Variable variable, Compilation compilation, Target target) {
        InstanceOf.emitIsInstance(this, variable, compilation, target);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.base);
        objectOutput.writeInt(this.minOccurs);
        objectOutput.writeInt(this.maxOccurs);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.base = (Type)objectInput.readObject();
        this.minOccurs = objectInput.readInt();
        this.maxOccurs = objectInput.readInt();
    }
}

