/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.expr.Keyword;
import gnu.lists.AbstractSequence;
import gnu.lists.Consumable;
import gnu.lists.PositionConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.UnescapedData;
import gnu.lists.XConsumer;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.math.DFloNum;
import gnu.math.RealNum;
import gnu.text.Char;
import gnu.xml.NamespaceBinding;
import gnu.xml.NodeTree;
import gnu.xml.XName;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;

public class XMLPrinter
extends OutPort
implements PositionConsumer,
XConsumer {
    public int printIndent = -1;
    public boolean indentAttributes;
    boolean printXMLdecl = false;
    boolean inDocument;
    boolean inAttribute = false;
    boolean inStartTag = false;
    int inComment;
    boolean needXMLdecl = false;
    boolean canonicalize = true;
    public boolean canonicalizeCDATA;
    public int useEmptyElementTag = 2;
    public boolean escapeText = true;
    public boolean escapeNonAscii = true;
    boolean isHtml = false;
    boolean undeclareNamespaces = false;
    Object style;
    public static final ThreadLocation doctypeSystem = new ThreadLocation("doctype-system");
    public static final ThreadLocation doctypePublic = new ThreadLocation("doctype-public");
    public static final ThreadLocation indentLoc = new ThreadLocation("xml-indent");
    NamespaceBinding namespaceBindings = NamespaceBinding.predefinedXML;
    NamespaceBinding[] namespaceSaveStack = new NamespaceBinding[20];
    Object[] groupNameStack = new Object[20];
    int groupNesting;
    private static final int WORD = -2;
    private static final int ELEMENT_START = -3;
    private static final int ELEMENT_END = -4;
    private static final int COMMENT = -5;
    private static final int KEYWORD = -6;
    int prev = 32;
    char savedHighSurrogate;
    static final String HtmlEmptyTags = "/area/base/basefont/br/col/frame/hr/img/input/isindex/link/meta/para/";

    public void setPrintXMLdecl(boolean value) {
        this.printXMLdecl = value;
    }

    public XMLPrinter(OutPort out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public XMLPrinter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public XMLPrinter(OutputStream out, boolean autoFlush) {
        super((Writer)new OutputStreamWriter(out), true, autoFlush);
    }

    public XMLPrinter(Writer out) {
        super(out);
    }

    public XMLPrinter(OutputStream out) {
        super((Writer)new OutputStreamWriter(out), false, false);
    }

    public XMLPrinter(OutputStream out, String fname) {
        super(new OutputStreamWriter(out), true, false, fname);
    }

    public static XMLPrinter make(OutPort out, Object style) {
        XMLPrinter xout = new XMLPrinter(out, true);
        xout.setStyle(style);
        return xout;
    }

    public static String toString(Object value) {
        StringWriter stringWriter = new StringWriter();
        new XMLPrinter(stringWriter).writeObject(value);
        return stringWriter.toString();
    }

    public void setStyle(Object style) {
        this.style = style;
        int n = this.useEmptyElementTag = this.canonicalize ? 0 : 1;
        if ("html".equals(style)) {
            this.isHtml = true;
            this.useEmptyElementTag = 2;
        }
        if ("xhtml".equals(style)) {
            this.useEmptyElementTag = 2;
        }
        if ("plain".equals(style)) {
            this.escapeText = false;
        }
    }

    public void write(int v) {
        this.closeTag();
        if (this.printIndent >= 0 && (v == 13 || v == 10)) {
            if (v != 10 || this.prev != 13) {
                this.writeBreak(82);
            }
            if (this.inComment > 0) {
                this.inComment = 1;
            }
            return;
        }
        if (!this.escapeText) {
            this.bout.write(v);
            this.prev = v;
        } else if (this.inComment > 0) {
            if (v == 45) {
                if (this.inComment == 1) {
                    this.inComment = 2;
                } else {
                    this.bout.write(32);
                }
            } else {
                this.inComment = 1;
            }
            super.write(v);
        } else {
            this.prev = 59;
            if (!(v != 60 || this.isHtml && this.inAttribute)) {
                this.bout.write("&lt;");
            } else if (v == 62) {
                this.bout.write("&gt;");
            } else if (v == 38) {
                this.bout.write("&amp;");
            } else if (v == 34 && this.inAttribute) {
                this.bout.write("&quot;");
            } else if (this.escapeNonAscii && v >= 127 || v < 32 && (this.inAttribute || v != 9 && v != 10)) {
                int i = v;
                if (v >= 55296) {
                    if (v < 56320) {
                        this.savedHighSurrogate = (char)v;
                        return;
                    }
                    if (v < 57344) {
                        i = (this.savedHighSurrogate - 55296) * 1024 + (i - 56320) + 65536;
                        this.savedHighSurrogate = '\u0000';
                    }
                }
                this.bout.write("&#x" + Integer.toHexString(i).toUpperCase() + ";");
            } else {
                this.bout.write(v);
                this.prev = v;
            }
        }
    }

    private void startWord() {
        this.closeTag();
        this.writeWordStart();
    }

    public void writeBoolean(boolean v) {
        this.startWord();
        super.print(v);
        this.writeWordEnd();
    }

    protected void startNumber() {
        this.startWord();
    }

    protected void endNumber() {
        this.writeWordEnd();
    }

    public void closeTag() {
        if (this.inStartTag && !this.inAttribute) {
            if (this.printIndent >= 0 && this.indentAttributes) {
                this.endLogicalBlock("");
            }
            this.bout.write(62);
            this.inStartTag = false;
            this.prev = -3;
        } else if (this.needXMLdecl) {
            this.bout.write("<?xml version=\"1.0\"?>\n");
            if (this.printIndent >= 0) {
                this.startLogicalBlock("", "", 2);
            }
            this.needXMLdecl = false;
        }
    }

    void setIndentMode() {
        String indent;
        Object xmlIndent = indentLoc.get(null);
        String string = indent = xmlIndent == null ? null : xmlIndent.toString();
        this.printIndent = indent == null ? -1 : (indent.equals("pretty") ? 0 : (indent.equals("always") || indent.equals("yes") ? 1 : -1));
    }

    public void beginDocument() {
        if (this.printXMLdecl) {
            this.needXMLdecl = true;
        }
        this.setIndentMode();
        this.inDocument = true;
        if (this.printIndent >= 0 && !this.needXMLdecl) {
            this.startLogicalBlock("", "", 2);
        }
    }

    public void endDocument() {
        this.inDocument = false;
        if (this.printIndent >= 0) {
            this.endLogicalBlock("");
        }
        this.freshLine();
    }

    public void beginEntity(Object base) {
    }

    public void endEntity() {
    }

    protected void writeQName(Object name) {
        if (name instanceof Symbol) {
            Symbol sname = (Symbol)name;
            String prefix = sname.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                this.bout.write(prefix);
                this.bout.write(58);
            }
            this.bout.write(sname.getLocalPart());
        } else {
            this.bout.write(name == null ? "{null name}" : (String)name);
        }
    }

    public void beginGroup(Object type) {
        this.closeTag();
        if (this.groupNesting == 0) {
            String systemId;
            Object systemIdentifier;
            if (!this.inDocument) {
                this.setIndentMode();
            }
            if ((systemIdentifier = doctypeSystem.get(null)) != null && (systemId = systemIdentifier.toString()).length() > 0) {
                String publicId;
                Object publicIdentifier = doctypePublic.get(null);
                this.bout.write("<!DOCTYPE ");
                this.bout.write(type.toString());
                String string = publicId = publicIdentifier == null ? null : publicIdentifier.toString();
                if (publicId != null && publicId.length() > 0) {
                    this.bout.write(" PUBLIC \"");
                    this.bout.write(publicId);
                    this.bout.write("\" \"");
                } else {
                    this.bout.write(" SYSTEM \"");
                }
                this.bout.write(systemId);
                this.bout.write("\">");
                this.println();
            }
        }
        if (this.printIndent >= 0) {
            if (this.prev == -3 || this.prev == -4 || this.prev == -5) {
                this.writeBreak(this.printIndent > 0 ? 82 : 78);
            }
            this.startLogicalBlock("", "", 2);
        }
        this.bout.write(60);
        this.writeQName(type);
        if (this.printIndent >= 0 && this.indentAttributes) {
            this.startLogicalBlock("", "", 2);
        }
        this.groupNameStack[this.groupNesting] = type;
        NamespaceBinding groupBindings = null;
        this.namespaceSaveStack[this.groupNesting++] = this.namespaceBindings;
        if (type instanceof XName) {
            groupBindings = ((XName)type).namespaceNodes;
            NamespaceBinding join = NamespaceBinding.commonAncestor(groupBindings, this.namespaceBindings);
            int numBindings = groupBindings == null ? 0 : groupBindings.count(join);
            NamespaceBinding[] sortedBindings = new NamespaceBinding[numBindings];
            int i = 0;
            boolean sortNamespaces = this.canonicalize;
            NamespaceBinding ns = groupBindings;
            while (ns != join) {
                block24: {
                    int j = i;
                    boolean skip = false;
                    String uri = ns.getUri();
                    String prefix = ns.getPrefix();
                    while (--j >= 0) {
                        NamespaceBinding ns_j = sortedBindings[j];
                        String prefix_j = ns_j.getPrefix();
                        if (prefix != prefix_j) {
                            if (!sortNamespaces) continue;
                            if (prefix == null || prefix_j != null && prefix.compareTo(prefix_j) <= 0) break;
                            sortedBindings[j + 1] = ns_j;
                            continue;
                        }
                        break block24;
                    }
                    j = sortNamespaces ? ++j : i;
                    sortedBindings[j] = ns;
                    ++i;
                }
                ns = ns.next;
            }
            i = numBindings = i;
            while (--i >= 0) {
                ns = sortedBindings[i];
                String uri = ns.uri;
                String prefix = ns.prefix;
                if (uri == this.namespaceBindings.resolve(prefix)) continue;
                this.bout.write(32);
                if (prefix == null) {
                    this.bout.write("xmlns");
                } else {
                    this.bout.write("xmlns:");
                    this.bout.write(prefix);
                }
                this.bout.write("=\"");
                this.inAttribute = true;
                if (uri != null) {
                    this.write(uri);
                }
                this.inAttribute = false;
                this.bout.write(34);
            }
            if (this.undeclareNamespaces) {
                ns = this.namespaceBindings;
                while (ns != join) {
                    String prefix = ns.prefix;
                    if (ns.uri != null && groupBindings.resolve(prefix) == null) {
                        this.bout.write(32);
                        if (prefix == null) {
                            this.bout.write("xmlns");
                        } else {
                            this.bout.write("xmlns:");
                            this.bout.write(prefix);
                        }
                        this.bout.write("=\"\"");
                    }
                    ns = ns.next;
                }
            }
            this.namespaceBindings = groupBindings;
        }
        if (this.groupNesting >= this.namespaceSaveStack.length) {
            NamespaceBinding[] nstmp = new NamespaceBinding[2 * this.groupNesting];
            System.arraycopy(this.namespaceSaveStack, 0, nstmp, 0, this.groupNesting);
            this.namespaceSaveStack = nstmp;
            Object[] nmtmp = new Object[2 * this.groupNesting];
            System.arraycopy(this.groupNameStack, 0, nmtmp, 0, this.groupNesting);
            this.groupNameStack = nmtmp;
        }
        this.inStartTag = true;
        if (this.isHtml) {
            String typeName;
            String string = typeName = type instanceof Symbol ? ((Symbol)type).getLocalPart() : type.toString();
            if ("script".equals(typeName) || "style".equals(typeName)) {
                this.escapeText = false;
            }
        }
    }

    public static boolean isHtmlEmptyElementTag(String name) {
        int index = HtmlEmptyTags.indexOf(name);
        return index > 0 && HtmlEmptyTags.charAt(index - 1) == '/' && HtmlEmptyTags.charAt(index + name.length()) == '/';
    }

    public void endGroup() {
        String typeName;
        if (this.useEmptyElementTag == 0) {
            this.closeTag();
        }
        Object type = this.groupNameStack[this.groupNesting - 1];
        String string = !this.isHtml ? null : (typeName = type instanceof Symbol ? ((Symbol)type).getLocalPart() : type.toString());
        if (this.inStartTag) {
            if (this.printIndent >= 0 && this.indentAttributes) {
                this.endLogicalBlock("");
            }
            this.bout.write(this.isHtml ? (XMLPrinter.isHtmlEmptyElementTag(typeName) ? ">" : "></" + typeName + ">") : (this.useEmptyElementTag == 2 ? " />" : "/>"));
            this.inStartTag = false;
        } else {
            if (this.printIndent >= 0) {
                this.setIndentation(0, false);
                if (this.prev == -4) {
                    this.writeBreak(this.printIndent > 0 ? 82 : 78);
                }
            }
            this.bout.write("</");
            this.writeQName(type);
            this.bout.write(">");
        }
        if (this.printIndent >= 0) {
            this.endLogicalBlock("");
        }
        this.prev = -4;
        if (this.isHtml && !this.escapeText && ("script".equals(typeName) || "style".equals(typeName))) {
            this.escapeText = true;
        }
        this.namespaceBindings = this.namespaceSaveStack[--this.groupNesting];
        this.namespaceSaveStack[this.groupNesting] = null;
        this.groupNameStack[this.groupNesting] = null;
    }

    public void beginAttribute(Object attrType) {
        if (this.inAttribute) {
            this.bout.write(34);
        }
        this.inAttribute = true;
        this.bout.write(32);
        if (this.printIndent >= 0) {
            this.writeBreakFill();
        }
        this.bout.write(attrType.toString());
        this.bout.write("=\"");
        this.prev = 32;
    }

    public void endAttribute() {
        if (this.inAttribute) {
            if (this.prev != -6) {
                this.bout.write(34);
                this.inAttribute = false;
            }
            this.prev = 32;
        }
    }

    public void writeDouble(double d) {
        this.startWord();
        this.bout.write(XMLPrinter.formatDouble(d));
    }

    public void writeFloat(float f) {
        this.startWord();
        this.bout.write(XMLPrinter.formatFloat(f));
    }

    public static String formatDouble(double d) {
        boolean neg;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        boolean bl = neg = d < 0.0;
        if (Double.isInfinite(d)) {
            return neg ? "-INF" : "INF";
        }
        double dabs = neg ? -d : d;
        String dstr = Double.toString(d);
        if ((dabs >= 1000000.0 || dabs < 1.0E-6) && dabs != 0.0) {
            return RealNum.toStringScientific(dstr);
        }
        return XMLPrinter.formatDecimal(RealNum.toStringDecimal(dstr));
    }

    public static String formatFloat(float f) {
        boolean neg;
        if (Float.isNaN(f)) {
            return "NaN";
        }
        boolean bl = neg = f < 0.0f;
        if (Float.isInfinite(f)) {
            return neg ? "-INF" : "INF";
        }
        float fabs = neg ? -f : f;
        String fstr = Float.toString(f);
        if ((fabs >= 1000000.0f || (double)fabs < 1.0E-6) && (double)fabs != 0.0) {
            return RealNum.toStringScientific(fstr);
        }
        return XMLPrinter.formatDecimal(RealNum.toStringDecimal(fstr));
    }

    public static String formatDecimal(BigDecimal dec) {
        return XMLPrinter.formatDecimal(dec.toString());
    }

    static String formatDecimal(String str) {
        int dot = str.indexOf(46);
        if (dot >= 0) {
            char ch;
            int len;
            int pos = len = str.length();
            while ((ch = str.charAt(--pos)) == '0') {
            }
            if (ch != '.') {
                ++pos;
            }
            return pos == len ? str : str.substring(0, pos);
        }
        return str;
    }

    public void print(Object v) {
        if (v instanceof BigDecimal) {
            v = XMLPrinter.formatDecimal((BigDecimal)v);
        } else if (v instanceof Double || v instanceof DFloNum) {
            v = XMLPrinter.formatDouble(((Number)v).doubleValue());
        } else if (v instanceof Float) {
            v = XMLPrinter.formatFloat(((Float)v).floatValue());
        }
        this.write(v == null ? "(null)" : v.toString());
    }

    public void writeObject(Object v) {
        if (v instanceof SeqPosition) {
            this.bout.clearWordEnd();
            SeqPosition pos = (SeqPosition)v;
            pos.sequence.consumeNext(pos.ipos, this);
            if (pos.sequence instanceof NodeTree) {
                this.prev = 45;
            }
            return;
        }
        if (v instanceof Consumable && !(v instanceof UnescapedData)) {
            ((Consumable)v).consume(this);
            return;
        }
        if (v instanceof Keyword) {
            this.beginAttribute(((Keyword)v).getName());
            this.prev = -6;
            return;
        }
        this.closeTag();
        if (v instanceof UnescapedData) {
            this.bout.clearWordEnd();
            this.bout.write(((UnescapedData)v).getData());
            this.prev = 45;
        } else if (v instanceof Char) {
            Char.print(((Char)v).intValue(), this);
        } else {
            this.startWord();
            this.prev = 32;
            this.print(v);
            this.writeWordEnd();
            this.prev = -2;
        }
    }

    public boolean ignoring() {
        return false;
    }

    public void write(String str, int start, int length) {
        if (length > 0) {
            this.closeTag();
            int limit = start + length;
            int count = 0;
            while (start < limit) {
                char c;
                if ((c = str.charAt(start++)) >= '\u007f' || c == '\n' || c == '\r' || (this.inComment > 0 ? c == '-' || this.inComment == 2 : c == '<' || c == '>' || c == '&' || this.inAttribute && (c == '\"' || c < ' '))) {
                    if (count > 0) {
                        this.bout.write(str, start - 1 - count, count);
                    }
                    this.write(c);
                    count = 0;
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                this.bout.write(str, limit - count, count);
            }
        }
        this.prev = 45;
    }

    public void write(char[] buf, int off, int len) {
        if (len > 0) {
            this.closeTag();
            int limit = off + len;
            int count = 0;
            while (off < limit) {
                char c;
                if ((c = buf[off++]) >= '\u007f' || c == '\n' || c == '\r' || (this.inComment > 0 ? c == '-' || this.inComment == 2 : c == '<' || c == '>' || c == '&' || this.inAttribute && (c == '\"' || c < ' '))) {
                    if (count > 0) {
                        this.bout.write(buf, off - 1 - count, count);
                    }
                    this.write(c);
                    count = 0;
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                this.bout.write(buf, limit - count, count);
            }
        }
        this.prev = 45;
    }

    public void writePosition(AbstractSequence seq, int ipos) {
        seq.consumeNext(ipos, this);
    }

    public void writeBaseUri(Object uri) {
    }

    public void beginComment() {
        this.closeTag();
        if (this.printIndent >= 0 && (this.prev == -3 || this.prev == -4 || this.prev == -5)) {
            this.writeBreak(this.printIndent > 0 ? 82 : 78);
        }
        this.bout.write("<!--");
        this.inComment = 1;
    }

    public void endComment() {
        this.bout.write("-->");
        this.prev = -5;
        this.inComment = 0;
    }

    public void writeComment(String chars) {
        this.beginComment();
        this.write(chars);
        this.endComment();
    }

    public void writeComment(char[] chars, int offset, int length) {
        this.beginComment();
        this.write(chars, offset, length);
        this.endComment();
    }

    public void writeCDATA(char[] chars, int offset, int length) {
        if (this.canonicalizeCDATA) {
            this.write(chars, offset, length);
            return;
        }
        this.closeTag();
        this.bout.write("<![CDATA[");
        int limit = offset + length;
        for (int i = offset; i < limit - 2; ++i) {
            if (chars[i] != ']' || chars[i + 1] != ']' || chars[i + 2] != '>') continue;
            if (i > offset) {
                this.bout.write(chars, offset, i - offset);
            }
            this.print("]]]><![CDATA[]>");
            offset = i + 3;
            length = limit - offset;
            i += 2;
        }
        this.bout.write(chars, offset, length);
        this.bout.write("]]>");
        this.prev = 62;
    }

    public void writeProcessingInstruction(String target, char[] content, int offset, int length) {
        if ("xml".equals(target)) {
            this.needXMLdecl = false;
        }
        this.closeTag();
        this.bout.write("<?");
        this.print(target);
        this.print(' ');
        this.bout.write(content, offset, length);
        this.bout.write("?>");
        this.prev = 62;
    }

    public void consume(SeqPosition position) {
        position.sequence.consumeNext(position.ipos, this);
    }
}

