/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.AbstractScriptEngineFactory;
import gnu.expr.Compilation;
import gnu.expr.KawaCompiledScript;
import gnu.expr.KawaScriptBindings;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.SimpleEnvironment;
import gnu.text.SourceError;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.ScriptContext;
import javax.script.ScriptException;

public class KawaScriptEngine
extends AbstractScriptEngine
implements Compilable {
    AbstractScriptEngineFactory factory;

    public KawaScriptEngine(AbstractScriptEngineFactory abstractScriptEngineFactory) {
        this.factory = abstractScriptEngineFactory;
        this.context.setBindings(this.createBindings(), 100);
        this.context.setReader(InPort.inDefault());
        this.context.setWriter(OutPort.outDefault());
        this.context.setErrorWriter(OutPort.errDefault());
    }

    public AbstractScriptEngineFactory getFactory() {
        return this.factory;
    }

    public Bindings createBindings() {
        SimpleEnvironment simpleEnvironment = (SimpleEnvironment)this.factory.language.getNewEnvironment();
        KawaScriptBindings kawaScriptBindings = new KawaScriptBindings(simpleEnvironment);
        this.factory.setEnvironment(kawaScriptBindings, simpleEnvironment);
        return kawaScriptBindings;
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.eval(reader instanceof InPort ? (InPort)reader : new InPort(reader), scriptContext);
    }

    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval(new CharArrayInPort(string), scriptContext);
    }

    public Object eval(InPort inPort, ScriptContext scriptContext) throws ScriptException {
        KawaCompiledScript kawaCompiledScript = this.compile(inPort, scriptContext);
        return kawaCompiledScript.eval(scriptContext);
    }

    public KawaCompiledScript compile(String string) throws ScriptException {
        return this.compile(new CharArrayInPort(string), this.getContext());
    }

    public KawaCompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(reader instanceof InPort ? (InPort)reader : new InPort(reader), this.getContext());
    }

    public KawaCompiledScript compile(InPort inPort, ScriptContext scriptContext) throws ScriptException {
        SourceMessages sourceMessages = new SourceMessages();
        try {
            return this.compile(inPort, scriptContext, sourceMessages);
        }
        catch (SyntaxException syntaxException) {
            sourceMessages = syntaxException.getMessages();
            SourceError sourceError = sourceMessages.getErrors();
            if (sourceMessages.seenErrors()) {
                while (sourceError.severity == 'w' && sourceError.next != null) {
                    sourceError = sourceError.next;
                }
            }
            throw new ScriptException(sourceError.message, sourceError.filename, sourceError.line, sourceError.column);
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KawaCompiledScript compile(InPort inPort, ScriptContext scriptContext, SourceMessages sourceMessages) throws SyntaxException, IOException {
        CallContext callContext = CallContext.getInstance();
        Language language = Language.getDefaultLanguage();
        Environment environment = callContext.getEnvironmentRaw();
        Environment environment2 = this.factory.getEnvironment(scriptContext);
        callContext.setEnvironmentRaw(environment2);
        Language.setDefaultLanguage(this.factory.language);
        try {
            Compilation compilation = this.factory.language.parse(inPort, sourceMessages, 1);
            if (sourceMessages.seenErrors()) {
                throw new SyntaxException(sourceMessages);
            }
            ModuleExp moduleExp = compilation.getModule();
            moduleExp.setName("atInteractiveLevel$" + ++ModuleExp.interactiveCounter);
            String string = (String)this.get("javax.script.filename");
            URL uRL = inPort.getPath().toURL();
            Writer writer = scriptContext.getErrorWriter();
            OutPort outPort = writer instanceof OutPort ? (OutPort)writer : new OutPort(writer);
            Object object2 = ModuleExp.evalModule1(environment2, compilation, uRL, outPort);
            KawaCompiledScript kawaCompiledScript = new KawaCompiledScript(this, moduleExp, object2);
            return kawaCompiledScript;
        }
        finally {
            Language.setDefaultLanguage(language);
            callContext.setEnvironmentRaw(environment);
        }
    }
}

