/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Language;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.lispexpr.ReaderDispatch;
import gnu.kawa.lispexpr.ReaderIgnoreRestOfLine;
import gnu.kawa.lispexpr.ReaderParens;
import gnu.kawa.lispexpr.ReaderQuote;
import gnu.kawa.lispexpr.ReaderString;
import gnu.kawa.lispexpr.ReaderTypespec;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.kawa.util.RangeTable;
import gnu.mapping.Environment;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;

public class ReadTable
extends RangeTable {
    public static final int ILLEGAL = 0;
    public static final int WHITESPACE = 1;
    public static final int CONSTITUENT = 2;
    public static final int SINGLE_ESCAPE = 3;
    public static final int MULTIPLE_ESCAPE = 4;
    public static final int TERMINATING_MACRO = 5;
    public static final int NON_TERMINATING_MACRO = 6;
    public static int defaultBracketMode = -1;
    public char postfixLookupOperator = (char)65535;
    protected boolean initialColonIsKeyword;
    protected boolean finalColonIsKeyword;
    static final ThreadLocation current = new ThreadLocation("read-table");
    Environment ctorTable = null;

    public void setInitialColonIsKeyword(boolean bl) {
        this.initialColonIsKeyword = bl;
    }

    public void setFinalColonIsKeyword(boolean bl) {
        this.finalColonIsKeyword = bl;
    }

    public void initialize() {
        ReadTableEntry readTableEntry = ReadTableEntry.getWhitespaceInstance();
        this.set(32, readTableEntry);
        this.set(9, readTableEntry);
        this.set(10, readTableEntry);
        this.set(13, readTableEntry);
        this.set(12, readTableEntry);
        this.set(124, ReadTableEntry.getMultipleEscapeInstance());
        this.set(92, ReadTableEntry.getSingleEscapeInstance());
        this.set(48, 57, ReadTableEntry.getDigitInstance());
        readTableEntry = ReadTableEntry.getConstituentInstance();
        this.set(97, 122, readTableEntry);
        this.set(65, 90, readTableEntry);
        this.set(33, readTableEntry);
        this.set(36, readTableEntry);
        this.set(37, readTableEntry);
        this.set(38, readTableEntry);
        this.set(42, readTableEntry);
        this.set(43, readTableEntry);
        this.set(45, readTableEntry);
        this.set(46, readTableEntry);
        this.set(47, readTableEntry);
        this.set(58, readTableEntry);
        this.set(61, readTableEntry);
        this.set(62, readTableEntry);
        this.set(63, readTableEntry);
        this.set(64, readTableEntry);
        this.set(94, readTableEntry);
        this.set(95, readTableEntry);
        this.set(123, readTableEntry);
        this.set(125, readTableEntry);
        this.set(126, readTableEntry);
        this.set(127, readTableEntry);
        this.set(8, readTableEntry);
        this.set(34, new ReaderString());
        this.set(35, ReaderDispatch.create(this));
        this.set(59, ReaderIgnoreRestOfLine.getInstance());
        this.set(40, ReaderParens.getInstance('(', ')'));
        this.set(39, new ReaderQuote(this.makeSymbol("quote")));
        this.set(96, new ReaderQuote(this.makeSymbol("quasiquote")));
        this.set(44, new ReaderQuote(this.makeSymbol("unquote"), '@', this.makeSymbol("unquote-splicing")));
        this.setBracketMode();
    }

    public static ReadTable createInitial() {
        ReadTable readTable = new ReadTable();
        readTable.initialize();
        return readTable;
    }

    public void setBracketMode(int n) {
        if (n <= 0) {
            ReadTableEntry readTableEntry = ReadTableEntry.getConstituentInstance();
            this.set(60, readTableEntry);
            if (n < 0) {
                this.set(91, readTableEntry);
                this.set(93, readTableEntry);
            }
        } else {
            this.set(60, new ReaderTypespec());
        }
        if (n >= 0) {
            this.set(91, ReaderParens.getInstance('[', ']'));
            this.remove(93);
        }
    }

    public void setBracketMode() {
        this.setBracketMode(defaultBracketMode);
    }

    void initCtorTable() {
        if (this.ctorTable == null) {
            this.ctorTable = Environment.make();
        }
    }

    public synchronized void putReaderCtor(String string, Procedure procedure) {
        this.initCtorTable();
        this.ctorTable.put(string, (Object)procedure);
    }

    public synchronized void putReaderCtorFld(String string, String string2, String string3) {
        this.initCtorTable();
        Symbol symbol = this.ctorTable.getSymbol(string);
        StaticFieldLocation.define(this.ctorTable, symbol, null, string2, string3);
    }

    public synchronized Object getReaderCtor(String string) {
        this.initCtorTable();
        return this.ctorTable.get(string, null);
    }

    public static ReadTable getCurrent() {
        ReadTable readTable = (ReadTable)current.get(null);
        if (readTable == null) {
            Language language = Language.getDefaultLanguage();
            readTable = language instanceof LispLanguage ? ((LispLanguage)language).defaultReadTable : ReadTable.createInitial();
            current.set(readTable);
        }
        return readTable;
    }

    public static void setCurrent(ReadTable readTable) {
        current.set(readTable);
    }

    public ReadTableEntry lookup(int n) {
        ReadTableEntry readTableEntry = (ReadTableEntry)this.lookup(n, null);
        if (readTableEntry == null && n >= 0 && n < 65536) {
            if (Character.isDigit((char)n)) {
                readTableEntry = (ReadTableEntry)this.lookup(48, null);
            } else if (Character.isLowerCase((char)n)) {
                readTableEntry = (ReadTableEntry)this.lookup(97, null);
            } else if (Character.isLetter((char)n)) {
                readTableEntry = (ReadTableEntry)this.lookup(65, null);
            } else if (Character.isWhitespace((char)n)) {
                readTableEntry = (ReadTableEntry)this.lookup(32, null);
            }
            if (readTableEntry == null && n >= 128) {
                readTableEntry = ReadTableEntry.getConstituentInstance();
            }
        }
        return readTableEntry;
    }

    protected Object makeSymbol(String string) {
        return Namespace.EmptyNamespace.getSymbol(string.intern());
    }
}

