/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.Path;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LineBufferedReader
extends Reader {
    protected Reader in;
    public static final int BUFFER_SIZE = 8192;
    public char[] buffer;
    public int pos;
    public int limit;
    int highestPos;
    public char readState = (char)10;
    private int flags;
    private static final int CONVERT_CR = 1;
    private static final int USER_BUFFER = 2;
    private static final int PREV_WAS_CR = 4;
    private static final int DONT_KEEP_FULL_LINES = 8;
    private int lineStartPos;
    Path path;
    protected int lineNumber;
    protected int readAheadLimit = 0;
    protected int markPos;

    public void close() throws IOException {
        this.in.close();
    }

    public char getReadState() {
        return this.readState;
    }

    public void setKeepFullLines(boolean bl) {
        this.flags = bl ? (this.flags &= 0xFFFFFFF7) : (this.flags |= 8);
    }

    public final boolean getConvertCR() {
        return (this.flags & 1) != 0;
    }

    public final void setConvertCR(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public LineBufferedReader(InputStream inputStream) {
        this.in = new InputStreamReader(inputStream);
    }

    public LineBufferedReader(Reader reader) {
        this.in = reader;
    }

    public void lineStart(boolean bl) throws IOException {
    }

    public int fill(int n) throws IOException {
        return this.in.read(this.buffer, this.pos, n);
    }

    private void clearMark() {
        int n;
        this.readAheadLimit = 0;
        int n2 = n = this.lineStartPos < 0 ? 0 : this.lineStartPos;
        while (++n < this.pos) {
            char c = this.buffer[n - 1];
            if (c != '\n' && (c != '\r' || this.getConvertCR() && this.buffer[n] == '\n')) continue;
            ++this.lineNumber;
            this.lineStartPos = n;
        }
    }

    public void setBuffer(char[] cArray) throws IOException {
        if (cArray == null) {
            if (this.buffer != null) {
                cArray = new char[this.buffer.length];
                System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
                this.buffer = cArray;
            }
            this.flags &= 0xFFFFFFFD;
        } else {
            if (this.limit - this.pos > cArray.length) {
                throw new IOException("setBuffer - too short");
            }
            this.flags |= 2;
            this.reserve(cArray, 0);
        }
    }

    private void reserve(char[] cArray, int n) throws IOException {
        int n2;
        if ((n += this.limit) <= cArray.length) {
            n2 = 0;
        } else {
            n2 = this.pos;
            if (this.readAheadLimit > 0 && this.markPos < this.pos) {
                if (this.pos - this.markPos > this.readAheadLimit || (this.flags & 2) != 0 && n - this.markPos > cArray.length) {
                    this.clearMark();
                } else {
                    n2 = this.markPos;
                }
            }
            if ((n -= cArray.length) > n2 || n2 > this.lineStartPos && (this.flags & 8) == 0) {
                if (n <= this.lineStartPos && n2 > this.lineStartPos) {
                    n2 = this.lineStartPos;
                } else if ((this.flags & 2) != 0) {
                    n2 -= n2 - n >> 2;
                } else {
                    if (this.lineStartPos >= 0) {
                        n2 = this.lineStartPos;
                    }
                    cArray = new char[2 * cArray.length];
                }
            }
            this.lineStartPos -= n2;
            this.limit -= n2;
            this.markPos -= n2;
            this.pos -= n2;
            this.highestPos -= n2;
        }
        if (this.limit > 0) {
            System.arraycopy(this.buffer, n2, cArray, 0, this.limit);
        }
        this.buffer = cArray;
    }

    public int read() throws IOException {
        int n;
        int n2 = this.pos > 0 ? this.buffer[this.pos - 1] : ((this.flags & 4) != 0 ? 13 : (this.lineStartPos >= 0 ? 10 : 0));
        if (n2 == 13 || n2 == 10) {
            if (this.lineStartPos < this.pos && (this.readAheadLimit == 0 || this.pos <= this.markPos)) {
                this.lineStartPos = this.pos;
                ++this.lineNumber;
            }
            int n3 = n = this.pos < this.highestPos ? 1 : 0;
            if (n2 != 10 || (this.pos <= 1 ? (this.flags & 4) == 0 : this.buffer[this.pos - 2] != '\r')) {
                this.lineStart(n != 0);
            }
            if (n == 0) {
                this.highestPos = this.pos + 1;
            }
        }
        if (this.pos >= this.limit) {
            if (this.buffer == null) {
                this.buffer = new char[8192];
            } else if (this.limit == this.buffer.length) {
                this.reserve(this.buffer, 1);
            }
            if (this.pos == 0) {
                this.flags = n2 == 13 ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
            }
            if ((n = this.fill(this.buffer.length - this.pos)) <= 0) {
                return -1;
            }
            this.limit += n;
        }
        if ((n = this.buffer[this.pos++]) == 10) {
            if (n2 == 13) {
                if (this.lineStartPos == this.pos - 1) {
                    --this.lineNumber;
                    --this.lineStartPos;
                }
                if (this.getConvertCR()) {
                    return this.read();
                }
            }
        } else if (n == 13 && this.getConvertCR()) {
            return 10;
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.pos >= this.limit ? 0 : (this.pos > 0 ? this.buffer[this.pos - 1] : ((this.flags & 4) != 0 || this.lineStartPos >= 0 ? 10 : 0));
        int n4 = n2;
        while (n4 > 0) {
            if (this.pos >= this.limit || n3 == 10 || n3 == 13) {
                if (this.pos >= this.limit && n4 < n2) {
                    return n2 - n4;
                }
                n3 = this.read();
                if (n3 < 0) {
                    return (n2 -= n4) <= 0 ? -1 : n2;
                }
                cArray[n++] = (char)n3;
                --n4;
                continue;
            }
            int n5 = this.limit;
            int n6 = this.pos;
            if (n4 < n5 - n6) {
                n5 = n6 + n4;
            }
            while (n6 < n5 && (n3 = this.buffer[n6]) != 10 && n3 != 13) {
                cArray[n++] = (char)n3;
                ++n6;
            }
            n4 -= n6 - this.pos;
            this.pos = n6;
        }
        return n2;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getName() {
        return this.path == null ? null : this.path.toString();
    }

    public void setName(Object object2) {
        this.setPath(Path.valueOf(object2));
    }

    public int getLineNumber() {
        int n = this.lineNumber;
        if (this.readAheadLimit == 0) {
            char c;
            if (this.pos > 0 && this.pos > this.lineStartPos && ((c = this.buffer[this.pos - 1]) == '\n' || c == '\r')) {
                ++n;
            }
        } else {
            n += LineBufferedReader.countLines(this.buffer, this.lineStartPos < 0 ? 0 : this.lineStartPos, this.pos);
        }
        return n;
    }

    public void setLineNumber(int n) {
        this.lineNumber += n - this.getLineNumber();
    }

    public void incrLineNumber(int n, int n2) {
        this.lineNumber += n;
        this.lineStartPos = n2;
    }

    public int getColumnNumber() {
        int n;
        if (this.pos > 0 && ((n = this.buffer[this.pos - 1]) == 10 || n == 13)) {
            return 0;
        }
        if (this.readAheadLimit <= 0) {
            return this.pos - this.lineStartPos;
        }
        int n2 = n = this.lineStartPos < 0 ? 0 : this.lineStartPos;
        while (n2 < this.pos) {
            char c;
            if ((c = this.buffer[n2++]) != '\n' && c != '\r') continue;
            n = n2;
        }
        n2 = this.pos - n;
        if (this.lineStartPos < 0) {
            n2 -= this.lineStartPos;
        }
        return n2;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int n) {
        if (this.readAheadLimit > 0) {
            this.clearMark();
        }
        this.readAheadLimit = n;
        this.markPos = this.pos;
    }

    public void reset() throws IOException {
        if (this.readAheadLimit <= 0) {
            throw new IOException("mark invalid");
        }
        if (this.pos > this.highestPos) {
            this.highestPos = this.pos;
        }
        this.pos = this.markPos;
        this.readAheadLimit = 0;
    }

    public void readLine(StringBuffer stringBuffer, char c) throws IOException {
        int n;
        while ((n = this.read()) >= 0) {
            int n2 = --this.pos;
            while (this.pos < this.limit) {
                if ((n = this.buffer[this.pos++]) != 13 && n != 10) continue;
                stringBuffer.append(this.buffer, n2, this.pos - 1 - n2);
                if (c == 'P') {
                    --this.pos;
                    return;
                }
                if (this.getConvertCR() || n == 10) {
                    if (c != 'I') {
                        stringBuffer.append('\n');
                    }
                } else {
                    if (c != 'I') {
                        stringBuffer.append('\r');
                    }
                    if ((n = this.read()) == 10) {
                        if (c != 'I') {
                            stringBuffer.append('\n');
                        }
                    } else if (n >= 0) {
                        this.unread_quick();
                    }
                }
                return;
            }
            stringBuffer.append(this.buffer, n2, this.pos - n2);
        }
        return;
    }

    public String readLine() throws IOException {
        int n = this.read();
        if (n < 0) {
            return null;
        }
        if (n == 13 || n == 10) {
            return "";
        }
        int n2 = this.pos - 1;
        while (this.pos < this.limit) {
            if ((n = this.buffer[this.pos++]) != 13 && n != 10) continue;
            int n3 = this.pos - 1;
            if (n != 10 && !this.getConvertCR()) {
                if (this.pos >= this.limit) {
                    --this.pos;
                    break;
                }
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            }
            return new String(this.buffer, n2, n3 - n2);
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.buffer, n2, this.pos - n2);
        this.readLine(stringBuffer, 'I');
        return stringBuffer.toString();
    }

    public int skip(int n) throws IOException {
        if (n < 0) {
            int n2;
            for (n2 = -n; n2 > 0 && this.pos > 0; --n2) {
                this.unread();
            }
            return n + n2;
        }
        int n3 = n;
        int n4 = this.pos >= this.limit ? 0 : (this.pos > 0 ? this.buffer[this.pos - 1] : ((this.flags & 4) != 0 || this.lineStartPos >= 0 ? 10 : 0));
        while (n3 > 0) {
            if (n4 == 10 || n4 == 13 || this.pos >= this.limit) {
                n4 = this.read();
                if (n4 < 0) {
                    return n - n3;
                }
                --n3;
                continue;
            }
            int n5 = this.limit;
            int n6 = this.pos;
            if (n3 < n5 - n6) {
                n5 = n6 + n3;
            }
            while (n6 < n5 && (n4 = this.buffer[n6]) != 10 && n4 != 13) {
                ++n6;
            }
            n3 -= n6 - this.pos;
            this.pos = n6;
        }
        return n;
    }

    public boolean ready() throws IOException {
        return this.pos < this.limit || this.in.ready();
    }

    public final void skip_quick() throws IOException {
        ++this.pos;
    }

    public void skip() throws IOException {
        this.read();
    }

    static int countLines(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            int n5 = cArray[i];
            if (n5 == 10 && n4 != 13 || n5 == 13) {
                ++n3;
            }
            n4 = n5;
        }
        return n3;
    }

    public void skipRestOfLine() throws IOException {
        int n;
        do {
            if ((n = this.read()) < 0) {
                return;
            }
            if (n != 13) continue;
            n = this.read();
            if (n < 0 || n == 10) break;
            this.unread();
            break;
        } while (n != 10);
    }

    public void unread() throws IOException {
        if (this.pos == 0) {
            throw new IOException("unread too much");
        }
        --this.pos;
        char c = this.buffer[this.pos];
        if (c == '\n' || c == '\r') {
            if (this.pos > 0 && c == '\n' && this.getConvertCR() && this.buffer[this.pos - 1] == '\r') {
                --this.pos;
            }
            if (this.pos < this.lineStartPos) {
                --this.lineNumber;
                int n = this.pos;
                while (n > 0) {
                    if ((c = this.buffer[--n]) != '\r' && c != '\n') continue;
                    ++n;
                    break;
                }
                this.lineStartPos = n;
            }
        }
    }

    public void unread_quick() {
        --this.pos;
    }

    public int peek() throws IOException {
        int n;
        if (this.pos < this.limit && this.pos > 0 && (n = this.buffer[this.pos - 1]) != 10 && n != 13) {
            n = this.buffer[this.pos];
            if (n == 13 && this.getConvertCR()) {
                n = 10;
            }
            return n;
        }
        n = this.read();
        if (n >= 0) {
            this.unread_quick();
        }
        return n;
    }
}

