/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.MultiplyOp;
import gnu.lists.AbstractSequence;
import gnu.lists.IntSequence;
import gnu.lists.Sequence;
import gnu.math.IntNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class Range<E>
extends AbstractSequence<E>
implements Sequence<E> {
    E start;
    Object step;
    int size;

    public Range(E start, Object step, int size) {
        this.start = start;
        this.step = step;
        this.size = size;
    }

    public E getStart() {
        return this.start;
    }

    public Object getStep() {
        return this.step;
    }

    @Override
    public E get(int index) {
        if (index >= this.size && this.size >= 0) {
            throw new IndexOutOfBoundsException();
        }
        return (E)AddOp.$Pl(this.start, MultiplyOp.apply(index, this.step));
    }

    @Override
    public int size() {
        return this.size;
    }

    boolean isUnbounded() {
        return this.size == -1;
    }

    public static void listAll(Range r) {
        int i = 0;
        for (Object x : r) {
            System.err.println("[" + i++ + "]: " + r);
        }
    }

    @Override
    public String toString() {
        return "#<range start:" + this.getStart() + " step:" + this.getStep() + " size:" + this.size + ">";
    }

    public static Range<?> valueOfUnbounded(Object start) {
        IntNum iistart = IntNum.asIntNumOrNull(start);
        if (iistart != null && iistart.inIntRange()) {
            int istart = iistart.intValue();
            return new IntRange(istart, 1);
        }
        return new Range<Object>(start, IntNum.one(), -1);
    }

    public static Range<?> valueOfLT(Object start, Object end) {
        IntNum iistart = IntNum.asIntNumOrNull(start);
        IntNum iiend = IntNum.asIntNumOrNull(end);
        if (iistart != null && iiend != null && iistart.inIntRange() && iiend.inIntRange()) {
            int istart = iistart.intValue();
            int iend = iiend.intValue();
            if (iend >= istart) {
                return new IntRange(istart, 1, iend - istart);
            }
        } else {
            int size = ((Number)AddOp.$Mn(end, start)).intValue();
            if (size >= 0) {
                return new Range<Object>(start, IntNum.one(), size);
            }
        }
        throw new IndexOutOfBoundsException("start index " + start + " is greater than end index " + end);
    }

    public static Range<?> valueOfLE(Object start, Object end) {
        IntNum iistart = IntNum.asIntNumOrNull(start);
        IntNum iiend = IntNum.asIntNumOrNull(end);
        if (iistart != null && iiend != null && iistart.inIntRange() && iiend.inIntRange() && iiend.intValue() != Integer.MAX_VALUE) {
            int istart = iistart.intValue();
            int iend = iiend.intValue() + 1;
            if (iend >= istart) {
                return new IntRange(istart, 1, iend - istart);
            }
        } else {
            int size = ((Number)AddOp.$Mn(end, start)).intValue() + 1;
            if (size >= 0) {
                return new Range<Object>(start, IntNum.one(), size);
            }
        }
        throw new IndexOutOfBoundsException("size (end-start+1 or " + end + "-" + start + "+1) is negative");
    }

    public static Range<?> valueOfGT(Object start, Object end) {
        if (start instanceof Integer && end instanceof Integer) {
            int istart = (Integer)start;
            int iend = (Integer)end;
            if (iend <= istart) {
                return new IntRange(istart, -1, iend - istart);
            }
        } else {
            int size = ((Number)AddOp.$Mn(start, end)).intValue();
            if (size >= 0) {
                return new Range<Object>(start, IntNum.minusOne(), size);
            }
        }
        throw new IndexOutOfBoundsException("start index " + start + " is less than end index " + end);
    }

    public static Range<?> valueOfGE(Object start, Object end) {
        if (start instanceof Integer && end instanceof Integer) {
            int istart = (Integer)start;
            int iend = (Integer)end;
            if (iend <= istart) {
                return new IntRange(istart, -1, iend - istart + 1);
            }
        } else {
            int size = ((Number)AddOp.$Mn(start, end)).intValue() + 1;
            if (size >= 0) {
                return new Range<Object>(start, IntNum.minusOne(), size);
            }
        }
        throw new IndexOutOfBoundsException("size (start-end+1 or " + start + "-" + end + "+1) is negative");
    }

    public static class IntRange
    extends Range<Integer>
    implements IntSequence,
    Externalizable {
        int istart;
        int istep;
        public static final IntRange cantWriteMarker = new IntRange(0, 1);

        public IntRange(int start, int step, int size) {
            super(start, step, size);
            this.istart = start;
            this.istep = step;
        }

        public IntRange(int start, int step) {
            super(start, step, -1);
            this.istart = start;
            this.istep = step;
        }

        public int getStartInt() {
            return this.istart;
        }

        public int getStepInt() {
            return this.istep;
        }

        @Override
        public int intAt(int index) {
            if (index >= this.size && this.size >= 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.istart + this.istep * index;
        }

        public IntRange subListFromRange(int rstart, int rstep, int rsize) {
            int nsize;
            int nstart = this.istart + rstart * this.istep;
            int nstep = this.istep * rstep;
            if (this.isUnbounded() && rsize == -1) {
                return new IntRange(nstart, nstep);
            }
            if (this.isUnbounded()) {
                nsize = rsize;
            } else {
                nsize = (this.size - rstart + rstep - 1) / rstep;
                if (rsize != -1) {
                    if (rsize > nsize) {
                        throw new IndexOutOfBoundsException();
                    }
                    nsize = rsize;
                }
            }
            return new IntRange(nstart, nstep, nsize);
        }

        @Override
        public IntRange subList(int fromIx, int toIx) {
            return this.subListFromRange(fromIx, 1, toIx - fromIx);
        }

        @Override
        public Integer getStart() {
            return this.getStartInt();
        }

        @Override
        public Integer get(int index) {
            return this.intAt(index);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this == cantWriteMarker ? -2 : this.size);
            out.writeInt(this.istart);
            out.writeInt(this.istep);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.size = in.readInt();
            this.istart = in.readInt();
            this.istep = in.readInt();
        }

        public Object readResolve() throws ObjectStreamException {
            return this.size == -2 ? cantWriteMarker : this;
        }
    }
}

