/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib.kawa;

import gnu.bytecode.Type;
import gnu.expr.CompiledProc;
import gnu.expr.ModuleBody;
import gnu.expr.Special;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.MultiplyOp;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.lists.IString;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.Procedure;
import gnu.mapping.Promise;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Quantity;
import gnu.math.Quaternion;
import gnu.math.RealNum;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import kawa.lib.exceptions;
import kawa.lib.numbers;

public class quaternions
extends ModuleBody {
    public static final StaticFieldLocation quaternion;
    public static final StaticFieldLocation quaternion$Qu;
    public static final StaticFieldLocation real$Mnpart;
    public static final StaticFieldLocation imag$Mnpart;
    public static final StaticFieldLocation jmag$Mnpart;
    public static final StaticFieldLocation kmag$Mnpart;
    public static final CompiledProc complex$Mnpart;
    public static final CompiledProc vector$Mnpart;
    public static final CompiledProc unit$Mnquaternion;
    public static final StaticFieldLocation unit$Mnvector;
    public static final CompiledProc vector$Mnquaternion$Qu;
    public static final CompiledProc make$Mnvector$Mnquaternion;
    public static final CompiledProc vector$Mnquaternion$Mn$Grlist;
    public static final StaticFieldLocation magnitude;
    public static final StaticFieldLocation angle;
    public static final CompiledProc colatitude;
    public static final CompiledProc longitude;
    public static final StaticFieldLocation make$Mnrectangular;
    public static final StaticFieldLocation make$Mnpolar;
    public static final StaticFieldLocation $Pl;
    public static final StaticFieldLocation $Mn;
    public static final StaticFieldLocation $St;
    public static final StaticFieldLocation $Sl;
    public static final CompiledProc dot$Mnproduct;
    public static final CompiledProc cross$Mnproduct;
    public static final CompiledProc conjugate;
    public static final StaticFieldLocation exp;
    public static final StaticFieldLocation log;
    public static final StaticFieldLocation expt;
    public static final StaticFieldLocation sqrt;
    public static final StaticFieldLocation sin;
    public static final StaticFieldLocation cos;
    public static final StaticFieldLocation tan;
    public static final StaticFieldLocation asin;
    public static final StaticFieldLocation acos;
    public static final StaticFieldLocation atan;
    static final IntNum Lit0;
    static final IntNum Lit1;
    static final IntNum Lit2;
    static final DFloNum Lit3;
    static final SimpleSymbol Lit4;
    static final IString Lit5;
    static final SimpleSymbol Lit6;
    static final SimpleSymbol Lit7;
    static final SimpleSymbol Lit8;
    static final SimpleSymbol Lit9;
    static final SimpleSymbol Lit10;
    static final SimpleSymbol Lit11;
    static final SimpleSymbol Lit12;
    static final SimpleSymbol Lit13;
    static final SimpleSymbol Lit14;
    static final SimpleSymbol Lit15;

    private static void $runBody$() {
    }

    public static Complex complexPart(Number x) {
        return x instanceof Quaternion ? ((Quaternion)x).complexPart() : (Complex)x;
    }

    public static Object complexPart$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object2 instanceof Number)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Number number = (Number)object2;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.complexPart(number);
    }

    public static Quaternion vectorPart(Number x) {
        return x instanceof Quaternion ? ((Quaternion)x).vectorPart() : Lit0;
    }

    public static Object vectorPart$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object2 instanceof Number)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Number number = (Number)object2;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.vectorPart(number);
    }

    public static Number colatitude(Number x) {
        return x instanceof Quaternion ? ((Quaternion)x).colatitude() : Lit0;
    }

    public static Object colatitude$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object2 instanceof Number)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Number number = (Number)object2;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.colatitude(number);
    }

    public static Number longitude(Number x) {
        return x instanceof Quaternion ? ((Quaternion)x).longitude() : Lit0;
    }

    public static Object longitude$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object2 instanceof Number)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Number number = (Number)object2;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.longitude(number);
    }

    /*
     * Loose catch block
     */
    public static Number unitQuaternion(Number x) {
        Number number;
        Number number2;
        Quantity quantity;
        block12: {
            if (x instanceof Quaternion) {
                quantity = ((Quaternion)x).unitQuaternion();
            } else {
                if (x instanceof Quantity) {
                    number2 = quaternions.unitQuaternion(((Quantity)x).number());
                    quantity = Quantity.make((Quaternion)number2, ((Quantity)x).unit());
                }
                if (numbers.isZero(x)) {
                    quantity = Lit0;
                } else {
                    number = x;
                    if (numbers.isNegative(LangObjType.coerceRealNum(number))) {
                        quantity = Lit1;
                        break block12;
                    }
                    number = x;
                    quantity = numbers.isPositive(LangObjType.coerceRealNum(number)) ? Lit2 : Lit3;
                }
            }
        }
        return quantity;
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.math.Quantity.make(gnu.math.Quaternion,gnu.math.Unit)", 1, (Object)number2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "negative?", 1, (Object)number);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "positive?", 1, (Object)number);
        }
    }

    public static Object unitQuaternion$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object2 instanceof Number)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Number number = (Number)object2;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.unitQuaternion(number);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVectorQuaternion(Object o) {
        boolean bl;
        if (!numbers.isQuaternion(o)) return false;
        Object object2 = Promise.force(o, Number.class);
        try {
            bl = numbers.isZero(numbers.realPart((Number)object2));
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "real-part", 1, object2);
        }
        return bl;
    }

    public static Object isVectorQuaternion$check(Procedure procedure, CallContext callContext) {
        Object object2 = callContext.getNextArg();
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.isVectorQuaternion(object2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Quaternion makeVectorQuaternion(RealNum x, RealNum y, RealNum z) {
        return (Quaternion)Promise.force(numbers.make$Mnrectangular.apply4(Lit0, x, y, z), Quaternion.class);
    }

    public static Object makeVectorQuaternion$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), RealNum.class);
        RealNum realNum = RealNum.asRealNumOrNull(object2);
        if (realNum != null) {
            Object object3 = Promise.force(callContext.getNextArg(), RealNum.class);
            RealNum realNum2 = RealNum.asRealNumOrNull(object3);
            if (realNum2 != null) {
                Object object4 = Promise.force(callContext.getNextArg(), RealNum.class);
                RealNum realNum3 = RealNum.asRealNumOrNull(object4);
                if (realNum3 != null) {
                    if (callContext.checkDone() != 0) {
                        return callContext;
                    }
                    return quaternions.makeVectorQuaternion(realNum, realNum2, realNum3);
                }
                CallContext callContext2 = callContext;
                callContext2.matchError(-786430);
                return callContext2;
            }
            CallContext callContext3 = callContext;
            callContext3.matchError(-786431);
            return callContext3;
        }
        CallContext callContext4 = callContext;
        callContext4.matchError(-786432);
        return callContext4;
    }

    public static LList vectorQuaternion$To$List(Quaternion vec) {
        return LList.list3(numbers.imagPart(vec), numbers.jmagPart(vec), numbers.kmagPart(vec));
    }

    public static Object vectorQuaternion$To$List$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Quaternion.class);
        if (!(object2 instanceof Quaternion)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Quaternion quaternion = (Quaternion)object2;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.vectorQuaternion$To$List(quaternion);
    }

    public static RealNum dotProduct(Number x, Number y) {
        if (!quaternions.isVectorQuaternion(x) || !quaternions.isVectorQuaternion(y)) {
            Type.NeverReturns neverReturns = exceptions.error(Lit4, Lit5);
            throw Special.reachedUnexpected;
        }
        return LangObjType.coerceRealNum(Promise.force(AddOp.apply2(1, AddOp.apply2(1, MultiplyOp.$St.apply2(numbers.imagPart(x), numbers.imagPart(y)), MultiplyOp.$St.apply2(numbers.jmagPart(x), numbers.jmagPart(y))), MultiplyOp.$St.apply2(numbers.kmagPart(x), numbers.kmagPart(y))), RealNum.class));
    }

    public static Object dotProduct$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object2 instanceof Number)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Number number = (Number)object2;
        Object object3 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object3 instanceof Number)) {
            callContext.matchError(-786431);
            return callContext;
        }
        Number number2 = (Number)object3;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.dotProduct(number, number2);
    }

    public static Quaternion crossProduct(Number x, Number y) {
        if (!quaternions.isVectorQuaternion(x) || !quaternions.isVectorQuaternion(y)) {
            Type.NeverReturns neverReturns = exceptions.error(Lit6, Lit5);
            throw Special.reachedUnexpected;
        }
        Object object2 = Promise.force(MultiplyOp.$St.apply2(x, y), Number.class);
        try {
            return quaternions.vectorPart((Number)object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "vector-part", 0, object2);
        }
    }

    public static Object crossProduct$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object2 instanceof Number)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Number number = (Number)object2;
        Object object3 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object3 instanceof Number)) {
            callContext.matchError(-786431);
            return callContext;
        }
        Number number2 = (Number)object3;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.crossProduct(number, number2);
    }

    public static Number conjugate(Number x) {
        Number number;
        return x instanceof Quaternion ? ((Quaternion)x).conjugate() : number;
    }

    public static Object conjugate$check(Procedure procedure, CallContext callContext) {
        Object object2 = Promise.force(callContext.getNextArg(), Number.class);
        if (!(object2 instanceof Number)) {
            callContext.matchError(-786432);
            return callContext;
        }
        Number number = (Number)object2;
        if (callContext.checkDone() != 0) {
            return callContext;
        }
        return quaternions.conjugate(number);
    }

    static {
        Lit15 = Symbol.valueOf("conjugate");
        Lit14 = Symbol.valueOf("vector-quaternion->list");
        Lit13 = Symbol.valueOf("make-vector-quaternion");
        Lit12 = Symbol.valueOf("vector-quaternion?");
        Lit11 = Symbol.valueOf("unit-quaternion");
        Lit10 = Symbol.valueOf("longitude");
        Lit9 = Symbol.valueOf("colatitude");
        Lit8 = Symbol.valueOf("vector-part");
        Lit7 = Symbol.valueOf("complex-part");
        Lit6 = Symbol.valueOf("cross-product");
        Lit5 = IString.valueOf("arguments must be vector quaternions");
        Lit4 = Symbol.valueOf("dot-product");
        Lit3 = DFloNum.valueOf(Double.NaN);
        Lit2 = IntNum.valueOf(1);
        Lit1 = IntNum.valueOf(-1);
        Lit0 = IntNum.valueOf(0);
        $St = StaticFieldLocation.make("gnu.kawa.functions.MultiplyOp", "$St");
        $Pl = StaticFieldLocation.make("gnu.kawa.functions.AddOp", "$Pl");
        $Mn = StaticFieldLocation.make("gnu.kawa.functions.AddOp", "$Mn");
        $Sl = StaticFieldLocation.make("gnu.kawa.functions.DivideOp", "$Sl");
        expt = StaticFieldLocation.make("kawa.standard.expt", "expt");
        angle = StaticFieldLocation.make("kawa.lib.numbers", "angle");
        magnitude = StaticFieldLocation.make("kawa.lib.numbers", "magnitude");
        imag$Mnpart = StaticFieldLocation.make("kawa.lib.numbers", "imag$Mnpart");
        real$Mnpart = StaticFieldLocation.make("kawa.lib.numbers", "real$Mnpart");
        make$Mnpolar = StaticFieldLocation.make("kawa.lib.numbers", "make$Mnpolar");
        make$Mnrectangular = StaticFieldLocation.make("kawa.lib.numbers", "make$Mnrectangular");
        acos = StaticFieldLocation.make("kawa.lib.numbers", "acos");
        asin = StaticFieldLocation.make("kawa.lib.numbers", "asin");
        atan = StaticFieldLocation.make("kawa.lib.numbers", "atan");
        cos = StaticFieldLocation.make("kawa.lib.numbers", "cos");
        exp = StaticFieldLocation.make("kawa.lib.numbers", "exp");
        log = StaticFieldLocation.make("kawa.lib.numbers", "log");
        sin = StaticFieldLocation.make("kawa.lib.numbers", "sin");
        sqrt = StaticFieldLocation.make("kawa.lib.numbers", "sqrt");
        tan = StaticFieldLocation.make("kawa.lib.numbers", "tan");
        quaternion = StaticFieldLocation.make("kawa.lib.numbers", "quaternion");
        quaternion$Qu = StaticFieldLocation.make("kawa.lib.numbers", "quaternion$Qu");
        unit$Mnvector = StaticFieldLocation.make("kawa.lib.numbers", "unit$Mnvector");
        jmag$Mnpart = StaticFieldLocation.make("kawa.lib.numbers", "jmag$Mnpart");
        kmag$Mnpart = StaticFieldLocation.make("kawa.lib.numbers", "kmag$Mnpart");
        Class<quaternions> clazz = quaternions.class;
        complex$Mnpart = CompiledProc.makeResultToObject(clazz, cfr_ldc_0(), Lit7, 4097);
        vector$Mnpart = CompiledProc.makeResultToObject(clazz, cfr_ldc_1(), Lit8, 4097);
        colatitude = CompiledProc.makeResultToObject(clazz, cfr_ldc_2(), Lit9, 4097);
        longitude = CompiledProc.makeResultToObject(clazz, cfr_ldc_3(), Lit10, 4097);
        unit$Mnquaternion = CompiledProc.makeResultToObject(clazz, cfr_ldc_4(), Lit11, 4097);
        vector$Mnquaternion$Qu = CompiledProc.makeResultToObject(clazz, cfr_ldc_5(), Lit12, 4097);
        make$Mnvector$Mnquaternion = CompiledProc.makeResultToObject(clazz, cfr_ldc_6(), Lit13, 12291);
        vector$Mnquaternion$Mn$Grlist = CompiledProc.makeResultToObject(clazz, cfr_ldc_7(), Lit14, 4097);
        dot$Mnproduct = CompiledProc.makeResultToObject(clazz, cfr_ldc_8(), Lit4, 8194);
        cross$Mnproduct = CompiledProc.makeResultToObject(clazz, cfr_ldc_9(), Lit6, 8194);
        conjugate = CompiledProc.makeResultToObject(clazz, cfr_ldc_10(), Lit15, 4097);
        quaternions.$runBody$();
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "complexPart$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_1() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "vectorPart$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_2() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "colatitude$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_3() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "longitude$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_4() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "unitQuaternion$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_5() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "isVectorQuaternion$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_6() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "makeVectorQuaternion$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_7() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "vectorQuaternion$To$List$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_8() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "dotProduct$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_9() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "crossProduct$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_10() {
        try {
            return MethodHandles.lookup().findStatic(quaternions.class, "conjugate$check", MethodType.fromMethodDescriptorString("(Lgnu/mapping/Procedure;Lgnu/mapping/CallContext;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }
}

