function complainif_notposint(var,varname,callfun)

if nargin<3
    callfun = mfilename;
end

if  isempty(var) || ~isscalar(var) || ~isnumeric(var) || var<=0 || ...
        ( ~isinf(var) && rem(var,1)~=0 )
   error('%s: %s should be a positive integer.',upper(callfun),varname);
end

%-*- texinfo -*-
%@deftypefn {Function} complainif_notposint
%@verbatim
%@end verbatim
%@strong{Url}: @url{http://ltfat.github.io/doc/comp/complainif_notposint.html}
%@end deftypefn

% Copyright (C) 2005-2016 Peter L. Soendergaard <peter@sonderport.dk>.
% This file is part of LTFAT version 2.2.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

