# Localized Address Formats

Address formats can be a tricky thing. KContacts tries very hard to perfectly fit
the needs of ~95% of users and to be at least sufficient for the other 5%.

The formatting of an address depends on the destination country as well as on
the origin country of a letter. Basically, the part indicating the destination
country follows the rules of the country of origin, all the rest follows the
rules of the destination country. So we need to store for every country a) the
country positioning and b) the address formatting.

Address formats should usually be stored in a country's entry.desktop. There we
store the country position in field "AddressCountryPosition" and the address
format in a field "AddressFormat". Note that for most countries one field
"AddressFormat" is sufficient for personal as well as company addresses
(because personal addresses look just like business addresses without company);
however, in some countries (eg. Hungary) business addresses differ in their
structure. In this case you have the possibility of adding another field
"BusinessAddressFormat" which will be preferred for formatting of business
addresses; if KContacts can't find such a field, it will fall back to
"AddressFormat". (Please use BusinessAddressFormat ONLY if you really need to)

The format consists mainly of tags that will be replaced by address fields.
The list of tags may grow in the future, the format *might* change in the near
future, but I hope not.

Any comments very very welcome to kde-pim@kde.org or to jost@schenck.de.

-Jost.

## Fields AddressFormat and BusinessAddressFormat

```
%n  = real name
%N  = REAL NAME
%cm = company
%CM = COMPANY
%s  = street
%S  = STREET
%z  = zip code
%l  = location
%L  = LOCATION
%r  = region
%R  = REGION
%p  = post office box
%,  = conditional comma+whitespace, 
      will be left out if the value left or right of it is purged
%w  = conditional whitespace,
      will be left out if the value left or right of it is purged
%0(...) = the text inside the brackets will be completely purged if not
      at least one tag inside it evaluates to something. Example: when the
      address doesn't have a postbox, the string %0(PO Box %p) will not 
      evaluate to "PO Box " but to an empty string.
\n  = newline
```

## Field AddressCountryPosition

```
below = country name below rest of address
BELOW = country name below in capital letters
above = country name above rest of address
ABOVE = country name above in capital letters
```

## Some Tips

- You sometimes have three fields in a line which can all be empty. If you eg.
separate them all with conditional whitespace (same goes for cond. comma) like
in "%z%w%r%w%l" and only the middle value (here: region) is empty, there will
be no whitespace at all between the outer values (here: zipcode and location).
To avoid this, combine two of these values with purge brackets: %0(%z%w%r)%w%l. 
