/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.TorrentUploadManager;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentEvent;
import org.limewire.bittorrent.TorrentEventType;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentState;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.bittorrent.util.TorrentUtil;
import org.limewire.concurrent.ManagedThread;
import org.limewire.listener.EventListener;

public class BTUploader
implements Uploader,
EventListener<TorrentEvent> {
    private final ActivityCallback activityCallback;
    private final Torrent torrent;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private volatile URN urn = null;
    private final TorrentUploadManager torrentUploadManager;
    private final TorrentManager torrentManager;

    public BTUploader(Torrent torrent, ActivityCallback activityCallback, TorrentUploadManager torrentUploadManager, TorrentManager torrentManager) {
        this.torrent = torrent;
        this.activityCallback = activityCallback;
        this.torrentUploadManager = torrentUploadManager;
        this.torrentManager = torrentManager;
    }

    public void registerTorrentListener() {
        this.torrent.addListener(this);
    }

    @Override
    public void handleEvent(TorrentEvent event) {
        if (event.getType() == TorrentEventType.STOPPED) {
            if (!this.finished.get()) {
                this.cancel();
            } else {
                this.remove();
            }
        } else if (event.getType() == TorrentEventType.STATUS_CHANGED) {
            boolean finished = this.torrent.isFinished();
            float seedRatio = this.torrent.getSeedRatio();
            TorrentStatus status = this.torrent.getStatus();
            int seedTime = status != null ? status.getSeedingTime() : 0;
            float targetSeedRatio = this.torrentManager.getTorrentManagerSettings().getSeedRatioLimit();
            int targetSeedTime = this.torrentManager.getTorrentManagerSettings().getSeedTimeLimit();
            if (finished && (seedRatio >= targetSeedRatio || seedTime >= targetSeedTime)) {
                this.finished.set(true);
                this.torrent.stop();
            }
        }
    }

    private void cancel() {
        this.cancelled.set(true);
        this.remove();
    }

    private void remove() {
        this.torrent.removeListener(this);
        this.torrentUploadManager.removeMemento(this.torrent);
        this.activityCallback.uploadComplete(this);
    }

    @Override
    public void stop() {
        new ManagedThread(new Runnable(){

            @Override
            public void run() {
                BTUploader.this.torrent.stop();
            }
        }, "BTUploader Stop Torrent").start();
        this.cancel();
    }

    @Override
    public String getFileName() {
        return this.torrent.getName();
    }

    @Override
    public long getFileSize() {
        TorrentStatus status = this.torrent.getStatus();
        long fileSize = status != null ? status.getTotalWanted() : -1L;
        return fileSize;
    }

    @Override
    public FileDesc getFileDesc() {
        return null;
    }

    @Override
    public int getIndex() {
        return 0 - Math.abs(this.hashCode());
    }

    @Override
    public long amountUploaded() {
        return this.torrent.getTotalUploaded();
    }

    @Override
    public long getTotalAmountUploaded() {
        return this.torrent.getTotalUploaded();
    }

    @Override
    public String getHost() {
        return "";
    }

    @Override
    public Uploader.UploadStatus getState() {
        if (this.cancelled.get()) {
            return Uploader.UploadStatus.CANCELLED;
        }
        if (this.finished.get()) {
            return Uploader.UploadStatus.COMPLETE;
        }
        TorrentStatus status = this.torrent.getStatus();
        if (status == null) {
            return Uploader.UploadStatus.CONNECTING;
        }
        if (!this.torrent.isStarted()) {
            return Uploader.UploadStatus.QUEUED;
        }
        if (status.isError()) {
            return Uploader.UploadStatus.UNAVAILABLE_RANGE;
        }
        if (status.isPaused()) {
            return Uploader.UploadStatus.PAUSED;
        }
        TorrentState state = status.getState();
        switch (state) {
            case DOWNLOADING: 
            case FINISHED: 
            case SEEDING: {
                return Uploader.UploadStatus.UPLOADING;
            }
            case QUEUED_FOR_CHECKING: 
            case CHECKING_FILES: 
            case DOWNLOADING_METADATA: 
            case ALLOCATING: {
                return Uploader.UploadStatus.CONNECTING;
            }
        }
        throw new UnsupportedOperationException("Unknown state: " + (Object)((Object)state));
    }

    @Override
    public Uploader.UploadStatus getLastTransferState() {
        return this.getState();
    }

    @Override
    public boolean isBrowseHostEnabled() {
        return false;
    }

    @Override
    public int getGnutellaPort() {
        return 0;
    }

    @Override
    public String getUserAgent() {
        return "";
    }

    @Override
    public int getQueuePosition() {
        return 0;
    }

    @Override
    public boolean isInactive() {
        return this.torrent.getStatus().isPaused() || this.torrent.getStatus().isFinished();
    }

    @Override
    public void measureBandwidth() {
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.torrent.getUploadRate() / 1024.0f;
    }

    @Override
    public float getAverageBandwidth() {
        return this.torrent.getUploadRate() / 1024.0f;
    }

    @Override
    public String getCustomIconDescriptor() {
        return "";
    }

    @Override
    public UploadType getUploadType() {
        return UploadType.SHARED_FILE;
    }

    @Override
    public boolean isTLSCapable() {
        return false;
    }

    @Override
    public String getAddress() {
        return "torrent upload";
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return null;
    }

    @Override
    public String getAddressDescription() {
        return null;
    }

    public Collection<File> getCompleteFiles() {
        return TorrentUtil.buildTorrentFiles(this.torrent, this.torrent.getTorrentDataFile().getParentFile());
    }

    @Override
    public File getFile() {
        return this.torrent.getTorrentDataFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URN getUrn() {
        if (this.urn == null) {
            BTUploader bTUploader = this;
            synchronized (bTUploader) {
                if (this.urn == null) {
                    try {
                        this.urn = URN.createSha1UrnFromHex(this.torrent.getSha1());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.urn;
    }

    @Override
    public int getNumUploadConnections() {
        return this.torrent.getNumConnections();
    }

    @Override
    public String getPresenceId() {
        return null;
    }

    @Override
    public float getSeedRatio() {
        return this.torrent.getSeedRatio();
    }

    public Torrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void pause() {
        if (this.torrent.isFinished()) {
            this.torrent.setAutoManaged(false);
        }
        this.torrent.pause();
    }

    @Override
    public void resume() {
        if (this.torrent.isFinished()) {
            this.torrent.setAutoManaged(true);
        }
        this.torrent.resume();
    }
}

