/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.bittorrent.BTTorrentFileDownloader;
import com.limegroup.bittorrent.TorrentUploadManager;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.DownloadManagerEvent;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.CoreDownloaderFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.DownloadSerializer;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.mozilla.MozillaDownload;
import com.limegroup.mozilla.MozillaDownloaderImpl;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentParams;
import org.limewire.collection.DualIterator;
import org.limewire.collection.MultiIterable;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.core.settings.UpdateSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.libtorrent.LibTorrentParams;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.service.MessageService;
import org.limewire.util.FileUtils;
import org.limewire.util.Visitor;

@EagerSingleton
public class DownloadManagerImpl
implements DownloadManager,
Service,
EventListener<LibraryStatusEvent> {
    private static final Log LOG = LogFactory.getLog(DownloadManagerImpl.class);
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private final List<CoreDownloader> active = new LinkedList<CoreDownloader>();
    private final List<CoreDownloader> waiting = new LinkedList<CoreDownloader>();
    private final MultiIterable<CoreDownloader> activeAndWaiting = new MultiIterable<CoreDownloader>((Iterable<CoreDownloader>)this.active, (Iterable<CoreDownloader>)this.waiting);
    private volatile boolean downloadsReadFromDisk = false;
    private int innetworkCount = 0;
    private int storeDownloadCount = 0;
    private int mozillaDownloadCount = 0;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile float lastMeasuredBandwidth;
    private Runnable _waitingPump;
    private final EventListenerList<DownloadManagerEvent> listeners = new EventListenerList();
    private final DownloadCallback innetworkCallback;
    private final Provider<DownloadCallback> downloadCallback;
    private final Provider<MessageRouter> messageRouter;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final CoreDownloaderFactory coreDownloaderFactory;
    private final DownloadSerializer downloadSerializer;
    private final IncompleteFileManager incompleteFileManager;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final CategoryManager categoryManager;
    private final PushEndpointFactory pushEndpointFactory;
    private final Provider<TorrentManager> torrentManager;
    private final Provider<TorrentUploadManager> torrentUploadManager;

    @Inject
    public DownloadManagerImpl(@Named(value="inNetwork") DownloadCallback innetworkCallback, Provider<DownloadCallback> downloadCallback, Provider<MessageRouter> messageRouter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<PushDownloadManager> pushDownloadManager, CoreDownloaderFactory coreDownloaderFactory, DownloadSerializer downloaderSerializer, IncompleteFileManager incompleteFileManager, RemoteFileDescFactory remoteFileDescFactory, PushEndpointFactory pushEndpointFactory, Provider<TorrentManager> torrentManager, Provider<TorrentUploadManager> torrentUploadManager, CategoryManager categoryManager) {
        this.innetworkCallback = innetworkCallback;
        this.downloadCallback = downloadCallback;
        this.messageRouter = messageRouter;
        this.backgroundExecutor = backgroundExecutor;
        this.pushDownloadManager = pushDownloadManager;
        this.coreDownloaderFactory = coreDownloaderFactory;
        this.downloadSerializer = downloaderSerializer;
        this.incompleteFileManager = incompleteFileManager;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.pushEndpointFactory = pushEndpointFactory;
        this.torrentManager = torrentManager;
        this.torrentUploadManager = torrentUploadManager;
        this.categoryManager = categoryManager;
    }

    @Inject
    public void register(PushedSocketHandlerRegistry registry) {
        registry.register(this);
    }

    @Inject
    void register(ListenerSupport<LibraryStatusEvent> listeners) {
        listeners.addListener(this);
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
        registry.register(new Service(){

            @Override
            public String getServiceName() {
                return I18nMarker.marktr("Old Downloads");
            }

            @Override
            public void initialize() {
            }

            @Override
            public void start() {
                DownloadManagerImpl.this.loadSavedDownloadsAndScheduleWriting();
                ((TorrentUploadManager)DownloadManagerImpl.this.torrentUploadManager.get()).loadSavedUploads();
            }

            @Override
            public void stop() {
            }
        }).in(ServiceStage.LATE);
    }

    @Override
    public void start() {
        this.scheduleWaitingPump();
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Download Management");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
        this.writeSnapshot();
    }

    @Override
    public void addNewDownloader(CoreDownloader downloader) {
        this.initializeDownload(downloader, false);
    }

    @Override
    public void loadSavedDownloadsAndScheduleWriting() {
        this.loadSavedDownloads();
        this.scheduleSnapshots();
    }

    public void loadSavedDownloads() {
        List<DownloadMemento> mementos;
        boolean failedAll = true;
        boolean failedSome = false;
        try {
            mementos = this.downloadSerializer.readFromDisk();
            if (mementos.isEmpty()) {
                failedAll = false;
            }
        }
        catch (IOException ioex) {
            mementos = Collections.emptyList();
        }
        for (DownloadMemento memento : mementos) {
            CoreDownloader coreDownloader = this.prepareMemento(memento);
            if (coreDownloader != null) {
                failedAll = false;
                this.addNewDownloader(coreDownloader);
                continue;
            }
            failedSome = true;
        }
        this.loadResumeDownloaders();
        this.downloadsReadFromDisk = true;
        if (failedAll) {
            MessageService.showError(I18nMarker.marktr("Sorry, LimeWire couldn't read your old downloads.  You can restart them by clicking 'Try Again' on the downloads.  When LimeWire finds a source for the file, the download will pick up where it left off."));
        } else if (failedSome) {
            MessageService.showError(I18nMarker.marktr("Sorry, LimeWire couldn't read some of your old downloads.  You can restart them by clicking 'Try Again' on the downloads.  When LimeWire finds a source for the file, the download will pick up where it left off."));
        }
    }

    private void loadResumeDownloaders() {
        Collection<File> incompleteFiles = this.incompleteFileManager.getUnregisteredIncompleteFilesInDirectory(SharingSettings.INCOMPLETE_DIRECTORY.get());
        for (File file : incompleteFiles) {
            try {
                this.download(file);
            }
            catch (DownloadException e) {
                LOG.error("SLE loading incomplete file", e);
            }
            catch (CantResumeException e) {
                LOG.error("CRE loading incomplete file", e);
            }
        }
    }

    public CoreDownloader prepareMemento(DownloadMemento memento) {
        try {
            return this.coreDownloaderFactory.createFromMemento(memento);
        }
        catch (InvalidDataException ide) {
            LOG.warn("Unable to read download from memento: " + memento, ide);
            return null;
        }
    }

    public void scheduleSnapshots() {
        Runnable checkpointer = new Runnable(){

            @Override
            public void run() {
                if (DownloadManagerImpl.this.downloadsInProgress() > 0) {
                    DownloadManagerImpl.this.writeSnapshot();
                }
            }
        };
        this.backgroundExecutor.scheduleWithFixedDelay(checkpointer, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSnapshot() {
        ArrayList<DownloadMemento> mementos;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            mementos = new ArrayList<DownloadMemento>(this.active.size() + this.waiting.size());
            for (CoreDownloader downloader : this.activeAndWaiting) {
                if (!downloader.isMementoSupported()) continue;
                mementos.add(downloader.toMemento());
            }
        }
        this.downloadSerializer.writeToDisk(mementos);
    }

    @Override
    public boolean isSavedDownloadsLoaded() {
        return this.downloadsReadFromDisk;
    }

    @Override
    public synchronized boolean hasInNetworkDownload() {
        if (this.innetworkCount > 0) {
            return true;
        }
        for (CoreDownloader d : this.waiting) {
            if (d.getDownloadType() != DownloaderType.INNETWORK) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void killDownloadersNotListed(Collection<? extends DownloadInformation> updates) {
        if (updates == null) {
            return;
        }
        HashSet<String> urns = new HashSet<String>(updates.size());
        for (DownloadInformation downloadInformation : updates) {
            urns.add(downloadInformation.getUpdateURN().httpStringValue());
        }
        DualIterator<CoreDownloader> iter = new DualIterator<CoreDownloader>(this.waiting.iterator(), this.active.iterator());
        while (iter.hasNext()) {
            CoreDownloader coreDownloader = (CoreDownloader)iter.next();
            if (coreDownloader.getDownloadType() != DownloaderType.INNETWORK || urns.contains(coreDownloader.getSha1Urn().httpStringValue())) continue;
            coreDownloader.stop();
        }
        Object hopeless = UpdateSettings.FAILED_UPDATES.get();
        hopeless.retainAll(urns);
        UpdateSettings.FAILED_UPDATES.set((Set<String>)hopeless);
    }

    PushDownloadManager getPushManager() {
        return this.pushDownloadManager.get();
    }

    private synchronized boolean handleIncomingPush(String file, int index, byte[] clientGUID, Socket socket) {
        boolean handled = false;
        for (CoreDownloader md : this.activeAndWaiting) {
            ManagedDownloader mmd;
            if (!(md instanceof ManagedDownloader) || !(mmd = (ManagedDownloader)md).acceptDownload(file, socket, index, clientGUID)) continue;
            return true;
        }
        return handled;
    }

    @Override
    public boolean acceptPushedSocket(String file, int index, byte[] clientGUID, Socket socket) {
        return this.handleIncomingPush(file, index, clientGUID, socket);
    }

    public void scheduleWaitingPump() {
        if (this._waitingPump != null) {
            return;
        }
        this._waitingPump = new Runnable(){

            @Override
            public void run() {
                DownloadManagerImpl.this.pumpDownloads();
            }
        };
        this.backgroundExecutor.scheduleWithFixedDelay(this._waitingPump, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected synchronized void pumpDownloads() {
        int index = 1;
        Iterator<CoreDownloader> i = this.waiting.iterator();
        while (i.hasNext()) {
            CoreDownloader md = i.next();
            if (md.isAlive()) continue;
            if (md.shouldBeRemoved()) {
                i.remove();
                this.cleanupCompletedDownload(md, false);
                continue;
            }
            if (this.storeDownloadCount < 3 && md.getDownloadType() == DownloaderType.STORE) {
                i.remove();
                ++this.storeDownloadCount;
                this.active.add(md);
                md.startDownload();
                continue;
            }
            if (this.hasFreeSlot() && md.shouldBeRestarted() && md.getDownloadType() != DownloaderType.STORE) {
                i.remove();
                if (md.getDownloadType() == DownloaderType.INNETWORK) {
                    ++this.innetworkCount;
                }
                this.active.add(md);
                md.startDownload();
                continue;
            }
            if (md.isQueuable()) {
                md.setInactivePriority(index++);
            }
            md.handleInactivity();
        }
    }

    @Override
    public boolean isIncomplete(URN urn) {
        return this.incompleteFileManager.getFileForUrn(urn) != null;
    }

    @Override
    public boolean isActivelyDownloading(URN urn) {
        Downloader md = this.getDownloaderForURN(urn);
        if (md == null) {
            return false;
        }
        switch (md.getState()) {
            case QUEUED: 
            case BUSY: 
            case ABORTED: 
            case GAVE_UP: 
            case UNABLE_TO_CONNECT: 
            case DISK_PROBLEM: 
            case CORRUPT_FILE: 
            case REMOTE_QUEUED: 
            case WAITING_FOR_USER: 
            case DANGEROUS: 
            case THREAT_FOUND: 
            case SCAN_FAILED: 
            case SCAN_FAILED_DOWNLOADING_DEFINITIONS: {
                return false;
            }
        }
        return true;
    }

    @Override
    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    @Override
    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    @Override
    public synchronized int getNumIndividualDownloaders() {
        int ret = 0;
        for (CoreDownloader next : this.active) {
            if (!(next instanceof ManagedDownloader)) continue;
            ManagedDownloader md = (ManagedDownloader)next;
            ret += md.getNumDownloaders();
        }
        return ret;
    }

    @Override
    public synchronized int getNumActiveDownloads() {
        return this.active.size() - this.innetworkCount - this.storeDownloadCount - this.mozillaDownloadCount;
    }

    @Override
    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    @Override
    public synchronized Downloader getDownloaderForURN(URN sha1) {
        for (CoreDownloader md : this.activeAndWaiting) {
            if (md.getSha1Urn() == null || !sha1.equals(md.getSha1Urn())) continue;
            return md;
        }
        return null;
    }

    public synchronized Downloader getDownloaderForURNString(String urn) {
        for (CoreDownloader md : this.activeAndWaiting) {
            if (md.getSha1Urn() == null || !urn.equals(md.getSha1Urn().toString())) continue;
            return md;
        }
        return null;
    }

    @Override
    public synchronized Downloader getDownloaderForIncompleteFile(File file) {
        for (CoreDownloader dl : this.activeAndWaiting) {
            if (!dl.conflictsWithIncompleteFile(file)) continue;
            return dl;
        }
        return null;
    }

    @Override
    public synchronized boolean isGuidForQueryDownloading(GUID guid) {
        for (CoreDownloader md : this.activeAndWaiting) {
            GUID dGUID = md.getQueryGUID();
            if (dGUID == null || !dGUID.equals(guid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAllDownloads() {
        ArrayList<CoreDownloader> buf;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            buf = new ArrayList<CoreDownloader>(this.active.size() + this.waiting.size());
            buf.addAll(this.active);
            buf.addAll(this.waiting);
            this.active.clear();
            this.waiting.clear();
        }
        for (CoreDownloader md : buf) {
            md.stop();
            this.fireEvent(md, DownloadManagerEvent.Type.REMOVED);
        }
    }

    @Override
    public synchronized Downloader download(RemoteFileDesc[] files, List<? extends RemoteFileDesc> alts, GUID queryGUID, boolean overwrite, File saveDir, String fileName) throws DownloadException {
        String fName = this.getFileName(files, fileName);
        if (this.conflicts(files, new File(saveDir, fName))) {
            this.addRemoteFileDescsToDownloader(files);
            throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING, new File(fName != null ? fName : ""));
        }
        this.incompleteFileManager.purge();
        ManagedDownloader downloader = this.coreDownloaderFactory.createManagedDownloader(files, queryGUID, saveDir, fileName, overwrite);
        this.initializeDownload(downloader, true);
        downloader.addDownload(alts, false);
        return downloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteFileDescsToDownloader(RemoteFileDesc[] files) {
        ManagedDownloader managedDownloader;
        CoreDownloader downloader;
        ArrayList<CoreDownloader> downloaders = new ArrayList<CoreDownloader>(this.active.size() + this.waiting.size());
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            downloaders.addAll(this.active);
            downloaders.addAll(this.waiting);
        }
        Iterator i$ = downloaders.iterator();
        while (!(!i$.hasNext() || (downloader = (CoreDownloader)i$.next()) instanceof ManagedDownloader && (managedDownloader = (ManagedDownloader)downloader).addDownload(Arrays.asList(files), true))) {
        }
    }

    @Override
    public synchronized Downloader download(MagnetOptions magnet, boolean overwrite, File saveDir, String fileName) throws IllegalArgumentException, DownloadException {
        if (!magnet.isDownloadable()) {
            throw new IllegalArgumentException("magnet not downloadable");
        }
        this.incompleteFileManager.purge();
        if (fileName == null) {
            fileName = magnet.getFileNameForSaving();
        }
        if (this.conflicts(magnet.getSHA1Urn(), 0L, new File(saveDir, fileName))) {
            throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING, new File(fileName));
        }
        MagnetDownloader downloader = this.coreDownloaderFactory.createMagnetDownloader(magnet, overwrite, saveDir, fileName);
        this.initializeDownload(downloader, true);
        return downloader;
    }

    @Override
    public synchronized Downloader downloadFromStore(RemoteFileDesc rfd, boolean overwrite, File saveDir, String fileName) throws IllegalArgumentException, DownloadException {
        this.incompleteFileManager.purge();
        if (this.conflicts(rfd.getSHA1Urn(), 0L, new File(saveDir, fileName))) {
            throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING, new File(fileName));
        }
        StoreDownloader downloader = this.coreDownloaderFactory.createStoreDownloader(rfd, saveDir, fileName, overwrite);
        this.initializeDownload(downloader, true);
        return downloader;
    }

    @Override
    public synchronized Downloader download(File incompleteFile) throws CantResumeException, DownloadException {
        if (this.conflictsWithIncompleteFile(incompleteFile)) {
            throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING, incompleteFile);
        }
        if (IncompleteFileManager.isTorrentFile(incompleteFile)) {
            return this.resumeTorrentDownload(incompleteFile);
        }
        this.incompleteFileManager.purge();
        ResumeDownloader downloader = null;
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
            String name = IncompleteFileManager.getCompletedName(incompleteFile);
            long size = IncompleteFileManager.getCompletedSize(incompleteFile);
            downloader = this.coreDownloaderFactory.createResumeDownloader(incompleteFile, name, size);
        }
        catch (IllegalArgumentException e) {
            throw new CantResumeException(e, incompleteFile.getName());
        }
        catch (IOException ioe) {
            throw new CantResumeException(ioe, incompleteFile.getName());
        }
        this.initializeDownload(downloader, true);
        return downloader;
    }

    private Downloader resumeTorrentDownload(File torrentFile) throws CantResumeException, DownloadException {
        if (this.torrentManager.get().isValid()) {
            return this.downloadTorrent(torrentFile, null, false);
        }
        throw new CantResumeException("Torrent Manager Invalid", torrentFile.getName());
    }

    @Override
    public synchronized Downloader download(DownloadInformation info, long now) throws DownloadException {
        File dir = LibraryUtils.PREFERENCE_SHARE;
        dir.mkdirs();
        File f = new File(dir, info.getUpdateFileName());
        if (this.conflicts(info.getUpdateURN(), (int)info.getSize(), f)) {
            throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING, f);
        }
        this.incompleteFileManager.purge();
        InNetworkDownloader d = this.coreDownloaderFactory.createInNetworkDownloader(info, dir, now);
        this.initializeDownload(d, true);
        return d;
    }

    @Override
    public synchronized Downloader downloadTorrent(URI torrentURI, boolean overwrite) throws DownloadException {
        if (!this.isSavedDownloadsLoaded()) {
            throw new DownloadException(DownloadException.ErrorCode.FILES_STILL_RESUMING, null);
        }
        if (!this.torrentManager.get().isValid()) {
            throw new DownloadException(DownloadException.ErrorCode.NO_TORRENT_MANAGER, null);
        }
        BTTorrentFileDownloader torrentDownloader = this.coreDownloaderFactory.createTorrentFileDownloader(torrentURI, true);
        this.initializeDownload(torrentDownloader, false);
        return torrentDownloader;
    }

    @Override
    public synchronized Downloader downloadTorrent(File torrentFile, File saveDirectory, boolean overwrite) throws DownloadException {
        if (!this.isSavedDownloadsLoaded()) {
            throw new DownloadException(DownloadException.ErrorCode.FILES_STILL_RESUMING, torrentFile);
        }
        if (!this.torrentManager.get().isValid()) {
            throw new DownloadException(DownloadException.ErrorCode.NO_TORRENT_MANAGER, torrentFile);
        }
        if (torrentFile.length() > 0x500000L) {
            throw new DownloadException(DownloadException.ErrorCode.TORRENT_FILE_TOO_LARGE, torrentFile);
        }
        if (saveDirectory == null) {
            saveDirectory = SharingSettings.getSaveDirectory();
        }
        LibTorrentParams params = new LibTorrentParams(SharingSettings.INCOMPLETE_DIRECTORY.get(), torrentFile);
        BTDownloader ret = null;
        try {
            File saveFile;
            params.fill();
            this.checkIfAlreadyManagedTorrent(params);
            this.checkActiveAndWaiting(params, saveDirectory);
            ret = this.coreDownloaderFactory.createBTDownloader(params);
            if (ret == null || ret.getTorrent() == null || !ret.getTorrent().isValid()) {
                throw new DownloadException(DownloadException.ErrorCode.NO_TORRENT_MANAGER, torrentFile);
            }
            ret.setSaveFile(saveDirectory, null, overwrite);
            if (!overwrite && (saveFile = ret.getSaveFile()).exists()) {
                throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_EXISTS, saveFile);
            }
        }
        catch (IOException e) {
            LOG.error("Error creating BTDownloader", e);
            if (ret != null) {
                Torrent torrent = ret.getTorrent();
                this.torrentManager.get().removeTorrent(torrent);
                ret.deleteIncompleteFiles();
            }
            if (e instanceof DownloadException) {
                throw (DownloadException)e;
            }
            throw new DownloadException(e, torrentFile);
        }
        Torrent torrent = ret.getTorrent();
        if (BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.getValue() && !this.downloadCallback.get().promptTorrentFilePriorities(torrent)) {
            this.torrentManager.get().removeTorrent(torrent);
            ret.deleteIncompleteFiles();
            throw new DownloadException(DownloadException.ErrorCode.DOWNLOAD_CANCELLED, torrentFile);
        }
        this.initializeDownload(ret, true);
        return ret;
    }

    private void checkActiveAndWaiting(TorrentParams params, File saveDirectory) throws DownloadException {
        URN urn = null;
        try {
            urn = URN.createSha1UrnFromHex(params.getSha1());
        }
        catch (IOException e) {
            throw new DownloadException(DownloadException.ErrorCode.FILESYSTEM_ERROR, params.getTorrentFile());
        }
        for (CoreDownloader current : this.activeAndWaiting) {
            if (urn.equals(current.getSha1Urn())) {
                throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING, params.getTorrentDataFile());
            }
            File saveFile = new File(saveDirectory, params.getName());
            if (current.conflictsSaveFile(saveFile)) {
                throw new DownloadException(DownloadException.ErrorCode.FILE_IS_ALREADY_DOWNLOADED_TO, saveFile);
            }
            if (!current.conflictsSaveFile(params.getTorrentDataFile())) continue;
            throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING, params.getTorrentDataFile());
        }
    }

    private void checkIfAlreadyManagedTorrent(TorrentParams params) throws DownloadException {
        Torrent torrent = this.torrentManager.get().getTorrent(params.getTorrentFile());
        if (torrent == null) {
            torrent = this.torrentManager.get().getTorrent(params.getSha1());
        }
        if (torrent != null) {
            if (!torrent.isFinished()) {
                throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING, params.getTorrentDataFile());
            }
            throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_UPLOADING, params.getTorrentDataFile());
        }
    }

    @Override
    public synchronized Downloader downloadFromMozilla(MozillaDownload listener) {
        MozillaDownloaderImpl downloader = new MozillaDownloaderImpl(this, this.categoryManager, listener);
        downloader.initialize();
        this.callback(downloader).addDownload(downloader);
        this.active.add(downloader);
        ++this.mozillaDownloadCount;
        this.fireEvent(downloader, DownloadManagerEvent.Type.ADDED);
        return downloader;
    }

    private synchronized void initializeDownload(CoreDownloader md, boolean saveState) {
        md.initialize();
        this.waiting.add(md);
        this.callback(md).addDownload(md);
        if (saveState) {
            this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    DownloadManagerImpl.this.writeSnapshot();
                }
            });
        }
        this.fireEvent(md, DownloadManagerEvent.Type.ADDED);
    }

    private DownloadCallback callback(Downloader md) {
        return md instanceof InNetworkDownloader ? this.innetworkCallback : this.downloadCallback.get();
    }

    private boolean conflicts(RemoteFileDesc[] rfds, File ... fileName) {
        URN urn = null;
        for (int i = 0; i < rfds.length && urn == null; ++i) {
            urn = rfds[0].getSHA1Urn();
        }
        return this.conflicts(urn, rfds[0].getSize(), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean conflicts(URN urn, long fileSize, File ... fileName) {
        if (urn == null && fileSize == 0L) {
            return false;
        }
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            for (CoreDownloader md : this.activeAndWaiting) {
                if (!md.conflicts(urn, fileSize, fileName)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public synchronized boolean isSaveLocationTaken(File candidateFile) {
        for (CoreDownloader md : this.activeAndWaiting) {
            if (!md.conflictsSaveFile(candidateFile)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean conflictsWithIncompleteFile(File incompleteFile) {
        for (CoreDownloader md : this.activeAndWaiting) {
            if (!md.conflictsWithIncompleteFile(incompleteFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleQueryReply(QueryReply qr, Address address) {
        List<Response> responses;
        if (qr.calculateQualityOfService() < 1) {
            return;
        }
        try {
            qr.validate();
            responses = qr.getResultsAsList();
        }
        catch (BadPacketException bpe) {
            return;
        }
        this.addDownloadWithResponses(responses, qr, address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloadWithResponses(List<? extends Response> responses, QueryReply queryReply, Address address) {
        if (responses == null) {
            throw new NullPointerException("null responses");
        }
        if (queryReply == null) {
            throw new NullPointerException("null queryReply");
        }
        ArrayList<CoreDownloader> downloaders = new ArrayList<CoreDownloader>(this.active.size() + this.waiting.size());
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            downloaders.addAll(this.active);
            downloaders.addAll(this.waiting);
        }
        if (downloaders.isEmpty()) {
            return;
        }
        block5: for (Response response : responses) {
            RemoteFileDesc rfd;
            try {
                rfd = response.toRemoteFileDesc(queryReply, address, this.remoteFileDescFactory, this.pushEndpointFactory);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            for (CoreDownloader current : downloaders) {
                if (!(current instanceof ManagedDownloader)) continue;
                ManagedDownloader currD = (ManagedDownloader)current;
                LOG.debugf("adding rfd {0} to downloader {1}", (Object)rfd, (Object)currD);
                if (!currD.addDownload(rfd, true)) continue;
                for (IpPort ipPort : response.getLocations()) {
                    currD.addDownload(this.remoteFileDescFactory.createRemoteFileDesc(rfd, ipPort), false);
                }
                continue block5;
            }
        }
    }

    private boolean hasFreeSlot() {
        return this.active.size() - this.innetworkCount - this.storeDownloadCount - this.mozillaDownloadCount < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    @Override
    public synchronized void remove(CoreDownloader downloader, boolean completed) {
        if (this.active.remove(downloader)) {
            DownloaderType type = downloader.getDownloadType();
            if (type == DownloaderType.INNETWORK) {
                --this.innetworkCount;
            } else if (type == DownloaderType.STORE) {
                --this.storeDownloadCount;
            } else if (type == DownloaderType.MOZILLA) {
                --this.mozillaDownloadCount;
            }
        }
        this.waiting.remove(downloader);
        if (completed) {
            this.cleanupCompletedDownload(downloader, true);
        } else {
            this.waiting.add(downloader);
        }
    }

    @Override
    public synchronized void bumpPriority(Downloader downl, boolean up, int amt) {
        CoreDownloader downloader = (CoreDownloader)downl;
        int idx = this.waiting.indexOf(downloader);
        if (idx == -1) {
            return;
        }
        if (up && idx != 0) {
            this.waiting.remove(idx);
            if (amt > idx) {
                amt = idx;
            }
            if (amt != 0) {
                this.waiting.add(idx - amt, downloader);
            } else {
                this.waiting.add(0, downloader);
            }
        } else if (!up && idx != this.waiting.size() - 1) {
            this.waiting.remove(idx);
            if (amt != 0) {
                if ((amt += idx) > this.waiting.size()) {
                    amt = this.waiting.size();
                }
                this.waiting.add(amt, downloader);
            } else {
                this.waiting.add(downloader);
            }
        }
    }

    private void cleanupCompletedDownload(CoreDownloader dl, boolean ser) {
        dl.finish();
        if (dl.getQueryGUID() != null) {
            this.messageRouter.get().downloadFinished(dl.getQueryGUID());
        }
        this.callback(dl).removeDownload(dl);
        if (ser) {
            this.writeSnapshot();
        }
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback(dl).downloadsComplete();
        }
        this.fireEvent(dl, DownloadManagerEvent.Type.REMOVED);
    }

    @Override
    public void sendQuery(QueryRequest query) {
        this.messageRouter.get().sendDynamicQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureBandwidth() {
        ArrayList<CoreDownloader> activeCopy;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            activeCopy = new ArrayList<CoreDownloader>(this.active);
        }
        float currentTotal = 0.0f;
        boolean c = false;
        for (CoreDownloader bt : activeCopy) {
            if (bt instanceof InNetworkDownloader) continue;
            c = true;
            bt.measureBandwidth();
            currentTotal += bt.getAverageBandwidth();
        }
        if (c) {
            DownloadManagerImpl downloadManagerImpl2 = this;
            synchronized (downloadManagerImpl2) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMeasuredBandwidth() {
        ArrayList<CoreDownloader> activeCopy;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            activeCopy = new ArrayList<CoreDownloader>(this.active);
        }
        float sum = 0.0f;
        for (CoreDownloader bt : activeCopy) {
            if (bt instanceof InNetworkDownloader) continue;
            float curr = 0.0f;
            try {
                curr = bt.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            sum += curr;
        }
        this.lastMeasuredBandwidth = sum;
        return sum;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    @Override
    public float getLastMeasuredBandwidth() {
        return this.lastMeasuredBandwidth;
    }

    private String getFileName(RemoteFileDesc[] rfds, String fileName) {
        for (int i = 0; i < rfds.length && fileName == null; ++i) {
            fileName = rfds[i].getFileName();
        }
        return fileName;
    }

    @Override
    public final Iterable<CoreDownloader> getAllDownloaders() {
        return this.activeAndWaiting;
    }

    @Override
    public void handleEvent(LibraryStatusEvent evt) {
        switch (evt.getType()) {
            case LOAD_FINISHING: {
                this.getIncompleteFileManager().registerAllIncompleteFiles();
            }
        }
    }

    @Override
    public synchronized void visitDownloads(Visitor<CoreDownloader> visitor) {
        for (CoreDownloader downloader : this.activeAndWaiting) {
            visitor.visit(downloader);
        }
    }

    private void fireEvent(CoreDownloader downloader, DownloadManagerEvent.Type type) {
        this.listeners.broadcast(new DownloadManagerEvent(downloader, type));
    }

    @Override
    public void addListener(EventListener<DownloadManagerEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadManagerEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    @Override
    public synchronized boolean contains(Downloader downloader) {
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            if (coreDownloader != downloader) continue;
            return true;
        }
        return false;
    }
}

