/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import java.io.File;
import java.util.List;
import org.limewire.core.api.download.DownloadException;
import org.limewire.io.GUID;

@Singleton
public class DownloadServicesImpl
implements DownloadServices {
    private final Provider<DownloadManager> downloadManager;

    @Inject
    public DownloadServicesImpl(Provider<DownloadManager> downloadManager) {
        this.downloadManager = downloadManager;
    }

    @Override
    public Downloader download(File incompleteFile) throws CantResumeException, DownloadException {
        return this.downloadManager.get().download(incompleteFile);
    }

    @Override
    public Downloader download(MagnetOptions magnet, boolean overwrite, File saveDir, String fileName) throws DownloadException {
        return this.downloadManager.get().download(magnet, overwrite, saveDir, fileName);
    }

    @Override
    public Downloader download(MagnetOptions magnet, boolean overwrite) throws DownloadException {
        if (!magnet.isDownloadable()) {
            throw new IllegalArgumentException("invalid magnet: not have enough information for downloading");
        }
        return this.downloadManager.get().download(magnet, overwrite, null, magnet.getDisplayName());
    }

    @Override
    public Downloader downloadFromStore(RemoteFileDesc rfd, boolean overwrite, File saveDir, String fileName) throws DownloadException {
        return this.downloadManager.get().downloadFromStore(rfd, overwrite, saveDir, fileName);
    }

    @Override
    public Downloader download(RemoteFileDesc[] files, boolean overwrite, GUID queryGUID) throws DownloadException {
        return this.download(files, queryGUID, overwrite, null, null);
    }

    @Override
    public Downloader download(RemoteFileDesc[] files, GUID queryGUID, boolean overwrite, File saveDir, String fileName) throws DownloadException {
        return this.download(files, RemoteFileDesc.EMPTY_LIST, queryGUID, overwrite, saveDir, fileName);
    }

    @Override
    public Downloader download(RemoteFileDesc[] files, List<? extends RemoteFileDesc> alts, GUID queryGUID, boolean overwrite) throws DownloadException {
        return this.download(files, alts, queryGUID, overwrite, null, null);
    }

    @Override
    public Downloader download(RemoteFileDesc[] files, List<? extends RemoteFileDesc> alts, GUID queryGUID, boolean overwrite, File saveDir, String fileName) throws DownloadException {
        return this.downloadManager.get().download(files, alts, queryGUID, overwrite, saveDir, fileName);
    }

    @Override
    public int getNumActiveDownloads() {
        return this.downloadManager.get().getNumActiveDownloads();
    }

    @Override
    public int getNumDownloads() {
        return this.downloadManager.get().downloadsInProgress();
    }

    @Override
    public boolean hasActiveDownloads() {
        this.downloadManager.get().measureBandwidth();
        return this.downloadManager.get().getMeasuredBandwidth() != 0.0f;
    }
}

