/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.util.Clock;

@EagerSingleton
public class Statistics {
    private final Clock clock;
    protected static final int SECONDS_PER_DAY = 86400;
    private final long startTime;

    @Inject
    public Statistics(Clock clock) {
        this.clock = clock;
        this.startTime = clock.now();
    }

    public long getUptime() {
        return Math.max(0L, this.clock.now() - this.startTime);
    }

    public int calculateDailyUptime() {
        return (int)(this.calculateFractionalUptime() * 86400.0f);
    }

    public float calculateFractionalUptime() {
        int i;
        String[] uptimes = ApplicationSettings.UPTIME_HISTORY.get();
        String[] downtimes = ApplicationSettings.DOWNTIME_HISTORY.get();
        float up = 0.0f;
        float down = 0.0f;
        for (i = 0; i < uptimes.length; ++i) {
            up += (float)Long.valueOf(uptimes[i]).longValue();
        }
        for (i = 0; i < downtimes.length; ++i) {
            down += (float)Long.valueOf(downtimes[i]).longValue();
        }
        if (up + down == 0.0f) {
            return 0.0f;
        }
        return up / (up + down);
    }
}

