/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.AbstractDHTController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.util.EventDispatcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import org.limewire.core.settings.DHTSettings;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.SecureInputStream;
import org.limewire.io.SecureOutputStream;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.MojitoFactory;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.util.CommonUtils;

public class ActiveDHTNodeController
extends AbstractDHTController {
    private static final File FILE = new File(CommonUtils.getUserSettingsDir(), "active.mojito");

    ActiveDHTNodeController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> dispatcher, DHTControllerFacade dhtControllerFacade) {
        super(vendor, version, dispatcher, DHTManager.DHTMode.ACTIVE, dhtControllerFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MojitoDHT createMojitoDHT(Vendor vendor, Version version) {
        MojitoDHT dht = MojitoFactory.createDHT("ActiveMojitoDHT", vendor, version);
        if (DHTSettings.PERSIST_ACTIVE_DHT_ROUTETABLE.getValue() && FILE.exists() && FILE.isFile()) {
            ObjectInputStream in;
            block10: {
                in = null;
                try {
                    in = new ObjectInputStream(new BufferedInputStream(new SecureInputStream(new FileInputStream(FILE))));
                    int routeTableVersion = in.readInt();
                    if (routeTableVersion < this.getRouteTableVersion()) break block10;
                    RouteTable routeTable = (RouteTable)in.readObject();
                    Database database = null;
                    try {
                        if (DHTSettings.PERSIST_DHT_DATABASE.getValue()) {
                            database = (Database)in.readObject();
                        }
                    }
                    catch (Throwable ignored) {
                        this.LOG.error("Throwable", ignored);
                    }
                    if (routeTable == null) break block10;
                    long maxElaspedTime = DHTSettings.MAX_ELAPSED_TIME_SINCE_LAST_CONTACT.getValue();
                    if (maxElaspedTime < Long.MAX_VALUE) {
                        routeTable.purge(maxElaspedTime);
                    }
                    dht.setRouteTable(routeTable);
                    if (database == null) break block10;
                    dht.setDatabase(database);
                }
                catch (Throwable ignored) {
                    try {
                        this.LOG.error("Throwable", ignored);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.close(in);
                    }
                }
            }
            IOUtils.close(in);
        }
        return dht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        super.stop();
        this.sendUpdatedCapabilities();
        if (DHTSettings.PERSIST_ACTIVE_DHT_ROUTETABLE.getValue()) {
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new BufferedOutputStream(new SecureOutputStream(new FileOutputStream(FILE))));
                out.writeInt(this.getRouteTableVersion());
                MojitoDHT mojitoDHT = this.dht;
                synchronized (mojitoDHT) {
                    out.writeObject(this.dht.getRouteTable());
                    Database database = null;
                    if (DHTSettings.PERSIST_DHT_DATABASE.getValue()) {
                        database = this.dht.getDatabase();
                    }
                    out.writeObject(database);
                }
                out.flush();
            }
            catch (IOException iOException) {
                IOUtils.close(out);
                catch (Throwable throwable) {
                    IOUtils.close(out);
                    throw throwable;
                }
            }
            IOUtils.close(out);
        }
    }

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
        RoutedConnection c = evt.getConnection();
        if (c == null) {
            return;
        }
        String host = c.getAddress();
        int port = c.getPort();
        if (evt.isConnectionCapabilitiesEvent()) {
            if (c.getConnectionCapabilities().remostHostIsPassiveDHTNode() > -1) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Connection is passive dht node: " + c);
                }
                this.addPassiveDHTNode(new InetSocketAddress(host, port));
            } else if (c.getConnectionCapabilities().remostHostIsActiveDHTNode() > -1) {
                if (DHTSettings.EXCLUDE_ULTRAPEERS.getValue()) {
                    return;
                }
                this.addActiveDHTNode(new InetSocketAddress(host, port));
            }
        }
    }

    @Override
    public List<IpPort> getActiveDHTNodes(int maxNodes) {
        if (!this.isRunning() || !this.dht.isBootstrapped()) {
            return Collections.emptyList();
        }
        return this.getMRSNodes(maxNodes, false);
    }
}

