/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Provider;
import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTController;
import com.limegroup.gnutella.dht.DHTNodeFetcher;
import com.limegroup.gnutella.dht.DHTNodeFetcherFactory;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.FixedSizeLIFOSet;
import org.limewire.core.settings.DHTSettings;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.util.ExceptionUtils;
import org.limewire.service.ErrorService;

class DHTBootstrapperImpl
implements DHTBootstrapper,
SimppListener {
    private static final Log LOG = LogFactory.getLog(DHTBootstrapperImpl.class);
    private final Set<SocketAddress> hosts = new FixedSizeLIFOSet<SocketAddress>(50, FixedSizeLIFOSet.EjectionPolicy.FIFO);
    private boolean triedRouteTable = false;
    private DHTFuture<PingResult> pingFuture;
    private boolean fromRouteTable = false;
    private DHTFuture<BootstrapResult> bootstrapFuture;
    private final DHTController controller;
    private DHTNodeFetcher nodeFetcher;
    private final Object lock = new Object();
    private final Provider<SimppManager> simppManager;
    private final DHTNodeFetcherFactory dhtNodeFetcherFactory;

    public DHTBootstrapperImpl(DHTController controller, Provider<SimppManager> simppManager, DHTNodeFetcherFactory dhtNodeFetcherFactory) {
        this.controller = controller;
        this.simppManager = simppManager;
        this.dhtNodeFetcherFactory = dhtNodeFetcherFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bootstrap() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getMojitoDHT().isBootstrapped()) {
                return;
            }
            this.simppManager.get().addListener(this);
            if (this.hosts.isEmpty()) {
                this.tryBootstrapFromRouteTable();
            } else {
                this.tryBootstrapFromHostsSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBootstrapHost(SocketAddress hostAddress) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.getMojitoDHT().isRunning() || this.getMojitoDHT().isBootstrapped()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding host: " + hostAddress);
            }
            this.hosts.add(hostAddress);
            this.tryBootstrapFromHostsSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPassiveNode(SocketAddress hostAddress) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nodeFetcher == null || !this.isWaitingForNodes()) {
                return;
            }
            this.nodeFetcher.requestDHTHosts(hostAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.simppManager.get().removeListener(this);
            if (this.pingFuture != null) {
                this.pingFuture.cancel(true);
                this.pingFuture = null;
            }
            if (this.bootstrapFuture != null) {
                this.bootstrapFuture.cancel(true);
                this.bootstrapFuture = null;
            }
            this.stopNodeFetcher();
            this.triedRouteTable = false;
            this.fromRouteTable = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWaitingForNodes() {
        Object object = this.lock;
        synchronized (object) {
            return !this.getMojitoDHT().isBootstrapped() && this.bootstrapFuture == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBootstrapFromRouteTable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.triedRouteTable) {
                return;
            }
            if (this.pingFuture != null || this.bootstrapFuture != null) {
                return;
            }
            this.pingFuture = this.getMojitoDHT().findActiveContact();
            this.pingFuture.addDHTFutureListener(new PongListener(this.pingFuture));
            this.triedRouteTable = true;
            this.fromRouteTable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBootstrapFromHostsSet() {
        Object object = this.lock;
        synchronized (object) {
            if (this.bootstrapFuture != null) {
                return;
            }
            if (this.fromRouteTable) {
                this.fromRouteTable = false;
                if (this.pingFuture != null) {
                    this.pingFuture.cancel(true);
                    this.pingFuture = null;
                }
            }
            if (this.pingFuture != null) {
                return;
            }
            Iterator<SocketAddress> it = this.hosts.iterator();
            assert (it.hasNext());
            SocketAddress addr = it.next();
            it.remove();
            this.pingFuture = this.getMojitoDHT().ping(addr);
            this.pingFuture.addDHTFutureListener(new PongListener(this.pingFuture));
        }
    }

    private void finish() {
        this.controller.sendUpdatedCapabilities();
    }

    private MojitoDHT getMojitoDHT() {
        return this.controller.getMojitoDHT();
    }

    private void stopNodeFetcher() {
        if (this.nodeFetcher != null) {
            this.nodeFetcher.stop();
            this.nodeFetcher = null;
        }
    }

    @Override
    public void simppUpdated(int newVersion) {
        SocketAddress simpp = null;
        simpp = this.getSimppHost();
        if (simpp != null) {
            this.addBootstrapHost(simpp);
        }
    }

    SocketAddress getSimppHost() {
        String[] simppHosts = DHTSettings.DHT_BOOTSTRAP_HOSTS.get();
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(simppHosts.length);
        for (String hostString : simppHosts) {
            int index = hostString.indexOf(":");
            if (index < 0 || index == hostString.length() - 1) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error(new UnknownHostException("invalid SIMPP host: " + hostString));
                continue;
            }
            try {
                String host = hostString.substring(0, index);
                int port = Integer.parseInt(hostString.substring(index + 1).trim());
                list.add(new InetSocketAddress(host, port));
            }
            catch (NumberFormatException nfe) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error(new UnknownHostException("invalid host: " + hostString));
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        KUID localId = this.getMojitoDHT().getLocalNodeID();
        int localPrefix = (localId.getBytes()[0] & 0xF0) >> 4;
        int index = (int)((float)list.size() / 16.0f * (float)localPrefix);
        return (SocketAddress)list.get(index);
    }

    boolean isBootstrappingFromRouteTable() {
        return this.fromRouteTable;
    }

    DHTFuture<PingResult> getPingFuture() {
        return this.pingFuture;
    }

    DHTFuture<BootstrapResult> getBootstrapFuture() {
        return this.bootstrapFuture;
    }

    private class BootstrapListener
    implements DHTFutureListener<BootstrapResult> {
        private BootstrapListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleFutureSuccess(BootstrapResult result) {
            boolean finish = false;
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                DHTBootstrapperImpl.this.bootstrapFuture = null;
                BootstrapResult.ResultType type = result.getResultType();
                LOG.debug("Future success type: " + (Object)((Object)type));
                switch (type) {
                    case BOOTSTRAP_SUCCEEDED: {
                        finish = true;
                        break;
                    }
                    case BOOTSTRAP_FAILED: {
                        DHTBootstrapperImpl.this.bootstrap();
                        break;
                    }
                }
            }
            if (finish) {
                DHTBootstrapperImpl.this.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleExecutionException(ExecutionException e) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.error("ExecutionException", e);
                if (!(e.getCause() instanceof DHTException)) {
                    ErrorService.error(e);
                }
                DHTBootstrapperImpl.this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleCancellationException(CancellationException e) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Canceled", e);
                DHTBootstrapperImpl.this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleInterruptedException(InterruptedException e) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Interrupted", e);
                DHTBootstrapperImpl.this.stop();
            }
        }
    }

    private class PongListener
    implements DHTFutureListener<PingResult> {
        private final DHTFuture<PingResult> myFuture;

        public PongListener(DHTFuture<PingResult> myFuture) {
            this.myFuture = myFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleFutureSuccess(PingResult result) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                if (DHTBootstrapperImpl.this.pingFuture != this.myFuture) {
                    return;
                }
                DHTBootstrapperImpl.this.pingFuture = null;
                DHTBootstrapperImpl.this.stopNodeFetcher();
                DHTBootstrapperImpl.this.bootstrapFuture = DHTBootstrapperImpl.this.getMojitoDHT().bootstrap(result.getContact());
                DHTBootstrapperImpl.this.bootstrapFuture.addDHTFutureListener(new BootstrapListener());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleExecutionException(ExecutionException e) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                if (DHTBootstrapperImpl.this.pingFuture != this.myFuture) {
                    return;
                }
                DHTBootstrapperImpl.this.pingFuture = null;
                if (ExceptionUtils.isCausedBy(e, DHTException.class)) {
                    SocketAddress simpp = null;
                    if (DHTBootstrapperImpl.this.fromRouteTable && (simpp = DHTBootstrapperImpl.this.getSimppHost()) != null) {
                        DHTBootstrapperImpl.this.addBootstrapHost(simpp);
                    } else {
                        this.retry();
                    }
                } else if (!ExceptionUtils.isCausedBy(e, IllegalArgumentException.class)) {
                    LOG.error("ExecutionException", e);
                    ErrorService.error(e);
                    DHTBootstrapperImpl.this.stop();
                }
            }
        }

        private void retry() {
            if (DHTBootstrapperImpl.this.nodeFetcher == null) {
                DHTBootstrapperImpl.this.nodeFetcher = DHTBootstrapperImpl.this.dhtNodeFetcherFactory.createNodeFetcher(DHTBootstrapperImpl.this);
                DHTBootstrapperImpl.this.nodeFetcher.start();
            } else {
                DHTBootstrapperImpl.this.bootstrap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleCancellationException(CancellationException e) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Ping Cancelled", e);
                if (DHTBootstrapperImpl.this.pingFuture != this.myFuture) {
                    return;
                }
                DHTBootstrapperImpl.this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleInterruptedException(InterruptedException e) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Ping Interrupted", e);
                if (DHTBootstrapperImpl.this.pingFuture != this.myFuture) {
                    return;
                }
                DHTBootstrapperImpl.this.stop();
            }
        }
    }
}

