/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.dht.DHTController;
import com.limegroup.gnutella.dht.DHTControllerFactory;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.NullDHTController;
import com.limegroup.gnutella.messages.vendor.DHTContactsMessage;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.core.settings.DHTSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.statistics.DHTStats;
import org.limewire.statistic.StatsUtils;
import org.limewire.util.ByteUtils;
import org.limewire.util.DebugRunnable;

@EagerSingleton
public class DHTManagerImpl
implements DHTManager,
Service {
    private static final Log LOG = LogFactory.getLog(DHTManagerImpl.class);
    private final Vendor vendor = ContextSettings.getVendor();
    private final Version version = ContextSettings.getVersion();
    private DHTController controller = new NullDHTController();
    private final List<DHTEventListener> dhtEventListeners = new ArrayList<DHTEventListener>(1);
    private final Executor executor;
    private final Executor dispatchExecutor;
    private volatile boolean enabled = true;
    private final DHTControllerFactory dhtControllerFactory;
    @InspectionPoint(value="time for dht bootstrap")
    private final BootstrapTimer bootstrapTimer = new BootstrapTimer();
    @InspectionPoint(value="dht get statistics")
    private final TimeValuesInspectable getInspectable = new TimeValuesInspectable();
    @InspectionPoint(value="dht put statistics")
    private final TimeValuesInspectable putInspectable = new TimeValuesInspectable();

    @Inject
    public DHTManagerImpl(@Named(value="dhtExecutor") Executor service, DHTControllerFactory dhtControllerFactory) {
        this.executor = service;
        this.dispatchExecutor = ExecutorsHelper.newProcessingQueue("DHT-EventDispatch");
        this.dhtControllerFactory = dhtControllerFactory;
        this.addEventListener(this.bootstrapTimer);
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Mojito DHT");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return !DHTSettings.DISABLE_DHT_NETWORK.getValue() && !DHTSettings.DISABLE_DHT_USER.getValue() && this.enabled;
    }

    @Override
    public synchronized void start(DHTManager.DHTMode mode) {
        this.executor.execute(this.createSwitchModeCommand(mode));
    }

    @Override
    public synchronized void stop() {
        DebugRunnable command = new DebugRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    try {
                        DHTManagerImpl.this.createSwitchModeCommand(DHTManager.DHTMode.INACTIVE).run();
                    }
                    finally {
                        DHTManagerImpl.this.notifyAll();
                    }
                }
            }
        });
        this.executor.execute(command);
        try {
            this.wait(10000L);
        }
        catch (InterruptedException err) {
            LOG.error("InterruptedException", err);
        }
    }

    private Runnable createSwitchModeCommand(final DHTManager.DHTMode mode) {
        DebugRunnable command = new DebugRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    if (DHTManagerImpl.this.controller.getDHTMode() == mode) {
                        return;
                    }
                    DHTManagerImpl.this.controller.stop();
                    if (mode == DHTManager.DHTMode.ACTIVE) {
                        DHTManagerImpl.this.controller = DHTManagerImpl.this.dhtControllerFactory.createActiveDHTNodeController(DHTManagerImpl.this.vendor, DHTManagerImpl.this.version, DHTManagerImpl.this);
                    } else if (mode == DHTManager.DHTMode.PASSIVE) {
                        DHTManagerImpl.this.controller = DHTManagerImpl.this.dhtControllerFactory.createPassiveDHTNodeController(DHTManagerImpl.this.vendor, DHTManagerImpl.this.version, DHTManagerImpl.this);
                    } else if (mode == DHTManager.DHTMode.PASSIVE_LEAF) {
                        DHTManagerImpl.this.controller = DHTManagerImpl.this.dhtControllerFactory.createPassiveLeafController(DHTManagerImpl.this.vendor, DHTManagerImpl.this.version, DHTManagerImpl.this);
                    } else {
                        DHTManagerImpl.this.controller = new NullDHTController();
                    }
                    DHTManagerImpl.this.controller.start();
                }
            }
        });
        return command;
    }

    @Override
    public void addActiveDHTNode(final SocketAddress hostAddress) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    DHTManagerImpl.this.controller.addActiveDHTNode(hostAddress);
                }
            }
        });
    }

    @Override
    public void addPassiveDHTNode(final SocketAddress hostAddress) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    DHTManagerImpl.this.controller.addPassiveDHTNode(hostAddress);
                }
            }
        });
    }

    @Override
    public void addressChanged() {
        this.executor.execute(new DebugRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    if (DHTManagerImpl.this.controller.isRunning()) {
                        DHTManagerImpl.this.controller.stop();
                        DHTManagerImpl.this.controller.start();
                    }
                }
            }
        }));
    }

    @Override
    public synchronized List<IpPort> getActiveDHTNodes(int maxNodes) {
        return this.controller.getActiveDHTNodes(maxNodes);
    }

    @Override
    public synchronized DHTManager.DHTMode getDHTMode() {
        return this.controller.getDHTMode();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.controller.isRunning();
    }

    @Override
    public synchronized boolean isBootstrapped() {
        return this.controller.isBootstrapped();
    }

    @Override
    public synchronized boolean isMemberOfDHT() {
        return this.isRunning() && this.isBootstrapped();
    }

    @Override
    public synchronized boolean isWaitingForNodes() {
        return this.controller.isWaitingForNodes();
    }

    @Override
    public synchronized void addEventListener(DHTEventListener listener) {
        if (this.dhtEventListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener " + listener + " already registered");
        }
        this.dhtEventListeners.add(listener);
    }

    @Override
    public synchronized void dispatchEvent(final DHTEvent event) {
        if (!this.dhtEventListeners.isEmpty()) {
            final ArrayList<DHTEventListener> listeners = new ArrayList<DHTEventListener>(this.dhtEventListeners);
            this.dispatchExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    for (DHTEventListener listener : listeners) {
                        listener.handleDHTEvent(event);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void removeEventListener(DHTEventListener listener) {
        this.dhtEventListeners.remove(listener);
    }

    @Override
    public synchronized MojitoDHT getMojitoDHT() {
        return this.controller.getMojitoDHT();
    }

    @Override
    public void handleConnectionLifecycleEvent(final ConnectionLifecycleEvent evt) {
        Runnable command = null;
        command = evt.isDisconnectedEvent() || evt.isNoInternetEvent() ? new DebugRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    if (DHTManagerImpl.this.controller.isRunning() && !DHTSettings.FORCE_DHT_CONNECT.getValue()) {
                        DHTManagerImpl.this.controller.stop();
                        DHTManagerImpl.this.controller = new NullDHTController();
                    }
                }
            }
        }) : new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    DHTManagerImpl.this.controller.handleConnectionLifecycleEvent(evt);
                }
            }
        };
        this.executor.execute(command);
    }

    @Override
    public Vendor getVendor() {
        return this.vendor;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void handleDHTContactsMessage(final DHTContactsMessage msg) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    for (Contact contact : msg.getContacts()) {
                        DHTManagerImpl.this.controller.addContact(contact);
                    }
                }
            }
        });
    }

    @Override
    public synchronized DHTFuture<FindValueResult> get(EntityKey eKey) {
        MojitoDHT mojitoDHT = this.getMojitoDHT();
        if (LOG.isDebugEnabled()) {
            LOG.debug("DHT:" + mojitoDHT);
        }
        if (mojitoDHT == null || !mojitoDHT.isBootstrapped()) {
            LOG.debug("DHT is null or is not bootstrapped");
            return null;
        }
        TimeInspector<FindValueResult> inspector = new TimeInspector<FindValueResult>(this.getInspectable){

            @Override
            public void handleFutureSuccess(FindValueResult result) {
                this.count(result.isSuccess());
            }
        };
        DHTFuture<FindValueResult> future = mojitoDHT.get(eKey);
        future.addDHTFutureListener((DHTFutureListener<FindValueResult>)inspector);
        return future;
    }

    @Override
    public synchronized DHTFuture<StoreResult> put(KUID key, DHTValue value) {
        MojitoDHT mojitoDHT = this.getMojitoDHT();
        if (LOG.isDebugEnabled()) {
            LOG.debug("DHT: " + mojitoDHT);
        }
        if (mojitoDHT == null || !mojitoDHT.isBootstrapped()) {
            LOG.debug("DHT is null or unable to bootstrap");
            return null;
        }
        TimeInspector<StoreResult> inspector = new TimeInspector<StoreResult>(this.putInspectable){

            @Override
            public void handleFutureSuccess(StoreResult result) {
                boolean success = (double)result.getLocations().size() > 0.8 * (double)KademliaSettings.REPLICATION_PARAMETER.getValue();
                this.count(success);
            }
        };
        DHTFuture<StoreResult> future = mojitoDHT.put(key, value);
        future.addDHTFutureListener((DHTFutureListener<StoreResult>)inspector);
        return future;
    }

    private static List<Double> getXorDistances(Double local, List<Double> others) {
        ArrayList<Double> distances = new ArrayList<Double>(others.size());
        for (Double l : others) {
            if (l == local) continue;
            distances.add(Double.valueOf(local.longValue() ^ l.longValue()));
        }
        return distances;
    }

    private static List<Double> getDouble(Collection<? extends Contact> nodes) {
        ArrayList<Double> doubles = new ArrayList<Double>(nodes.size());
        for (Contact contact : nodes) {
            doubles.add(DHTManagerImpl.getDoubleKUID(contact.getNodeID()));
        }
        return doubles;
    }

    private static double getDoubleKUID(KUID k) {
        byte[] b = k.getBytes();
        long x = b[0];
        for (int i = 1; i < 4; ++i) {
            x >>>= 8;
            x |= (long)b[i];
        }
        return x;
    }

    private static double getUnsignedMaskedAddress(Contact node) {
        InetSocketAddress addr = (InetSocketAddress)node.getContactAddress();
        long masked = (long)NetworkUtils.getClassC(addr.getAddress()) & 0xFFFFFFFFL;
        return masked;
    }

    static class TimeValuesInspectable
    implements Inspectable {
        final InspectionHistogram<Integer> successes = new InspectionHistogram();
        final InspectionHistogram<Integer> failures = new InspectionHistogram();
        volatile int maxSuccessful = 0;
        volatile int maxFailed = 0;

        TimeValuesInspectable() {
        }

        @Override
        public synchronized Object inspect() {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("success hist", this.successes.inspect());
            values.put("failure hist", this.failures.inspect());
            values.put("max success", this.maxSuccessful);
            values.put("max failure", this.maxFailed);
            return values;
        }
    }

    static class TimeInspector<T>
    extends DHTFutureAdapter<T> {
        private final long startTime = System.currentTimeMillis();
        private final TimeValuesInspectable values;

        public TimeInspector(TimeValuesInspectable values) {
            this.values = values;
        }

        public int getCurrentDuration() {
            return ByteUtils.long2int(System.currentTimeMillis() - this.startTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void count(boolean success) {
            int time = this.getCurrentDuration();
            int index = this.getIndex(time);
            if (success) {
                this.values.successes.count(index);
            } else {
                this.values.failures.count(index);
            }
            TimeValuesInspectable timeValuesInspectable = this.values;
            synchronized (timeValuesInspectable) {
                if (success) {
                    this.values.maxSuccessful = Math.max(this.values.maxSuccessful, time);
                } else {
                    this.values.maxFailed = Math.max(this.values.maxFailed, time);
                }
            }
        }

        public int getIndex(int time) {
            int i = time == 0 ? 0 : (time < 5000 && time > 0 ? time / 500 + 1 : (time < 10000 ? (time - 5000) / 1000 + 11 : (time < 60000 ? (time - 10000) / 5000 + 16 : (time < 180000 ? (time - 60000) / 10000 + 26 : (time < 360000 ? (time - 180000) / 30000 + 38 : 44)))));
            return i;
        }
    }

    private static class BootstrapTimer
    implements DHTEventListener,
    Inspectable {
        private long start;
        private long stop;

        private BootstrapTimer() {
        }

        @Override
        public synchronized Object inspect() {
            HashMap<String, Number> ret = new HashMap<String, Number>();
            ret.put("ver", 1);
            ret.put("start", this.start);
            ret.put("stop", this.stop);
            return ret;
        }

        @Override
        public synchronized void handleDHTEvent(DHTEvent evt) {
            if (evt.getType() == DHTEvent.Type.STARTING) {
                this.start = System.currentTimeMillis();
            } else if (evt.getType() == DHTEvent.Type.CONNECTED && this.start != 0L) {
                this.stop = System.currentTimeMillis();
            }
        }
    }

    private class DBHist
    implements Inspectable {
        private final int breaks;

        DBHist(int breaks) {
            this.breaks = breaks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object inspect() {
            MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
            if (dht != null) {
                ArrayList<BigInteger> primaryKeys;
                Database database;
                Database database2 = database = dht.getDatabase();
                synchronized (database2) {
                    Set<KUID> keys = database.keySet();
                    primaryKeys = new ArrayList<BigInteger>(keys.size());
                    for (KUID primaryKey : keys) {
                        primaryKeys.add(primaryKey.toBigInteger());
                    }
                }
                return StatsUtils.getHistogramBigInt(primaryKeys, this.breaks);
            }
            return Collections.emptyList();
        }
    }

    @InspectableContainer
    private class DHTInspectables {
        private static final int VERSION = 3;
        @InspectionPoint(value="general dht stats")
        public Inspectable general = new Inspectable(){

            @Override
            public Object inspect() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                DHTInspectables.this.addVersion(data);
                DHTManager.DHTMode mode = DHTManagerImpl.this.getDHTMode();
                boolean running = DHTManagerImpl.this.isRunning();
                boolean bootstrapped = DHTManagerImpl.this.isBootstrapped();
                boolean waiting = DHTManagerImpl.this.isWaitingForNodes();
                boolean enabled = DHTManagerImpl.this.isEnabled();
                Version version = DHTManagerImpl.this.getVersion();
                data.put("mode", mode.byteValue());
                data.put("v", version.shortValue());
                data.put("r", running);
                data.put("b", bootstrapped);
                data.put("w", waiting);
                data.put("e", enabled);
                MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                if (dht != null) {
                    data.put("s", dht.size().toByteArray());
                    RouteTable routeTable = dht.getRouteTable();
                    Contact localNode = routeTable.getLocalNode();
                    data.put("id", localNode.getNodeID().getBytes());
                }
                return data;
            }
        };
        @InspectionPoint(value="dht contacts")
        public Inspectable contacts = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
                DHTInspectables.this.addVersion(data);
                MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                if (dht != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = dht.getRouteTable();
                    synchronized (routeTable2) {
                        double masked;
                        double local = DHTManagerImpl.getDoubleKUID(routeTable.getLocalNode().getNodeID());
                        List activeContacts = DHTManagerImpl.getDouble(routeTable.getActiveContacts());
                        data.put("acc", StatsUtils.quickStatsDouble(activeContacts).getMap());
                        data.put("accx", StatsUtils.quickStatsDouble(DHTManagerImpl.getXorDistances(local, activeContacts)).getMap());
                        List cachedContacts = DHTManagerImpl.getDouble(routeTable.getCachedContacts());
                        data.put("ccc", StatsUtils.quickStatsDouble(cachedContacts).getMap());
                        data.put("cccx", StatsUtils.quickStatsDouble(DHTManagerImpl.getXorDistances(local, cachedContacts)).getMap());
                        ArrayList<Double> activeIps = new ArrayList<Double>();
                        ArrayList<Double> cachedIps = new ArrayList<Double>();
                        ArrayList<Double> allIps = new ArrayList<Double>();
                        for (Contact node : routeTable.getActiveContacts()) {
                            masked = DHTManagerImpl.getUnsignedMaskedAddress(node);
                            activeIps.add(masked);
                            allIps.add(masked);
                        }
                        for (Contact node : routeTable.getCachedContacts()) {
                            masked = DHTManagerImpl.getUnsignedMaskedAddress(node);
                            cachedIps.add(masked);
                            allIps.add(masked);
                        }
                        data.put("aips", StatsUtils.quickStatsDouble(activeIps).getMap());
                        data.put("cips", StatsUtils.quickStatsDouble(cachedIps).getMap());
                        data.put("allips", StatsUtils.quickStatsDouble(allIps).getMap());
                    }
                }
                return data;
            }
        };
        @InspectionPoint(value="dht route table dump")
        public Inspectable RTDump = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap<String, Collection<Contact>> data = new HashMap<String, Collection<Contact>>();
                DHTInspectables.this.addVersion(data);
                MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                if (dht != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = dht.getRouteTable();
                    synchronized (routeTable2) {
                        data.put("active", routeTable.getActiveContacts());
                        data.put("cached", routeTable.getCachedContacts());
                    }
                }
                return data;
            }
        };
        @InspectionPoint(value="dht route table class C networks")
        public Inspectable routeTableTop10Networks = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap<String, byte[]> data = new HashMap<String, byte[]>();
                DHTInspectables.this.addVersion(data);
                MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                if (dht != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = dht.getRouteTable();
                    synchronized (routeTable2) {
                        data.put("ta", this.getTopNetworks(routeTable.getActiveContacts(), 10));
                        data.put("tc", this.getTopNetworks(routeTable.getCachedContacts(), 10));
                    }
                }
                return data;
            }

            private byte[] getTopNetworks(Collection<? extends Contact> nodes, int count) {
                ClassCNetworks classCNetworks = new ClassCNetworks();
                for (Contact contact : nodes) {
                    InetAddress addr = ((InetSocketAddress)contact.getContactAddress()).getAddress();
                    classCNetworks.add(addr, 1);
                }
                return classCNetworks.getTopInspectable(10);
            }
        };
        @InspectionPoint(value="dht buckets")
        public Inspectable buckets = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                DHTInspectables.this.addVersion(data);
                MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                if (dht != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = dht.getRouteTable();
                    synchronized (routeTable2) {
                        double local = DHTManagerImpl.getDoubleKUID(routeTable.getLocalNode().getNodeID());
                        Collection<Bucket> buckets = routeTable.getBuckets();
                        ArrayList<Double> depths = new ArrayList<Double>(buckets.size());
                        ArrayList<Double> sizes = new ArrayList<Double>(buckets.size());
                        ArrayList<Double> kuids = new ArrayList<Double>(buckets.size());
                        ArrayList<Double> times = new ArrayList<Double>(buckets.size());
                        double fresh = 0.0;
                        long now = System.currentTimeMillis();
                        for (Bucket bucket : buckets) {
                            depths.add(Double.valueOf(bucket.getDepth()));
                            sizes.add(Double.valueOf(bucket.size()));
                            kuids.add(DHTManagerImpl.getDoubleKUID(bucket.getBucketID()));
                            times.add(Double.valueOf(now - bucket.getTimeStamp()));
                            if (bucket.isRefreshRequired()) continue;
                            fresh += 1.0;
                        }
                        data.put("bk", StatsUtils.quickStatsDouble(kuids).getMap());
                        data.put("bkx", StatsUtils.quickStatsDouble(DHTManagerImpl.getXorDistances(local, kuids)).getMap());
                        data.put("bd", StatsUtils.quickStatsDouble(depths).getMap());
                        data.put("bs", StatsUtils.quickStatsDouble(sizes).getMap());
                        data.put("bt", StatsUtils.quickStatsDouble(times).getMap());
                        data.put("bfr", (int)(100.0 * fresh / (double)buckets.size()));
                    }
                }
                return data;
            }
        };
        @InspectionPoint(value="dht buckets detailed")
        public Inspectable bucketDetail = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                ArrayList data = new ArrayList();
                MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                if (dht != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = dht.getRouteTable();
                    synchronized (routeTable2) {
                        Collection<Bucket> buckets = routeTable.getBuckets();
                        for (Bucket bucket : buckets) {
                            HashMap<String, Object> detail = new HashMap<String, Object>();
                            detail.put("i", bucket.getBucketID().getBytes());
                            detail.put("d", bucket.getDepth());
                            detail.put("t", System.currentTimeMillis() - bucket.getTimeStamp());
                            detail.put("a", bucket.getActiveSize());
                            detail.put("c", bucket.getCacheSize());
                            detail.put("f", !bucket.isRefreshRequired());
                            data.add(detail);
                        }
                    }
                }
                return data;
            }
        };
        @InspectionPoint(value="dht database")
        public Inspectable database = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                DHTInspectables.this.addVersion(data);
                MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                if (dht != null) {
                    Database database = dht.getDatabase();
                    Double local = DHTManagerImpl.getDoubleKUID(dht.getLocalNodeID());
                    ArrayList<Double> primaryKeys = null;
                    ArrayList<Double> requestLoads = null;
                    ArrayList<Double> distanceToLoad = null;
                    Database database2 = database;
                    synchronized (database2) {
                        data.put("dvc", database.getValueCount());
                        Set<KUID> keys = database.keySet();
                        primaryKeys = new ArrayList<Double>(keys.size());
                        requestLoads = new ArrayList<Double>(keys.size());
                        distanceToLoad = new ArrayList<Double>(keys.size());
                        for (KUID primaryKey : keys) {
                            Double big = DHTManagerImpl.getDoubleKUID(primaryKey);
                            double load = database.getRequestLoad(primaryKey, false);
                            primaryKeys.add(big);
                            requestLoads.add(load);
                            if (local == big) continue;
                            big = local.longValue() ^ big.longValue();
                            distanceToLoad.add(big - load * 2.147483647E9);
                        }
                    }
                    List storedXorDistances = DHTManagerImpl.getXorDistances(local, primaryKeys);
                    data.put("dsk", StatsUtils.quickStatsDouble(primaryKeys).getMap());
                    data.put("drl", StatsUtils.quickStatsDouble(requestLoads).getMap());
                    data.put("dskx", StatsUtils.quickStatsDouble(storedXorDistances).getMap());
                    data.put("dxlt", StatsUtils.quickStatsDouble(distanceToLoad).getTTestMap());
                }
                return data;
            }
        };
        @InspectionPoint(value="dht database top 10 keys")
        public Inspectable databaseTop10Keys = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                ArrayList<byte[]> ret = new ArrayList<byte[]>();
                MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                if (dht != null) {
                    Database database = dht.getDatabase();
                    TreeMap<Double, KUID> popularKeys = new TreeMap<Double, KUID>(Comparators.inverseDoubleComparator());
                    Database database2 = database;
                    synchronized (database2) {
                        Set<KUID> keys = database.keySet();
                        for (KUID primaryKey : keys) {
                            popularKeys.put(Double.valueOf(database.getRequestLoad(primaryKey, false)), primaryKey);
                        }
                    }
                    Iterator i$ = popularKeys.keySet().iterator();
                    while (i$.hasNext()) {
                        double load = (Double)i$.next();
                        if (ret.size() >= 20) break;
                        ret.add(BigInteger.valueOf(Double.doubleToLongBits(load)).toByteArray());
                        ret.add(((KUID)popularKeys.get(load)).getBytes());
                    }
                }
                return ret;
            }
        };
        @InspectionPoint(value="dht internal format stats")
        public Inspectable mojitoStats = new Inspectable(){

            @Override
            public Object inspect() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8"));
                try {
                    MojitoDHT dht = DHTManagerImpl.this.getMojitoDHT();
                    if (dht != null) {
                        DHTStats stats = dht.getDHTStats();
                        stats.dump(w, false);
                        ((Writer)w).flush();
                        return baos.toByteArray();
                    }
                    return null;
                }
                catch (IOException impossible) {
                    return impossible.getMessage();
                }
            }
        };
        @InspectionPoint(value="dht database 10 histogram")
        public Inspectable database10StoredHist = new DBHist(10);
        @InspectionPoint(value="dht database 100 histogram")
        public Inspectable database100StoredHist = new DBHist(100);
        @InspectionPoint(value="dht database 500 histogram")
        public Inspectable database500StoredHist = new DBHist(500);

        private DHTInspectables() {
        }

        private void addVersion(Map<String, Object> m) {
            m.put("sv", 3);
        }
    }
}

