/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.limegroup.gnutella.dht.AbstractDHTController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.PassiveLeafRouteTable;
import com.limegroup.gnutella.util.EventDispatcher;
import org.limewire.mojito.Context;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.MojitoFactory;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;

class PassiveLeafController
extends AbstractDHTController {
    private RouteTable routeTable;

    PassiveLeafController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> dispatcher, DHTControllerFacade dhtControllerFacade) {
        super(vendor, version, dispatcher, DHTManager.DHTMode.PASSIVE_LEAF, dhtControllerFacade);
    }

    @Override
    protected MojitoDHT createMojitoDHT(Vendor vendor, Version version) {
        MojitoDHT dht = MojitoFactory.createFirewalledDHT("PassiveLeafDHT", vendor, version);
        ((Context)dht).setBootstrapped(true);
        ((Context)dht).setBucketRefresherDisabled(true);
        this.routeTable = new PassiveLeafRouteTable(vendor, version);
        dht.setRouteTable(this.routeTable);
        assert (dht.isFirewalled());
        return dht;
    }

    @Override
    public void start() {
        super.start();
        if (this.isRunning()) {
            this.sendUpdatedCapabilities();
        }
    }
}

