/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SocketProcessor;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.PushedSocketHandler;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PushRequestImpl;
import com.limegroup.gnutella.util.MultiShutdownable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GUID;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkUtils;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.RegisteringEventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.net.ConnectivityChangeEvent;
import org.limewire.net.SocketsManager;
import org.limewire.net.address.AddressConnector;
import org.limewire.net.address.AddressEvent;
import org.limewire.net.address.FirewalledAddress;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.AbstractChannelInterestReader;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.rudp.UDPSelectorProvider;
import org.limewire.util.Base32;
import org.limewire.util.BufferUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.URIUtils;

@EagerSingleton
public class PushDownloadManager
implements ConnectionAcceptor,
PushedSocketHandlerRegistry,
AddressConnector,
RegisteringEventListener<AddressEvent> {
    private static final Log LOG = LogFactory.getLog(PushDownloadManager.class, "address-connecting");
    private static final int SPECIAL_INDEX = 0;
    private static long UDP_PUSH_FAILTIME = 5000L;
    private final ExecutorService PUSH_THREAD_POOL = ExecutorsHelper.newFixedSizeThreadPool(10, "PushProxy Requests");
    private final Map<byte[], AtomicInteger> UDP_FAILOVER = new TreeMap<byte[], AtomicInteger>(new GUID.GUIDByteComparator());
    private final Provider<SocketProcessor> socketProcessor;
    private final Provider<HttpExecutor> httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final ScheduledExecutorService backgroundExecutor;
    private final NetworkManager networkManager;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<IPFilter> ipFilter;
    private final Provider<UDPService> udpService;
    private final CopyOnWriteArrayList<PushedSocketHandler> pushHandlers = new CopyOnWriteArrayList();
    private final Provider<UDPSelectorProvider> udpSelectorProvider;
    private final Provider<PushEndpointCache> pushEndpointCache;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final EventBroadcaster<ConnectivityChangeEvent> connectivityEventBroadcaster;
    private final AtomicBoolean acceptedIncomingConnectionEventFired = new AtomicBoolean(false);
    private final AtomicBoolean canDoFWTEventFired = new AtomicBoolean(false);

    @Inject
    public PushDownloadManager(Provider<MessageRouter> router, Provider<HttpExecutor> executor, @Named(value="defaults") Provider<HttpParams> defaultParams, @Named(value="backgroundExecutor") ScheduledExecutorService scheduler, Provider<SocketProcessor> processor, NetworkManager networkManager, Provider<IPFilter> ipFilter, Provider<UDPService> udpService, Provider<UDPSelectorProvider> udpSelectorProvider, Provider<PushEndpointCache> pushEndpointCache, RemoteFileDescFactory remoteFileDescFactory, EventBroadcaster<ConnectivityChangeEvent> connectivityEventBroadcaster) {
        this.messageRouter = router;
        this.httpExecutor = executor;
        this.defaultParams = defaultParams;
        this.backgroundExecutor = scheduler;
        this.socketProcessor = processor;
        this.networkManager = networkManager;
        this.ipFilter = ipFilter;
        this.udpService = udpService;
        this.udpSelectorProvider = udpSelectorProvider;
        this.pushEndpointCache = pushEndpointCache;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.connectivityEventBroadcaster = connectivityEventBroadcaster;
    }

    @Override
    public void register(PushedSocketHandler handler) {
        this.pushHandlers.add(handler);
    }

    @Inject
    public void register(SocketsManager socketsManager) {
        socketsManager.registerConnector(this);
    }

    @Override
    @Inject
    public void register(ListenerSupport<AddressEvent> addressEventListenerSupport) {
        addressEventListenerSupport.addListener(this);
    }

    @Override
    public void handleEvent(AddressEvent event) {
        if (this.networkManager.acceptedIncomingConnection()) {
            if (this.acceptedIncomingConnectionEventFired.compareAndSet(false, true)) {
                this.connectivityEventBroadcaster.broadcast(new ConnectivityChangeEvent());
            }
        } else if (this.networkManager.canDoFWT() && this.canDoFWTEventFired.compareAndSet(false, true)) {
            this.connectivityEventBroadcaster.broadcast(new ConnectivityChangeEvent());
        }
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void acceptConnection(String word, Socket socket) {
        ((NIOMultiplexor)((Object)socket)).setReadObserver(new GivParser(socket));
    }

    @Override
    public void connect(Address address, ConnectObserver observer) {
        if (address instanceof FirewalledAddress) {
            this.connect((FirewalledAddress)address, observer);
        } else if (address instanceof PushEndpoint) {
            this.connect((PushEndpoint)address, observer);
        }
    }

    private void connect(PushEndpoint pushEndpoint, ConnectObserver observer) {
        RemoteFileDesc fakeRFD = this.remoteFileDescFactory.createRemoteFileDesc(pushEndpoint, 0L, "fake", 0L, pushEndpoint.getClientGUID(), 0, 0, false, null, URN.NO_URN_SET, false, "", -1L, true, null);
        this.connect(fakeRFD, observer);
    }

    private void connect(FirewalledAddress address, ConnectObserver observer) {
        RemoteFileDesc fakeRFD = this.remoteFileDescFactory.createRemoteFileDesc(address, 0L, "fake", 0L, address.getClientGuid().bytes(), 0, 0, false, null, URN.NO_URN_SET, false, "", -1L, true, null);
        this.connect(fakeRFD, observer);
    }

    private void connect(RemoteFileDesc rfd, ConnectObserver observer) {
        PushedSocketHandlerAdapter handlerAdapter = new PushedSocketHandlerAdapter(rfd, observer);
        this.pushHandlers.add(handlerAdapter);
        this.sendPush(rfd, handlerAdapter);
        this.scheduleExpirerFor(handlerAdapter, 30000);
    }

    private void scheduleExpirerFor(final PushedSocketHandlerAdapter handlerAdapter, int timeout) {
        this.backgroundExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                PushDownloadManager.this.pushHandlers.remove(handlerAdapter);
                handlerAdapter.handleTimeout();
            }
        }, (long)timeout, TimeUnit.MILLISECONDS);
    }

    public void sendPush(RemoteFileDesc file) {
        this.sendPush(file, new NullMultiShutdownable());
    }

    private boolean hasValidLocalAddress() {
        byte[] addr = this.networkManager.getAddress();
        int port = this.networkManager.getPort();
        return NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port);
    }

    public void sendPush(RemoteFileDesc file, MultiShutdownable observer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending push: " + file);
        }
        if (!this.hasValidLocalAddress()) {
            LOG.debug("no valid address or port yet");
            observer.shutdown();
            return;
        }
        byte[] guid = GUID.makeGuid();
        if (this.sendPushMulticast(file, guid)) {
            return;
        }
        if (!this.networkManager.acceptedIncomingConnection()) {
            if (this.networkManager.canDoFWT()) {
                this.sendPushTCP(file, guid, observer);
            } else {
                LOG.debug("Firewalled and can't do FWT yet");
                observer.shutdown();
            }
            return;
        }
        if (!file.isFromAlternateLocation()) {
            this.addUDPFailover(file);
            this.backgroundExecutor.schedule(new PushFailoverRequestor(file, guid, observer), UDP_PUSH_FAILTIME, TimeUnit.MILLISECONDS);
        }
        this.sendPushUDP(file, guid);
    }

    private boolean sendPushMulticast(RemoteFileDesc file, byte[] guid) {
        if (file.isReplyToMulticast()) {
            byte[] addr = this.networkManager.getNonForcedAddress();
            int port = this.networkManager.getNonForcedPort();
            if (NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port)) {
                PushRequestImpl pr = new PushRequestImpl(guid, 1, file.getClientGUID(), file.getIndex(), addr, port, Message.Network.MULTICAST, this.networkManager.isIncomingTLSEnabled());
                this.messageRouter.get().sendMulticastPushRequest(pr);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Sending push request through multicast " + pr);
                }
                return true;
            }
        }
        return false;
    }

    private Set<? extends IpPort> getPushProxies(RemoteFileDesc rfd) {
        Address address = rfd.getAddress();
        if (address instanceof PushEndpoint) {
            return ((PushEndpoint)address).getProxies();
        }
        if (address instanceof FirewalledAddress) {
            return ((FirewalledAddress)address).getPushProxies();
        }
        return IpPort.EMPTY_SET;
    }

    private IpPort getPublicAddress(Address address) {
        if (address instanceof PushEndpoint) {
            IpPort externalAddress = ((PushEndpoint)address).getValidExternalAddress();
            return externalAddress != null ? externalAddress : ConnectableImpl.INVALID_CONNECTABLE;
        }
        if (address instanceof FirewalledAddress) {
            return ((FirewalledAddress)address).getPublicAddress();
        }
        return ConnectableImpl.INVALID_CONNECTABLE;
    }

    private boolean sendPushUDP(RemoteFileDesc file, byte[] guid) {
        PushRequestImpl pr = new PushRequestImpl(guid, 2, file.getClientGUID(), file.getIndex(), this.networkManager.getAddress(), this.networkManager.getPort(), Message.Network.UDP, this.networkManager.isIncomingTLSEnabled());
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through udp " + pr);
        }
        UDPService udpService = this.udpService.get();
        IpPort publicAddress = this.getPublicAddress(file.getAddress());
        boolean sent = false;
        if (NetworkUtils.isValidIpPort(publicAddress)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("sending push to host itself via udp: " + publicAddress);
            }
            udpService.send((Message)pr, publicAddress);
            sent = true;
        }
        for (IpPort ipPort : this.getPushProxies(file)) {
            if (this.ipFilter.get().allow(ipPort.getAddress())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sending udp push to: " + ipPort);
                }
                udpService.send((Message)pr, ipPort.getInetSocketAddress());
                sent = true;
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("removing disallowed pushproxy: " + ipPort);
            }
            this.removePushProxy(file.getClientGUID(), ipPort);
        }
        return sent;
    }

    private void sendPushTCP(RemoteFileDesc file, byte[] guid, MultiShutdownable observer) {
        boolean shouldDoFWTransfer = PushDownloadManager.getFWTVersion(file.getAddress()) > 0 && this.networkManager.canDoFWT() && !this.networkManager.acceptedIncomingConnection();
        PushData data = new PushData(observer, file, guid, shouldDoFWTransfer);
        Set<? extends IpPort> proxies = this.getPushProxies(file);
        if (proxies.isEmpty()) {
            this.sendPushThroughNetwork(data);
            return;
        }
        this.sendPushThroughProxies(data, proxies);
    }

    private void sendPushThroughNetwork(PushData data) {
        int port;
        LOG.debug("sending through network");
        data.getMultiShutdownable().addShutdownable(null);
        if (data.isFWTransfer() && !this.networkManager.acceptedIncomingConnection()) {
            LOG.debug("through network, FWT and not accepted incoming connection");
            data.getMultiShutdownable().shutdown();
            return;
        }
        byte[] addr = this.networkManager.getAddress();
        if (!NetworkUtils.isValidAddressAndPort(addr, port = this.networkManager.getPort())) {
            LOG.debug("through network, no valid address or port");
            data.getMultiShutdownable().shutdown();
            return;
        }
        PushRequestImpl pr = new PushRequestImpl(data.getGuid(), ConnectionSettings.TTL.getValue(), data.getFile().getClientGUID(), data.getFile().getIndex(), addr, port, Message.Network.TCP, this.networkManager.isIncomingTLSEnabled());
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through Gnutella: " + pr);
        }
        try {
            this.messageRouter.get().sendPushRequest(pr);
        }
        catch (IOException e) {
            LOG.debug("no route sending through network");
            data.getMultiShutdownable().shutdown();
        }
    }

    private void sendPushThroughProxies(PushData data, Set<? extends IpPort> proxies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sending through proxies: " + proxies);
        }
        byte[] externalAddr = this.networkManager.getExternalAddress();
        if (data.isFWTransfer() && !NetworkUtils.isValidAddress(externalAddr)) {
            LOG.debug("FWT, but no valid external address yet");
            data.getMultiShutdownable().shutdown();
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("using guid: " + new GUID(data.getFile().getClientGUID()));
        }
        String request = "/gnutella/push-proxy?ServerID=" + Base32.encode(data.getFile().getClientGUID()) + (data.isFWTransfer() ? "&file=2147483645" : "") + (this.networkManager.isIncomingTLSEnabled() ? "&tls=true" : "");
        String nodeString = HTTPHeaderName.NODE.httpStringValue();
        String nodeValue = data.isFWTransfer() ? NetworkUtils.ip2string(externalAddr) + ":" + this.networkManager.getStableUDPPort() : NetworkUtils.ip2string(this.networkManager.getAddress()) + ":" + this.networkManager.getPort();
        ArrayList<HttpHead> methods = new ArrayList<HttpHead>();
        for (IpPort ipPort : proxies) {
            if (!this.ipFilter.get().allow(ipPort.getAddress())) {
                this.removePushProxy(data.file.getClientGUID(), ipPort);
                continue;
            }
            String protocol = "http://";
            if (ipPort instanceof Connectable && ((Connectable)ipPort).isTLSCapable()) {
                protocol = "tls://";
            }
            String connectTo = protocol + ipPort.getAddress() + ":" + ipPort.getPort() + request;
            HttpHead head = null;
            head = new HttpHead(connectTo);
            head.addHeader(nodeString, nodeValue);
            head.addHeader("Cache-Control", "no-cache");
            methods.add(head);
        }
        if (!methods.isEmpty()) {
            PushHttpClientListener l = new PushHttpClientListener(methods, data);
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout(basicHttpParams, 5000);
            HttpConnectionParams.setSoTimeout(basicHttpParams, 5000);
            DefaultedHttpParams defaultedHttpParams = new DefaultedHttpParams(basicHttpParams, this.defaultParams.get());
            Shutdownable s = this.httpExecutor.get().executeAny(l, this.PUSH_THREAD_POOL, methods, defaultedHttpParams, data.getMultiShutdownable());
            data.getMultiShutdownable().addShutdownable(s);
        } else {
            this.sendPushThroughNetwork(data);
        }
    }

    private void removePushProxy(byte[] guid, URI uri) {
        block2: {
            try {
                IpPortImpl pushProxy = new IpPortImpl(uri.getHost(), uri.getPort());
                this.removePushProxy(guid, pushProxy);
            }
            catch (UnknownHostException uhe) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("exception on host that should have worked", uhe);
            }
        }
    }

    private void removePushProxy(byte[] guid, IpPort pushProxy) {
        this.pushEndpointCache.get().removePushProxy(guid, pushProxy);
    }

    void handleGIV(Socket socket, GIVLine line) {
        String file = line.file;
        int index = 0;
        byte[] clientGUID = line.clientGUID;
        this.cancelUDPFailover(clientGUID);
        if (LOG.isDebugEnabled()) {
            LOG.debug("receiving socket: " + socket + ", line: " + line);
        }
        boolean accepted = false;
        for (PushedSocketHandler handler : this.pushHandlers) {
            if (!handler.acceptPushedSocket(file, index, clientGUID, socket)) continue;
            accepted = true;
            break;
        }
        if (!accepted) {
            IOUtils.close(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUDPFailover(RemoteFileDesc file) {
        Map<byte[], AtomicInteger> map = this.UDP_FAILOVER;
        synchronized (map) {
            byte[] key = file.getClientGUID();
            AtomicInteger requests = this.UDP_FAILOVER.get(key);
            if (requests == null) {
                requests = new AtomicInteger(0);
                this.UDP_FAILOVER.put(key, requests);
            }
            requests.addAndGet(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUDPFailover(byte[] clientGUID) {
        Map<byte[], AtomicInteger> map = this.UDP_FAILOVER;
        synchronized (map) {
            byte[] key = clientGUID;
            AtomicInteger requests = this.UDP_FAILOVER.get(key);
            if (requests != null && requests.decrementAndGet() <= 0) {
                this.UDP_FAILOVER.remove(key);
            }
        }
    }

    @Override
    public boolean canConnect(Address address) {
        int fwtVersion = PushDownloadManager.getFWTVersion(address);
        if (fwtVersion == -1) {
            LOG.debugf("cannot connect: remote address {0} cannot do fwt", (Object)address);
            return false;
        }
        if (this.hasValidLocalAddress()) {
            if (this.networkManager.acceptedIncomingConnection()) {
                LOG.debug("can connect: local address accepted incoming connection");
                return true;
            }
            if (this.networkManager.canDoFWT() && fwtVersion > 0 && NetworkUtils.isValidIpPort(this.getPublicAddress(address))) {
                LOG.debug("can connect: local and remote address can do fwt");
                return true;
            }
            LOG.debugf("can not connect: have not accepted incoming connection and can not do FWT or invalid address: {0}", (Object)address);
        } else {
            LOG.debug(" can not connect: no local valid address");
        }
        LOG.debugf("cannot connect to {0}, local fwt {1}", (Object)address, (Object)this.networkManager.canDoFWT());
        return false;
    }

    private static int getFWTVersion(Address address) {
        if (address instanceof FirewalledAddress) {
            FirewalledAddress firewalledAddress = (FirewalledAddress)address;
            if (NetworkUtils.isValidIpPort(firewalledAddress.getPrivateAddress())) {
                return firewalledAddress.getFwtVersion();
            }
            LOG.debugf("inconsistent firewalled address: {0}", (Object)firewalledAddress);
            throw new IllegalArgumentException("inconsistent firewalled address: " + firewalledAddress);
        }
        if (address instanceof PushEndpoint) {
            return ((PushEndpoint)address).getFWTVersion();
        }
        return -1;
    }

    private class PushedSocketHandlerAdapter
    implements PushedSocketHandler,
    MultiShutdownable {
        private final RemoteFileDesc rfd;
        private final ConnectObserver observer;
        private final AtomicBoolean acceptedOrFailed = new AtomicBoolean(false);

        public PushedSocketHandlerAdapter(RemoteFileDesc rfd, ConnectObserver observer) {
            this.rfd = rfd;
            this.observer = observer;
        }

        @Override
        public boolean acceptPushedSocket(String file, int index, byte[] clientGUID, Socket socket) {
            if (Arrays.equals(this.rfd.getClientGUID(), clientGUID)) {
                PushDownloadManager.this.pushHandlers.remove(this);
                IpPort publicAddress = PushDownloadManager.this.getPublicAddress(this.rfd.getAddress());
                if (NetworkUtils.isValidIpPort(publicAddress) && !publicAddress.getInetAddress().equals(socket.getInetAddress()) && LOG.isDebugEnabled()) {
                    LOG.debug("received socket from unexpected location, expected: " + publicAddress.getInetAddress() + ", actual: " + socket.getInetAddress());
                    return false;
                }
                if (this.acceptedOrFailed.compareAndSet(false, true)) {
                    try {
                        this.observer.handleConnect(socket);
                    }
                    catch (IOException e) {
                        IOUtils.close(socket);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        public void handleTimeout() {
            if (this.acceptedOrFailed.compareAndSet(false, true)) {
                this.observer.handleIOException(new ConnectException("push timed out"));
            }
        }

        @Override
        public void addShutdownable(Shutdownable shutdowner) {
        }

        @Override
        public void shutdown() {
            if (this.acceptedOrFailed.compareAndSet(false, true)) {
                this.observer.handleIOException(new ConnectException("shut down"));
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }

    private static class NullMultiShutdownable
    implements MultiShutdownable {
        private NullMultiShutdownable() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void addShutdownable(Shutdownable newCancel) {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }

    private static class FWTConnectObserver
    implements ConnectObserver {
        private final SocketProcessor processor;

        FWTConnectObserver(SocketProcessor processor) {
            this.processor = processor;
        }

        @Override
        public void handleIOException(IOException iox) {
        }

        @Override
        public void handleConnect(Socket socket) throws IOException {
            this.processor.processSocket(socket, "GIV");
        }

        @Override
        public void shutdown() {
        }
    }

    static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String file, int index, byte[] clientGUID) {
            this.file = file;
            this.index = index;
            this.clientGUID = clientGUID;
        }

        public String toString() {
            return StringUtils.toString(this, new Object[0]);
        }
    }

    private class GivParser
    extends AbstractChannelInterestReader {
        private final Socket socket;
        private final StringBuilder givSB;
        private final StringBuilder blankSB;
        private boolean readBlank;
        private GIVLine giv;

        GivParser(Socket socket) {
            super(1024);
            this.givSB = new StringBuilder();
            this.blankSB = new StringBuilder();
            this.socket = socket;
        }

        @Override
        public void handleRead() throws IOException {
            block6: {
                do {
                    int read = 0;
                    while (this.buffer.hasRemaining() && (read = this.source.read(this.buffer)) > 0) {
                    }
                    if (this.buffer.position() == 0) {
                        if (read != -1) break block6;
                        this.close();
                        break block6;
                    }
                    this.buffer.flip();
                    if (this.giv == null && BufferUtils.readLine(this.buffer, this.givSB)) {
                        this.giv = this.parseLine(this.givSB.toString());
                    }
                    if (this.giv != null && !this.readBlank) {
                        this.readBlank = BufferUtils.readLine(this.buffer, this.blankSB);
                        if (this.blankSB.length() > 0) {
                            throw new IOException("didn't read blank line");
                        }
                    }
                    this.buffer.compact();
                } while (!this.readBlank);
                PushDownloadManager.this.handleGIV(this.socket, this.giv);
            }
        }

        private GIVLine parseLine(String command) throws IOException {
            try {
                int i = command.indexOf(":");
                int index = Integer.parseInt(command.substring(0, i));
                int j = command.indexOf("/", i);
                byte[] guid = GUID.fromHexString(command.substring(i + 1, j));
                String filename = URIUtils.decodeToUtf8(command.substring(j + 1));
                return new GIVLine(filename, index, guid);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException(e);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
    }

    private class PushFailoverRequestor
    implements Runnable {
        final RemoteFileDesc _file;
        final byte[] _guid;
        final MultiShutdownable connector;

        public PushFailoverRequestor(RemoteFileDesc file, byte[] guid, MultiShutdownable connector) {
            this._file = file;
            this._guid = guid;
            this.connector = connector;
        }

        @Override
        public void run() {
            if (this.shouldProceed()) {
                PushDownloadManager.this.sendPushTCP(this._file, this._guid, this.connector);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean shouldProceed() {
            byte[] key = this._file.getClientGUID();
            Map map = PushDownloadManager.this.UDP_FAILOVER;
            synchronized (map) {
                AtomicInteger requests = (AtomicInteger)PushDownloadManager.this.UDP_FAILOVER.get(key);
                if (requests != null && requests.get() > 0) {
                    if (requests.decrementAndGet() == 0) {
                        PushDownloadManager.this.UDP_FAILOVER.remove(key);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static class PushData {
        private final MultiShutdownable observer;
        private final RemoteFileDesc file;
        private final byte[] guid;
        private final boolean shouldDoFWTransfer;

        PushData(MultiShutdownable observer, RemoteFileDesc file, byte[] guid, boolean shouldDoFWTransfer) {
            this.observer = observer;
            this.file = file;
            this.guid = guid;
            this.shouldDoFWTransfer = shouldDoFWTransfer;
        }

        public RemoteFileDesc getFile() {
            return this.file;
        }

        public byte[] getGuid() {
            return this.guid;
        }

        public MultiShutdownable getMultiShutdownable() {
            return this.observer;
        }

        public boolean isFWTransfer() {
            return this.shouldDoFWTransfer;
        }
    }

    private class PushHttpClientListener
    implements HttpClientListener {
        private final Collection<HttpUriRequest> methods;
        private final PushData data;

        PushHttpClientListener(Collection<? extends HttpUriRequest> methods, PushData data) {
            this.methods = new LinkedList<HttpUriRequest>(methods);
            this.data = data;
        }

        @Override
        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("PushProxy request exception: " + request.getURI(), exc);
            }
            ((HttpExecutor)PushDownloadManager.this.httpExecutor.get()).releaseResources(response);
            this.methods.remove(request);
            URI uri = request.getURI();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing push proxy: " + uri + " for " + new GUID(this.data.file.getClientGUID()));
            }
            PushDownloadManager.this.removePushProxy(this.data.file.getClientGUID(), uri);
            if (this.methods.isEmpty()) {
                PushDownloadManager.this.sendPushThroughNetwork(this.data);
            }
            return true;
        }

        @Override
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            this.methods.remove(request);
            int statusCode = response.getStatusLine().getStatusCode();
            ((HttpExecutor)PushDownloadManager.this.httpExecutor.get()).releaseResources(response);
            if (statusCode == 202) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Successful push proxy: " + request.getURI());
                }
                if (this.data.isFWTransfer()) {
                    LOG.debug("Starting fwt communication");
                    AbstractNBSocket socket = ((UDPSelectorProvider)PushDownloadManager.this.udpSelectorProvider.get()).openSocketChannel().socket();
                    this.data.getMultiShutdownable().addShutdownable(socket);
                    IpPort publicAddress = PushDownloadManager.this.getPublicAddress(this.data.getFile().getAddress());
                    if (NetworkUtils.isValidIpPort(publicAddress)) {
                        socket.connect(publicAddress.getInetSocketAddress(), 20000, new FWTConnectObserver((SocketProcessor)PushDownloadManager.this.socketProcessor.get()));
                    }
                }
                return false;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid push proxy: " + request.getURI() + ", response: " + response.getStatusLine().getStatusCode() + ", reason: " + response.getStatusLine().getReasonPhrase());
            }
            PushDownloadManager.this.removePushProxy(this.data.file.getClientGUID(), request.getURI());
            if (this.methods.isEmpty()) {
                PushDownloadManager.this.sendPushThroughNetwork(this.data);
            }
            return true;
        }

        @Override
        public boolean allowRequest(HttpUriRequest request) {
            return true;
        }
    }
}

