/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.io.IP;
import org.limewire.mojito.messages.DHTMessage;

public abstract class AbstractIPFilter
implements IPFilter {
    private static final Log LOG = LogFactory.getLog(AbstractIPFilter.class);
    private static final IP ALLOWED = new IP(new byte[4]);

    protected IP extractAddress(Message m) {
        if (m instanceof PingReply) {
            PingReply pr = (PingReply)m;
            return this.getIP(pr.getAddress());
        }
        if (m instanceof QueryReply) {
            QueryReply qr = (QueryReply)m;
            return this.getIP(qr.getIPBytes());
        }
        if (m instanceof PushRequest) {
            PushRequest push = (PushRequest)m;
            return this.getIP(push.getIP());
        }
        if (m instanceof QueryRequest) {
            QueryRequest query = (QueryRequest)m;
            if (query.desiresOutOfBandReplies()) {
                return this.getIP(query.getGUID());
            }
            return ALLOWED;
        }
        if (m instanceof DHTMessage) {
            DHTMessage message = (DHTMessage)((Object)m);
            InetSocketAddress addr = (InetSocketAddress)message.getContact().getContactAddress();
            if (addr != null && addr.getAddress() instanceof Inet4Address) {
                return this.getIP(addr.getAddress().getAddress());
            }
            return ALLOWED;
        }
        return ALLOWED;
    }

    private IP getIP(byte[] host) {
        IP ip = null;
        try {
            ip = new IP(host, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ip;
    }

    private IP getIP(String host) {
        IP ip = null;
        try {
            ip = new IP(host);
        }
        catch (IllegalArgumentException badHost) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("doing dns lookup for " + host);
                }
                InetAddress lookUp = InetAddress.getByName(host);
                host = lookUp.getHostAddress();
                ip = new IP(host);
            }
            catch (UnknownHostException unknownHost) {
            }
            catch (IllegalArgumentException stillBadHost) {
                // empty catch block
            }
        }
        return ip;
    }

    @Override
    public boolean allow(Message m) {
        return this.allow(this.extractAddress(m));
    }

    @Override
    public boolean allow(SocketAddress addr) {
        if (!(addr instanceof InetSocketAddress)) {
            return false;
        }
        return this.allow(((InetSocketAddress)addr).getAddress().getAddress());
    }

    @Override
    public boolean allow(byte[] host) {
        return this.allow(this.getIP(host));
    }

    @Override
    public boolean allow(String host) {
        return this.allow(this.getIP(host));
    }

    @Override
    public boolean allow(IP ip) {
        return this.allowAndLog(ip);
    }

    private boolean allowAndLog(IP ip) {
        if (ip == ALLOWED) {
            LOG.debug("Allowing non-checkable IP");
            return true;
        }
        if (ip == null) {
            LOG.debug("Not allowing invalid IP");
            return false;
        }
        boolean yes = this.allowImpl(ip);
        if (LOG.isDebugEnabled()) {
            if (yes) {
                LOG.debug(this.getClass().getSimpleName() + " allowing " + ip);
            } else {
                LOG.debug(this.getClass().getSimpleName() + " not allowing " + ip);
            }
        }
        return yes;
    }

    protected abstract boolean allowImpl(IP var1);

    @Override
    public boolean allow(Address address) {
        if (address instanceof Connectable) {
            return this.allow(((Connectable)address).getInetAddress().getAddress());
        }
        return true;
    }
}

