/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.GUIDPair;
import com.limegroup.gnutella.filters.QueryPair;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryRequest;
import java.util.HashSet;
import java.util.Set;
import org.limewire.collection.Buffer;

public class DuplicateFilter
implements SpamFilter {
    private static final int BUF_SIZE = 20;
    private Buffer<GUIDPair> guids = new Buffer(20);
    static final int GUID_LAG = 500;
    private int guidLag = 500;
    private static final int TOLERANCE = 2;
    static final int QUERY_LAG = 1500;
    private int queryLag = 1500;
    private long querySwapTime = 0L;
    private long queryClearTime = this.queryLag;
    private Set<QueryPair> youngQueries = new HashSet<QueryPair>();
    private Set<QueryPair> oldQueries = new HashSet<QueryPair>();

    private static long getTime() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean allow(Message m) {
        if (!this.allowGUID(m)) {
            return false;
        }
        if (m instanceof QueryRequest) {
            return this.allowQuery((QueryRequest)m);
        }
        return true;
    }

    public boolean allowGUID(Message m) {
        if (!(m instanceof QueryRequest) && !(m instanceof PingRequest)) {
            return true;
        }
        GUIDPair me = new GUIDPair(m.getGUID(), DuplicateFilter.getTime(), m.getHops());
        int z = this.guids.getSize();
        for (int j = 0; j < z; ++j) {
            GUIDPair other = this.guids.get(j);
            if (me.time - other.time > (long)this.guidLag) break;
            if (other.hops != me.hops) continue;
            int misses = 0;
            for (int i = 0; i < me.guid.length && misses <= 2; ++i) {
                if (me.guid[i] == other.guid[i]) continue;
                ++misses;
            }
            if (misses > 2) continue;
            this.guids.add(me);
            return false;
        }
        this.guids.add(me);
        return true;
    }

    public boolean allowQuery(QueryRequest qr) {
        QueryPair qp;
        long time = DuplicateFilter.getTime();
        if (time > this.querySwapTime) {
            if (time <= this.queryClearTime) {
                Set<QueryPair> tmp = this.oldQueries;
                this.oldQueries = this.youngQueries;
                this.youngQueries = tmp;
                this.youngQueries.clear();
            } else {
                this.youngQueries.clear();
                this.oldQueries.clear();
            }
            this.querySwapTime = time + (long)this.queryLag;
            this.queryClearTime = this.querySwapTime + (long)this.queryLag;
        }
        if (this.oldQueries.contains(qp = new QueryPair(qr.getQuery(), qr.getHops(), qr.getRichQuery(), qr.getQueryUrns(), qr.getMetaMask()))) {
            return false;
        }
        boolean added = this.youngQueries.add(qp);
        return added;
    }

    void setQueryLag(int queryLag) {
        this.queryLag = queryLag;
    }

    int getQueryLag() {
        return this.queryLag;
    }

    void setGUIDLag(int guidLag) {
        this.guidLag = guidLag;
    }

    int getGUIDLag() {
        return this.guidLag;
    }
}

