/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import com.limegroup.gnutella.QueryCategoryFilterer;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.messages.QueryRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.IOUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

@EagerSingleton
public class CreationTimeCache {
    private static final Log LOG = LogFactory.getLog(CreationTimeCache.class);
    private final File CTIME_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "createtimes.cache");
    private volatile boolean dirty = false;
    private final ExecutorService deserializeQueue = ExecutorsHelper.newProcessingQueue("CreationTimeCacheDeserializer");
    private final Library library;
    private final FileView gnutellaFileView;
    private final QueryCategoryFilterer mediaTypeAggregator;
    private final Future<Maps> deserializer;

    @Inject
    CreationTimeCache(Library library, @GnutellaFiles FileView gnutellaFileView, QueryCategoryFilterer mediaTypeAggregator) {
        this.gnutellaFileView = gnutellaFileView;
        this.library = library;
        this.mediaTypeAggregator = mediaTypeAggregator;
        this.deserializer = this.deserializeQueue.submit(new Callable<Maps>(){

            @Override
            public Maps call() throws Exception {
                Map<URN, Long> urnToTime = CreationTimeCache.this.createMap();
                SortedMap timeToUrn = CreationTimeCache.this.constructURNMap(urnToTime);
                return new Maps(urnToTime, timeToUrn);
            }
        });
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(new Service(){

            @Override
            public String getServiceName() {
                return "What's New Manager";
            }

            @Override
            public void initialize() {
                CreationTimeCache.this.initialize();
            }

            @Override
            public void start() {
            }

            @Override
            public void stop() {
            }
        });
    }

    void initialize() {
        this.library.addManagedListStatusListener(new EventListener<LibraryStatusEvent>(){

            @Override
            public void handleEvent(LibraryStatusEvent event) {
                CreationTimeCache.this.handleManagedListStatusEvent(event);
            }
        });
        this.gnutellaFileView.addListener(new EventListener<FileViewChangeEvent>(){

            @Override
            public void handleEvent(FileViewChangeEvent event) {
                CreationTimeCache.this.handleFileListEvent(event);
            }
        });
    }

    Map<URN, Long> getUrnToTime() {
        return this.getMaps().getUrnToTime();
    }

    SortedMap<Long, Set<URN>> getTimeToUrn() {
        return this.getMaps().getTimeToUrn();
    }

    private Maps getMaps() {
        boolean interrupted = false;
        while (true) {
            try {
                Maps maps = this.deserializer.get();
                return maps;
            }
            catch (InterruptedException tryAgain) {
                try {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized int getSize() {
        return this.getUrnToTime().size();
    }

    public synchronized Long getCreationTime(URN urn) {
        return this.getUrnToTime().get(urn);
    }

    public long getCreationTimeAsLong(URN urn) {
        Long l = this.getCreationTime(urn);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    synchronized void removeTime(URN urn) {
        Long time = this.getUrnToTime().remove(urn);
        this.removeURNFromURNSet(urn, time);
        if (time != null) {
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneTimes(boolean shouldClearURNSetMap) {
        CreationTimeCache creationTimeCache = this;
        synchronized (creationTimeCache) {
            Iterator<Map.Entry<URN, Long>> iter = this.getUrnToTime().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<URN, Long> currEntry = iter.next();
                URN currURN = currEntry.getKey();
                Long cTime = currEntry.getValue();
                FileDesc fd = this.gnutellaFileView.getFileDesc(currURN);
                if (fd != null && fd.getFile() != null && fd.getFile().exists()) continue;
                this.dirty = true;
                iter.remove();
                if (!shouldClearURNSetMap) continue;
                this.removeURNFromURNSet(currURN, cTime);
            }
        }
    }

    private void pruneTimes() {
        this.pruneTimes(true);
    }

    public synchronized void addTime(URN urn, long time) throws IllegalArgumentException {
        if (urn == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        if (time <= 0L) {
            throw new IllegalArgumentException("Bad Time = " + time);
        }
        Long cTime = time;
        Long existing = this.getUrnToTime().get(urn);
        if (existing == null || !existing.equals(cTime)) {
            this.dirty = true;
            this.getUrnToTime().put(urn, cTime);
        }
    }

    public synchronized void commitTime(URN urn) throws IllegalArgumentException {
        if (urn == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        Long cTime = this.getUrnToTime().get(urn);
        if (cTime == null) {
            throw new IllegalArgumentException("Never added URN via addTime()");
        }
        HashSet<URN> urnSet = (HashSet<URN>)this.getTimeToUrn().get(cTime);
        if (urnSet == null) {
            urnSet = new HashSet<URN>();
            this.getTimeToUrn().put(cTime, urnSet);
        }
        urnSet.add(urn);
    }

    public Collection<URN> getFiles(int max) throws IllegalArgumentException {
        return this.getFiles(null, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<URN> getFiles(QueryRequest request, int max) throws IllegalArgumentException {
        CreationTimeCache creationTimeCache = this;
        synchronized (creationTimeCache) {
            if (max < 1) {
                throw new IllegalArgumentException("bad max = " + max);
            }
            Predicate<String> filter = request == null ? Predicates.alwaysTrue() : this.mediaTypeAggregator.getPredicateForQuery(request);
            ArrayList<URN> toRemove = null;
            LinkedHashSet<URN> urnList = new LinkedHashSet<URN>();
            block3: for (Set<URN> urns : this.getTimeToUrn().values()) {
                if (urnList.size() >= max) break;
                for (URN currURN : urns) {
                    if (urnList.size() >= max) continue block3;
                    FileDesc fd = this.gnutellaFileView.getFileDesc(currURN);
                    if (fd == null) {
                        if (toRemove == null) {
                            toRemove = new ArrayList<URN>();
                        }
                        toRemove.add(currURN);
                        continue;
                    }
                    if (!filter.apply(FileUtils.getFileExtension(fd.getFileName()))) continue;
                    urnList.add(currURN);
                }
            }
            if (toRemove != null) {
                for (URN currURN : toRemove) {
                    this.removeTime(currURN);
                }
            }
            return urnList;
        }
    }

    public Collection<URN> getFiles() {
        return this.getFiles(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void persistCache() {
        if (!this.dirty) {
            return;
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CTIME_CACHE_FILE)));
            oos.writeObject(this.getUrnToTime());
            IOUtils.close(oos);
        }
        catch (IOException e) {
            LOG.error("Unable to write creation cache", e);
        }
        finally {
            IOUtils.close(oos);
        }
        this.dirty = false;
    }

    private synchronized void removeURNFromURNSet(URN urn, Long refTime) {
        block2: {
            block1: {
                if (refTime == null) break block1;
                Set urnSet = (Set)this.getTimeToUrn().get(refTime);
                if (urnSet == null || !urnSet.remove(urn) || urnSet.size() >= 1) break block2;
                this.getTimeToUrn().remove(refTime);
                break block2;
            }
            Iterator<Set<URN>> i = this.getTimeToUrn().values().iterator();
            while (i.hasNext()) {
                Set<URN> urnSet = i.next();
                if (!urnSet.contains(urn)) continue;
                urnSet.remove(urn);
                if (urnSet.size() >= 1) break;
                i.remove();
                break;
            }
        }
    }

    private SortedMap<Long, Set<URN>> constructURNMap(Map<URN, Long> urnToTime) {
        TreeMap<Long, Set<URN>> timeToUrn = new TreeMap<Long, Set<URN>>(Comparators.inverseLongComparator());
        for (Map.Entry<URN, Long> currEntry : urnToTime.entrySet()) {
            Long cTime = currEntry.getValue();
            URN urn = currEntry.getKey();
            HashSet<URN> urnSet = (HashSet<URN>)timeToUrn.get(cTime);
            if (urnSet == null) {
                urnSet = new HashSet<URN>();
                timeToUrn.put(cTime, urnSet);
            }
            urnSet.add(urn);
        }
        return timeToUrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<URN, Long> createMap() {
        Map<URN, Long> map;
        if (!this.CTIME_CACHE_FILE.exists()) {
            this.dirty = true;
            return new HashMap<URN, Long>();
        }
        ConverterObjectInputStream ois = null;
        try {
            Map<URN, Long> map2;
            ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(this.CTIME_CACHE_FILE)));
            map = map2 = GenericsUtils.scanForMap(ois.readObject(), URN.class, Long.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable t) {
            HashMap<URN, Long> hashMap;
            try {
                this.dirty = true;
                LOG.error("Unable to read creation time file", t);
                hashMap = new HashMap<URN, Long>();
            }
            catch (Throwable throwable) {
                IOUtils.close(ois);
                throw throwable;
            }
            IOUtils.close(ois);
            return hashMap;
        }
        IOUtils.close(ois);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileAdded(FileDesc fd) {
        URN sha1 = fd.getSHA1Urn();
        if (!LibraryUtils.isForcedShare(fd) && sha1 != null) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                Long cTime = this.getCreationTime(sha1);
                if (cTime == null) {
                    cTime = fd.lastModified();
                }
                if (cTime > 0L) {
                    this.addTime(sha1, cTime);
                    this.commitTime(sha1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileChanged(URN oldUrn, URN newUrn) {
        CreationTimeCache creationTimeCache = this;
        synchronized (creationTimeCache) {
            long creationTime = this.getCreationTimeAsLong(oldUrn);
            this.removeTime(oldUrn);
            if (creationTime != -1L) {
                this.addTime(newUrn, creationTime);
                this.commitTime(newUrn);
            }
        }
    }

    private void handleManagedListStatusEvent(LibraryStatusEvent evt) {
        switch (evt.getType()) {
            case LOAD_FINISHING: {
                this.pruneTimes();
                break;
            }
            case SAVE: {
                this.persistCache();
            }
        }
    }

    private void handleFileListEvent(FileViewChangeEvent evt) {
        switch (evt.getType()) {
            case FILE_META_CHANGED: 
            case FILE_ADDED: {
                this.fileAdded(evt.getFileDesc());
                break;
            }
            case FILE_REMOVED: {
                if (evt.getFileDesc().getSHA1Urn() == null) break;
                this.removeTime(evt.getFileDesc().getSHA1Urn());
                break;
            }
            case FILE_CHANGED: {
                if (evt.getOldValue().getSHA1Urn() == null) {
                    this.fileAdded(evt.getFileDesc());
                    break;
                }
                if (evt.getFileDesc().getSHA1Urn() != null) {
                    this.fileChanged(evt.getOldValue().getSHA1Urn(), evt.getFileDesc().getSHA1Urn());
                    break;
                }
                this.removeTime(evt.getOldValue().getSHA1Urn());
            }
        }
    }

    private static class Maps {
        private final Map<URN, Long> urnToTime;
        private final SortedMap<Long, Set<URN>> timeToUrn;

        Maps(Map<URN, Long> urnToTime, SortedMap<Long, Set<URN>> timeToUrn) {
            this.urnToTime = urnToTime;
            this.timeToUrn = timeToUrn;
        }

        public SortedMap<Long, Set<URN>> getTimeToUrn() {
            return this.timeToUrn;
        }

        public Map<URN, Long> getUrnToTime() {
            return this.urnToTime;
        }
    }
}

