/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.limegroup.gnutella.library.AbstractFileView;
import com.limegroup.gnutella.library.FileCollectionManager;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileDescChangeEvent;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.FileViewIterator;
import com.limegroup.gnutella.library.FileViewManager;
import com.limegroup.gnutella.library.IncompleteFileCollection;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.LibraryImpl;
import com.limegroup.gnutella.library.SharedFileCollection;
import com.limegroup.gnutella.library.SharedFileCollectionChangeEvent;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.routing.QueryRouteTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.limewire.collection.CollectionUtils;
import org.limewire.collection.Comparators;
import org.limewire.collection.IntSet;
import org.limewire.core.settings.MessageSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SourcedEventMulticaster;
import org.limewire.listener.SourcedEventMulticasterImpl;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.statistic.StatsUtils;
import org.limewire.util.RPNParser;
import org.limewire.util.StringUtils;

@EagerSingleton
class FileViewManagerImpl
implements FileViewManager {
    private static final Log LOG = LogFactory.getLog(FileViewManagerImpl.class);
    private final LibraryImpl library;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final MultiFileView allSharedFilesView;
    private final Map<String, MultiFileView> fileViewsPerFriend = new HashMap<String, MultiFileView>();
    private final Collection<SharedFileCollection> sharedCollections = new ArrayList<SharedFileCollection>();
    private final SourcedEventMulticaster<FileViewChangeEvent, FileView> multicaster = new SourcedEventMulticasterImpl<FileViewChangeEvent, FileView>();
    @InspectionPoint(value="FileManager custom criteria", category=DataCategory.USAGE)
    public final Inspectable CUSTOM = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object inspect() {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("ver", 1);
            ret.put("crit", MessageSettings.CUSTOM_FD_CRITERIA.getValueAsString());
            int total = 0;
            int matched = 0;
            try {
                RPNParser parser = new RPNParser(MessageSettings.CUSTOM_FD_CRITERIA.get());
                FileView shareList = FileViewManagerImpl.this.getGnutellaFileView();
                shareList.getReadLock().lock();
                try {
                    for (FileDesc fd : shareList) {
                        ++total;
                        if (!parser.evaluate(fd)) continue;
                        ++matched;
                    }
                }
                finally {
                    shareList.getReadLock().unlock();
                }
            }
            catch (IllegalArgumentException badSimpp) {
                ret.put("error", badSimpp.toString());
                return ret;
            }
            ret.put("match", matched);
            ret.put("total", total);
            return ret;
        }
    };

    @Inject
    public FileViewManagerImpl(LibraryImpl library) {
        this.library = library;
        this.allSharedFilesView = new MultiFileView("All Shared Files");
    }

    @Inject
    void register(ListenerSupport<FileViewChangeEvent> viewListeners, ListenerSupport<SharedFileCollectionChangeEvent> collectionListeners, FileCollectionManager collectionManager, ListenerSupport<FileDescChangeEvent> fileDescListeners) {
        for (SharedFileCollection collection : collectionManager.getSharedFileCollections()) {
            this.collectionAdded(collection);
        }
        viewListeners.addListener(new EventListener<FileViewChangeEvent>(){

            @Override
            public void handleEvent(FileViewChangeEvent event) {
                LOG.debugf("Handling event {0}", (Object)event);
                if (!(event.getSource() instanceof IncompleteFileCollection)) {
                    switch (event.getType()) {
                        case FILE_ADDED: {
                            if (!FileViewManagerImpl.this.isFileAddable(event.getFileDesc())) break;
                            FileViewManagerImpl.this.fileAddedToCollection(event.getFileDesc(), (SharedFileCollection)event.getFileView(), false);
                            break;
                        }
                        case FILE_REMOVED: {
                            FileViewManagerImpl.this.fileRemovedFromCollection(event.getFileDesc(), (SharedFileCollection)event.getFileView(), false);
                            break;
                        }
                        case FILES_CLEARED: {
                            if (event.isLibraryClear()) {
                                FileViewManagerImpl.this.clearAllViews();
                                break;
                            }
                            FileViewManagerImpl.this.collectionCleared((SharedFileCollection)event.getFileView());
                            break;
                        }
                        case FILE_CHANGED: {
                            FileViewManagerImpl.this.fileChangedInCollection(event.getFileDesc(), event.getOldValue(), (SharedFileCollection)event.getFileView());
                            break;
                        }
                        case FILE_META_CHANGED: {
                            FileViewManagerImpl.this.fileMetaChangedInCollection(event.getFileDesc(), (SharedFileCollection)event.getFileView());
                        }
                    }
                }
            }
        });
        collectionListeners.addListener(new EventListener<SharedFileCollectionChangeEvent>(){

            @Override
            public void handleEvent(SharedFileCollectionChangeEvent event) {
                LOG.debugf("Handling event {0}", (Object)event);
                switch (event.getType()) {
                    case COLLECTION_ADDED: {
                        FileViewManagerImpl.this.collectionAdded(event.getSource());
                        break;
                    }
                    case COLLECTION_REMOVED: {
                        FileViewManagerImpl.this.collectionRemoved(event.getSource());
                        break;
                    }
                    case FRIEND_ADDED: {
                        FileViewManagerImpl.this.friendAddedToCollection(event.getSource(), event.getFriendId());
                        break;
                    }
                    case FRIEND_REMOVED: {
                        FileViewManagerImpl.this.friendRemovedFromCollection(event.getSource(), event.getFriendId());
                        break;
                    }
                    case FRIEND_IDS_CHANGED: {
                        FileViewManagerImpl.this.friendIdsChangedInCollection(event.getSource(), event.getOldFriendIds(), event.getNewFriendIds());
                    }
                }
            }
        });
    }

    @Override
    public void addListener(EventListener<FileViewChangeEvent> listener) {
        this.multicaster.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<FileViewChangeEvent> listener) {
        return this.multicaster.removeListener(listener);
    }

    FileView getAllSharedFilesView() {
        return this.allSharedFilesView;
    }

    FileView getGnutellaFileView() {
        return this.getFileViewForId("_@_GNUTELLA_@_");
    }

    private <K, V> Map<K, List<V>> addToOrCreateMapOfList(Map<K, List<V>> map, K k, List<V> v) {
        if (!v.isEmpty()) {
            if (map == null) {
                map = new HashMap<K, List<V>>();
            }
            map.put(k, v);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectionAdded(SharedFileCollection collection) {
        LOG.debugf("New collection {0} added", (Object)collection);
        Map<MultiFileView, List<FileDesc>> addedFiles = null;
        this.rwLock.writeLock().lock();
        try {
            this.sharedCollections.add(collection);
            List<String> friendList = collection.getFriendList();
            if (!friendList.isEmpty()) {
                List<FileDesc> added = this.allSharedFilesView.addNewBackingView(collection);
                addedFiles = this.addToOrCreateMapOfList(addedFiles, this.allSharedFilesView, added);
            }
            for (String id : friendList) {
                MultiFileView view = this.fileViewsPerFriend.get(id);
                if (view == null) continue;
                List<FileDesc> added = view.addNewBackingView(collection);
                LOG.debugf("Added collection {0} to view {1}, added {2}", (Object)collection, (Object)view, (Object)added);
                addedFiles = this.addToOrCreateMapOfList(addedFiles, view, added);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (addedFiles != null) {
            for (Map.Entry<MultiFileView, List<FileDesc>> entry : addedFiles.entrySet()) {
                for (FileDesc fd : entry.getValue()) {
                    this.multicaster.broadcast(new FileViewChangeEvent((FileView)entry.getKey(), FileViewChangeEvent.Type.FILE_ADDED, fd));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectionRemoved(SharedFileCollection collection) {
        Map<MultiFileView, List<FileDesc>> removedFiles = null;
        this.rwLock.writeLock().lock();
        try {
            this.sharedCollections.remove(collection);
            List<FileDesc> removed = this.allSharedFilesView.removeBackingView(collection);
            removedFiles = this.addToOrCreateMapOfList(removedFiles, this.allSharedFilesView, removed);
            for (MultiFileView view : this.fileViewsPerFriend.values()) {
                removed = view.removeBackingView(collection);
                LOG.debugf("Removed collection {0} from view {1}, added {2}", (Object)collection, (Object)view, (Object)removed);
                removedFiles = this.addToOrCreateMapOfList(removedFiles, view, removed);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (removedFiles != null) {
            for (Map.Entry<MultiFileView, List<FileDesc>> entry : removedFiles.entrySet()) {
                for (FileDesc fd : entry.getValue()) {
                    this.multicaster.broadcast(new FileViewChangeEvent((FileView)entry.getKey(), FileViewChangeEvent.Type.FILE_REMOVED, fd));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void friendAddedToCollection(SharedFileCollection collection, String id) {
        Map<MultiFileView, List<FileDesc>> addedFiles = null;
        this.rwLock.writeLock().lock();
        try {
            List<FileDesc> added = this.allSharedFilesView.addNewBackingView(collection);
            addedFiles = this.addToOrCreateMapOfList(addedFiles, this.allSharedFilesView, added);
            MultiFileView view = this.fileViewsPerFriend.get(id);
            if (view != null) {
                added = view.addNewBackingView(collection);
                LOG.debugf("Friend {0} added to collection {1}, changing view {2}, added {3}", id, collection, view, added);
                addedFiles = this.addToOrCreateMapOfList(addedFiles, view, added);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (addedFiles != null) {
            for (Map.Entry<MultiFileView, List<FileDesc>> entry : addedFiles.entrySet()) {
                for (FileDesc fd : entry.getValue()) {
                    this.multicaster.broadcast(new FileViewChangeEvent((FileView)entry.getKey(), FileViewChangeEvent.Type.FILE_ADDED, fd));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void friendRemovedFromCollection(SharedFileCollection collection, String id) {
        Map<MultiFileView, List<FileDesc>> removedFiles = null;
        this.rwLock.writeLock().lock();
        try {
            MultiFileView view;
            if (collection.getFriendList().isEmpty()) {
                List<FileDesc> removed = this.allSharedFilesView.removeBackingView(collection);
                removedFiles = this.addToOrCreateMapOfList(removedFiles, this.allSharedFilesView, removed);
            }
            if ((view = this.fileViewsPerFriend.get(id)) != null) {
                List<FileDesc> removed = view.removeBackingView(collection);
                LOG.debugf("Friend {0} removed from collection {1}, changing view {2}, removed {2}", id, collection, view, removed);
                removedFiles = this.addToOrCreateMapOfList(removedFiles, view, removed);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (removedFiles != null) {
            for (Map.Entry<MultiFileView, List<FileDesc>> entry : removedFiles.entrySet()) {
                for (FileDesc fd : entry.getValue()) {
                    this.multicaster.broadcast(new FileViewChangeEvent((FileView)entry.getKey(), FileViewChangeEvent.Type.FILE_REMOVED, fd));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void friendIdsChangedInCollection(SharedFileCollection collection, Collection<String> oldIds, Collection<String> newIds) {
        Map<MultiFileView, List<FileDesc>> addedFiles = null;
        Map<MultiFileView, List<FileDesc>> removedFiles = null;
        this.rwLock.writeLock().lock();
        try {
            if (newIds.isEmpty()) {
                List<FileDesc> removed = this.allSharedFilesView.removeBackingView(collection);
                removedFiles = this.addToOrCreateMapOfList(removedFiles, this.allSharedFilesView, removed);
            } else if (oldIds.isEmpty()) {
                List<FileDesc> added = this.allSharedFilesView.addNewBackingView(collection);
                addedFiles = this.addToOrCreateMapOfList(addedFiles, this.allSharedFilesView, added);
            }
            ArrayList<String> addedFriends = new ArrayList<String>(newIds);
            addedFriends.removeAll(oldIds);
            for (String id : addedFriends) {
                MultiFileView view = this.fileViewsPerFriend.get(id);
                if (view == null) continue;
                List<FileDesc> added = view.addNewBackingView(collection);
                LOG.debugf("Friend {0} added to collection {1}, changing view {2}, added {3}", id, collection, view, added);
                addedFiles = this.addToOrCreateMapOfList(addedFiles, view, added);
            }
            ArrayList<String> removedFriends = new ArrayList<String>(oldIds);
            removedFriends.removeAll(newIds);
            for (String id : removedFriends) {
                MultiFileView view = this.fileViewsPerFriend.get(id);
                if (view == null) continue;
                List<FileDesc> removed = view.removeBackingView(collection);
                LOG.debugf("Friend {0} removed from collection {1}, changing view {2}, removed {2}", id, collection, view, removed);
                removedFiles = this.addToOrCreateMapOfList(removedFiles, view, removed);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (addedFiles != null) {
            for (Map.Entry<MultiFileView, List<FileDesc>> entry : addedFiles.entrySet()) {
                for (FileDesc fd : entry.getValue()) {
                    this.multicaster.broadcast(new FileViewChangeEvent((FileView)entry.getKey(), FileViewChangeEvent.Type.FILE_ADDED, fd));
                }
            }
        }
        if (removedFiles != null) {
            for (Map.Entry<MultiFileView, List<FileDesc>> entry : removedFiles.entrySet()) {
                for (FileDesc fd : entry.getValue()) {
                    this.multicaster.broadcast(new FileViewChangeEvent((FileView)entry.getKey(), FileViewChangeEvent.Type.FILE_REMOVED, fd));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllViews() {
        ArrayList<MultiFileView> clearedViews = new ArrayList<MultiFileView>();
        this.rwLock.writeLock().lock();
        try {
            if (this.allSharedFilesView.size() > 0) {
                this.allSharedFilesView.clear();
                clearedViews.add(this.allSharedFilesView);
            }
            for (FileView view : this.fileViewsPerFriend.values()) {
                if (view.size() <= 0) continue;
                view.clear();
                clearedViews.add((MultiFileView)view);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        for (FileView view : clearedViews) {
            this.multicaster.broadcast(new FileViewChangeEvent(view, FileViewChangeEvent.Type.FILES_CLEARED, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectionCleared(SharedFileCollection collection) {
        Map<MultiFileView, List<FileDesc>> removedFiles = null;
        this.rwLock.writeLock().lock();
        try {
            List<FileDesc> removed = this.allSharedFilesView.fileViewCleared(collection);
            removedFiles = this.addToOrCreateMapOfList(removedFiles, this.allSharedFilesView, removed);
            LOG.debugf("Collection cleared {0}, changing all view, removed {1}", (Object)collection, (Object)removed);
            for (String id : collection.getFriendList()) {
                MultiFileView view = this.fileViewsPerFriend.get(id);
                if (view == null) continue;
                removed = view.fileViewCleared(collection);
                LOG.debugf("Cleared collection {0}, changing view {1}, removed {2}", (Object)collection, (Object)view, (Object)removed);
                removedFiles = this.addToOrCreateMapOfList(removedFiles, view, removed);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (removedFiles != null) {
            for (Map.Entry<MultiFileView, List<FileDesc>> entry : removedFiles.entrySet()) {
                for (FileDesc fd : entry.getValue()) {
                    this.multicaster.broadcast(new FileViewChangeEvent((FileView)entry.getKey(), FileViewChangeEvent.Type.FILE_REMOVED, fd));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileRemovedFromCollection(FileDesc fileDesc, SharedFileCollection collection, boolean forceRemoval) {
        ArrayList<MultiFileView> removedViews = null;
        this.rwLock.writeLock().lock();
        try {
            if (this.allSharedFilesView.fileRemovedFromView(fileDesc, collection, forceRemoval)) {
                removedViews = new ArrayList<MultiFileView>();
                removedViews.add(this.allSharedFilesView);
            }
            for (String string : collection.getFriendList()) {
                MultiFileView view = this.fileViewsPerFriend.get(string);
                if (view == null) continue;
                if (view.fileRemovedFromView(fileDesc, collection, forceRemoval)) {
                    if (removedViews == null) {
                        removedViews = new ArrayList();
                    }
                    removedViews.add(view);
                    LOG.debugf("File {0} removed from collection {1}, changing view {2}", (Object)fileDesc, (Object)collection, (Object)view);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debugf("File {0} removed from collection {1}, but didn't change view {2}.  View contains file? {3}", fileDesc, collection, view, view.contains(fileDesc));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (removedViews != null) {
            for (FileView fileView : removedViews) {
                this.multicaster.broadcast(new FileViewChangeEvent(fileView, FileViewChangeEvent.Type.FILE_REMOVED, fileDesc));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileChangedInCollection(FileDesc newFileDesc, FileDesc oldFileDesc, SharedFileCollection collection) {
        ArrayList<MultiFileView> changedViews = null;
        ArrayList<MultiFileView> removedViews = null;
        boolean addable = this.isFileAddable(newFileDesc);
        this.rwLock.writeLock().lock();
        try {
            if (this.allSharedFilesView.fileRemovedFromView(oldFileDesc, collection, false)) {
                if (addable && this.allSharedFilesView.fileAddedFromView(newFileDesc, collection)) {
                    changedViews = new ArrayList<MultiFileView>();
                    changedViews.add(this.allSharedFilesView);
                } else {
                    removedViews = new ArrayList<MultiFileView>();
                    removedViews.add(this.allSharedFilesView);
                }
            }
            for (String string : collection.getFriendList()) {
                MultiFileView view = this.fileViewsPerFriend.get(string);
                if (view == null || !view.fileRemovedFromView(oldFileDesc, collection, false)) continue;
                if (addable && view.fileAddedFromView(newFileDesc, collection)) {
                    if (changedViews == null) {
                        changedViews = new ArrayList();
                    }
                    changedViews.add(view);
                    LOG.debugf("File {0} changed from old file {1} in collection {1}, changing view {2}", newFileDesc, oldFileDesc, collection, view);
                    continue;
                }
                if (view.contains(newFileDesc)) continue;
                if (removedViews == null) {
                    removedViews = new ArrayList();
                }
                removedViews.add(view);
                LOG.debugf("File {0} changed from old file {1} in collection {1}, couldn't add new file to view {2}", newFileDesc, oldFileDesc, collection, view);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (changedViews != null) {
            for (FileView fileView : changedViews) {
                this.multicaster.broadcast(new FileViewChangeEvent(fileView, FileViewChangeEvent.Type.FILE_CHANGED, oldFileDesc, newFileDesc));
            }
        }
        if (removedViews != null) {
            for (FileView fileView : removedViews) {
                this.multicaster.broadcast(new FileViewChangeEvent(fileView, FileViewChangeEvent.Type.FILE_REMOVED, oldFileDesc));
            }
        }
    }

    private void fileMetaChangedInCollection(FileDesc fd, SharedFileCollection collection) {
        if (this.isFileAddable(fd)) {
            this.fileAddedToCollection(fd, collection, true);
        } else {
            this.fileRemovedFromCollection(fd, collection, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileAddedToCollection(FileDesc fileDesc, SharedFileCollection collection, boolean changed) {
        ArrayList<MultiFileView> addedViews = null;
        ArrayList<MultiFileView> changedViews = null;
        this.rwLock.writeLock().lock();
        try {
            List<String> friendList = collection.getFriendList();
            if (!friendList.isEmpty()) {
                if (this.allSharedFilesView.fileAddedFromView(fileDesc, collection)) {
                    addedViews = new ArrayList<MultiFileView>();
                    addedViews.add(this.allSharedFilesView);
                } else if (changed) {
                    changedViews = new ArrayList<MultiFileView>();
                    changedViews.add(this.allSharedFilesView);
                }
            }
            for (String id : friendList) {
                MultiFileView view = this.fileViewsPerFriend.get(id);
                if (view == null) continue;
                if (view.fileAddedFromView(fileDesc, collection)) {
                    if (addedViews == null) {
                        addedViews = new ArrayList();
                    }
                    addedViews.add(view);
                    LOG.debugf("File {0} added to collection {1}, changing view {2}", (Object)fileDesc, (Object)collection, (Object)view);
                    continue;
                }
                if (changed) {
                    LOG.debugf("File {0} changed in collection {1}, changing view {2}", (Object)fileDesc, (Object)collection, (Object)view);
                    if (changedViews == null) {
                        changedViews = new ArrayList();
                    }
                    changedViews.add(view);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debugf("File {0} added to collection {1}, but didn't change view {2}, view contains file ? {3}", fileDesc, collection, view, view.contains(fileDesc));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (addedViews != null) {
            for (FileView fileView : addedViews) {
                this.multicaster.broadcast(new FileViewChangeEvent(fileView, FileViewChangeEvent.Type.FILE_ADDED, fileDesc));
            }
        }
        if (changedViews != null) {
            for (FileView fileView : changedViews) {
                this.multicaster.broadcast(new FileViewChangeEvent(fileView, FileViewChangeEvent.Type.FILE_META_CHANGED, fileDesc));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileView getFileViewForId(String id) {
        MultiFileView view;
        this.rwLock.readLock().lock();
        try {
            view = this.fileViewsPerFriend.get(id);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (view == null) {
            this.rwLock.writeLock().lock();
            try {
                view = this.fileViewsPerFriend.get(id);
                if (view == null) {
                    view = this.createFileView(id);
                    this.fileViewsPerFriend.put(id, view);
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        return view;
    }

    private MultiFileView createFileView(String id) {
        LOG.debugf("Creating new file view for id {0}", (Object)id);
        MultiFileView view = new MultiFileView(id);
        this.initialize(view, id);
        return view;
    }

    private void initialize(MultiFileView view, String id) {
        for (SharedFileCollection collection : this.sharedCollections) {
            if (!collection.getFriendList().contains(id)) continue;
            LOG.debugf("Adding backing view of {0} to view for id {1}", (Object)collection, (Object)id);
            view.addNewBackingView(collection);
        }
    }

    private boolean isFileAddable(FileDesc fd) {
        return fd.getSHA1Urn() != null && fd.isShareable();
    }

    private class FDInspectable
    implements Inspectable {
        private final boolean nonZero;

        FDInspectable(boolean nonZero) {
            this.nonZero = nonZero;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object inspect() {
            List<FileDesc> fds;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("ver", 2);
            ArrayList<Double> hits = new ArrayList<Double>();
            ArrayList<Double> uploads = new ArrayList<Double>();
            ArrayList<Double> completeUploads = new ArrayList<Double>();
            ArrayList<Double> alts = new ArrayList<Double>();
            ArrayList<Double> keywords = new ArrayList<Double>();
            ArrayList<Double> altsHits = new ArrayList<Double>();
            ArrayList<Double> altsUploads = new ArrayList<Double>();
            ArrayList<Double> hitsUpload = new ArrayList<Double>();
            ArrayList<Double> hitsKeywords = new ArrayList<Double>();
            ArrayList<Double> uploadsToComplete = new ArrayList<Double>();
            TreeMap<Integer, FileDesc> topHitsFDs = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            TreeMap<Integer, FileDesc> topUpsFDs = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            TreeMap topAltsFDs = new TreeMap(Comparators.inverseIntegerComparator());
            TreeMap<Integer, FileDesc> topCupsFDs = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            FileView shareList = FileViewManagerImpl.this.getGnutellaFileView();
            shareList.getReadLock().lock();
            try {
                fds = CollectionUtils.listOf(shareList);
            }
            finally {
                shareList.getReadLock().unlock();
            }
            hits.ensureCapacity(fds.size());
            uploads.ensureCapacity(fds.size());
            int rare = 0;
            int total = 0;
            for (FileDesc fd : fds) {
                if (fd instanceof IncompleteFileDesc) continue;
                ++total;
                if (fd.isRareFile()) {
                    ++rare;
                }
                int hitCount = fd.getHitCount();
                if (!this.nonZero || hitCount > 0) {
                    hits.add(Double.valueOf(hitCount));
                    topHitsFDs.put(hitCount, fd);
                }
                int upCount = fd.getAttemptedUploads();
                if (!this.nonZero || upCount > 0) {
                    uploads.add(Double.valueOf(upCount));
                    topUpsFDs.put(upCount, fd);
                }
                int cupCount = fd.getCompletedUploads();
                if (!this.nonZero || cupCount > 0) {
                    completeUploads.add(Double.valueOf(upCount));
                    topCupsFDs.put(cupCount, fd);
                }
                double keywordsCount = HashFunction.getPrefixes(HashFunction.keywords(fd.getPath())).length;
                keywords.add(keywordsCount);
                if (!this.nonZero) {
                    int index = hits.size() - 1;
                    hitsUpload.add(hits.get(index) - uploads.get(index));
                    altsHits.add(alts.get(index) - hits.get(index));
                    altsUploads.add(alts.get(index) - uploads.get(index));
                    hitsKeywords.add(hits.get(index) - keywordsCount);
                    uploadsToComplete.add(uploads.get(index) - completeUploads.get(index));
                }
                ret.put("rare", Double.doubleToLongBits((double)rare / (double)total));
            }
            ret.put("hits", StatsUtils.quickStatsDouble(hits).getMap());
            ret.put("hitsh", StatsUtils.getHistogram(hits, 10));
            ret.put("ups", StatsUtils.quickStatsDouble(uploads).getMap());
            ret.put("upsh", StatsUtils.getHistogram(uploads, 10));
            ret.put("cups", StatsUtils.quickStatsDouble(completeUploads).getMap());
            ret.put("cupsh", StatsUtils.getHistogram(completeUploads, 10));
            ret.put("alts", StatsUtils.quickStatsDouble(alts).getMap());
            ret.put("altsh", StatsUtils.getHistogram(alts, 10));
            ret.put("kw", StatsUtils.quickStatsDouble(keywords).getMap());
            ret.put("kwh", StatsUtils.getHistogram(keywords, 10));
            ret.put("hut", StatsUtils.quickStatsDouble(hitsUpload).getTTestMap());
            ret.put("aht", StatsUtils.quickStatsDouble(altsHits).getTTestMap());
            ret.put("aut", StatsUtils.quickStatsDouble(altsUploads).getTTestMap());
            ret.put("hkt", StatsUtils.quickStatsDouble(hitsKeywords).getTTestMap());
            ret.put("ucut", StatsUtils.quickStatsDouble(uploadsToComplete).getTTestMap());
            QueryRouteTable topHits = new QueryRouteTable();
            QueryRouteTable topUps = new QueryRouteTable();
            QueryRouteTable topCups = new QueryRouteTable();
            QueryRouteTable topAlts = new QueryRouteTable();
            Iterator hitIter = topHitsFDs.values().iterator();
            Iterator upIter = topUpsFDs.values().iterator();
            Iterator cupIter = topCupsFDs.values().iterator();
            Iterator altIter = topAltsFDs.values().iterator();
            for (int i = 0; i < 10; ++i) {
                if (hitIter.hasNext()) {
                    topHits.add(((FileDesc)hitIter.next()).getPath());
                }
                if (upIter.hasNext()) {
                    topUps.add(((FileDesc)upIter.next()).getPath());
                }
                if (altIter.hasNext()) {
                    topAlts.add(((FileDesc)altIter.next()).getPath());
                }
                if (!cupIter.hasNext()) continue;
                topCups.add(((FileDesc)cupIter.next()).getPath());
            }
            ret.put("hitsq", topHits.getRawDump());
            ret.put("upsq", topUps.getRawDump());
            ret.put("cupsq", topCups.getRawDump());
            ret.put("altsq", topAlts.getRawDump());
            return ret;
        }
    }

    @InspectableContainer
    private class FMInspectables {
        private static final int VERSION = 2;
        @InspectionPoint(value="FileManager h/u/a stats", category=DataCategory.USAGE)
        public final Inspectable FDS;
        @InspectionPoint(value="FileManager h/u/a stats > 0", category=DataCategory.USAGE)
        public final Inspectable FDSNZ;
        @InspectionPoint(value="friend file views", category=DataCategory.USAGE)
        public final Inspectable FRIEND;

        private FMInspectables() {
            this.FDS = new FDInspectable(false);
            this.FDSNZ = new FDInspectable(true);
            this.FRIEND = new Inspectable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object inspect() {
                    HashMap data = new HashMap();
                    FileViewManagerImpl.this.rwLock.readLock().lock();
                    try {
                        ArrayList<Integer> sizes = new ArrayList<Integer>(FileViewManagerImpl.this.fileViewsPerFriend.size());
                        for (MultiFileView friendFileList : FileViewManagerImpl.this.fileViewsPerFriend.values()) {
                            sizes.add(friendFileList.size());
                        }
                        data.put("sizes", sizes);
                    }
                    finally {
                        FileViewManagerImpl.this.rwLock.readLock().unlock();
                    }
                    return data;
                }
            };
        }
    }

    private class MultiFileView
    extends AbstractFileView {
        private final List<FileView> backingViews;
        private volatile long totalFileSize;
        private final String name;

        MultiFileView(String name) {
            super(FileViewManagerImpl.this.library);
            this.backingViews = new ArrayList<FileView>();
            this.totalFileSize = 0L;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return StringUtils.toString(this, new Object[0]);
        }

        @Override
        public long getNumBytes() {
            return this.totalFileSize;
        }

        @Override
        public void addListener(EventListener<FileViewChangeEvent> listener) {
            FileViewManagerImpl.this.multicaster.addListener(this, listener);
        }

        @Override
        public Lock getReadLock() {
            return FileViewManagerImpl.this.rwLock.readLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<FileDesc> iterator() {
            FileViewManagerImpl.this.rwLock.readLock().lock();
            try {
                FileViewIterator fileViewIterator = new FileViewIterator(this.library, new IntSet(this.getInternalIndexes()));
                return fileViewIterator;
            }
            finally {
                FileViewManagerImpl.this.rwLock.readLock().unlock();
            }
        }

        @Override
        public Iterable<FileDesc> pausableIterable() {
            return new Iterable<FileDesc>(){

                @Override
                public Iterator<FileDesc> iterator() {
                    return MultiFileView.this.iterator();
                }
            };
        }

        @Override
        public boolean removeListener(EventListener<FileViewChangeEvent> listener) {
            return FileViewManagerImpl.this.multicaster.removeListener(this, listener);
        }

        void clear() {
            this.getInternalIndexes().clear();
            this.totalFileSize = 0L;
        }

        List<FileDesc> removeBackingView(FileView view) {
            if (this.backingViews.remove(view)) {
                return this.validateItems();
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<FileDesc> addNewBackingView(FileView view) {
            if (!this.backingViews.contains(view)) {
                this.backingViews.add(view);
                ArrayList<FileDesc> added = new ArrayList<FileDesc>(view.size());
                view.getReadLock().lock();
                try {
                    IntSet.IntSetIterator iter = ((AbstractFileView)view).getInternalIndexes().iterator();
                    while (iter.hasNext()) {
                        int i = iter.next();
                        FileDesc fd = this.library.getFileDescForIndex(i);
                        if (!FileViewManagerImpl.this.isFileAddable(fd) || !this.getInternalIndexes().add(i)) continue;
                        added.add(fd);
                        this.totalFileSize += fd.getFileSize();
                    }
                }
                finally {
                    view.getReadLock().unlock();
                }
                return added;
            }
            return Collections.emptyList();
        }

        List<FileDesc> fileViewCleared(FileView fileView) {
            if (this.backingViews.contains(fileView)) {
                return this.validateItems();
            }
            return Collections.emptyList();
        }

        boolean fileRemovedFromView(FileDesc fileDesc, FileView fileView, boolean force) {
            if (!force) {
                for (FileView view : this.backingViews) {
                    if (!view.contains(fileDesc)) continue;
                    return false;
                }
            }
            this.getInternalIndexes().remove(fileDesc.getIndex());
            this.totalFileSize -= fileDesc.getFileSize();
            return true;
        }

        boolean fileAddedFromView(FileDesc fileDesc, FileView fileView) {
            boolean added = this.getInternalIndexes().add(fileDesc.getIndex());
            if (added) {
                this.totalFileSize += fileDesc.getFileSize();
            }
            return added;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FileDesc> validateItems() {
            List<FileDesc> removedFds;
            IntSet newItems = new IntSet();
            for (FileView view : this.backingViews) {
                view.getReadLock().lock();
                try {
                    newItems.addAll(((AbstractFileView)view).getInternalIndexes());
                }
                finally {
                    view.getReadLock().unlock();
                }
            }
            this.library.filterIndexes(newItems, new Predicate<FileDesc>(){

                @Override
                public boolean apply(FileDesc t) {
                    return FileViewManagerImpl.this.isFileAddable(t);
                }
            });
            IntSet indexes = this.getInternalIndexes();
            indexes.removeAll(newItems);
            if (indexes.size() == 0) {
                removedFds = Collections.emptyList();
            } else {
                removedFds = new ArrayList(indexes.size());
                IntSet.IntSetIterator iter = indexes.iterator();
                while (iter.hasNext()) {
                    FileDesc fd = this.library.getFileDescForIndex(iter.next());
                    if (fd == null) continue;
                    removedFds.add(fd);
                    this.totalFileSize -= fd.getFileSize();
                }
            }
            indexes.clear();
            indexes.addAll(newItems);
            return removedFds;
        }
    }
}

