/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.RoutableGGEPMessage;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IP;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.setting.LongSetting;
import org.limewire.setting.StringArraySetting;

abstract class RestrictedResponder
implements SimppListener,
MessageHandler {
    private static final Log LOG = LogFactory.getLog(RestrictedResponder.class);
    private volatile IPList allowed;
    private final StringArraySetting setting;
    private final SecureMessageVerifier verifier;
    private final LongSetting lastRoutedVersion;
    private final NetworkManager networkManager;
    private final UDPReplyHandlerFactory udpReplyHandlerFactory;
    private final Executor messageExecutorService;
    private final NetworkInstanceUtils networkInstanceUtils;

    public RestrictedResponder(StringArraySetting setting, NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory udpReplyHandlerFactory, Executor messageExecutor, NetworkInstanceUtils networkInstanceUtils) {
        this(setting, null, null, networkManager, simppManager, udpReplyHandlerFactory, messageExecutor, networkInstanceUtils);
    }

    public RestrictedResponder(StringArraySetting setting, SecureMessageVerifier verifier, LongSetting lastRoutedVersion, NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory udpReplyHandlerFactory, Executor messageExecutorService, NetworkInstanceUtils networkInstanceUtils) {
        this.setting = setting;
        this.verifier = verifier;
        this.lastRoutedVersion = lastRoutedVersion;
        this.networkManager = networkManager;
        this.udpReplyHandlerFactory = udpReplyHandlerFactory;
        this.messageExecutorService = messageExecutorService;
        this.networkInstanceUtils = networkInstanceUtils;
        this.allowed = new IPList();
        this.allowed.add("*.*.*.*");
        simppManager.addListener(this);
        this.updateAllowed();
    }

    private void updateAllowed() {
        IPList newCrawlers = new IPList();
        try {
            for (String ip : this.setting.get()) {
                newCrawlers.add(new IP(ip));
            }
            if (newCrawlers.isValidFilter(false, this.networkInstanceUtils)) {
                this.allowed = newCrawlers;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void simppUpdated(int newVersion) {
        this.updateAllowed();
    }

    @Override
    public final void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        if (msg instanceof RoutableGGEPMessage) {
            if (this.verifier != null && msg instanceof SecureMessage) {
                this.verifier.verify((SecureMessage)((Object)msg), new SecureCallback(addr, handler));
            } else {
                this.processRoutableMessage((RoutableGGEPMessage)msg, addr, handler);
            }
        } else {
            IP ip = new IP(handler.getAddress());
            if (!this.allowed.contains(ip)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("restricted message not allowed from ip: " + ip);
                }
                return;
            }
            this.processAllowedMessage(msg, addr, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRoutableMessage(RoutableGGEPMessage msg, InetSocketAddress addr, ReplyHandler handler) {
        if (msg.getReturnAddress() != null) {
            if (msg.getRoutableVersion() < 0L) {
                return;
            }
            handler = this.udpReplyHandlerFactory.createUDPReplyHandler(msg.getReturnAddress().getInetAddress(), msg.getReturnAddress().getPort());
        } else if (msg.getDestinationAddress() != null ? !Arrays.equals(this.networkManager.getExternalAddress(), msg.getDestinationAddress().getInetAddress().getAddress()) : msg.getRoutableVersion() < 0L) {
            return;
        }
        IP ip = new IP(handler.getAddress());
        if (!this.allowed.contains(ip)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("restricted message not allowed from ip: " + ip);
            }
            return;
        }
        long routableVersion = msg.getRoutableVersion();
        if (this.lastRoutedVersion != null && routableVersion > 0L) {
            LongSetting longSetting = this.lastRoutedVersion;
            synchronized (longSetting) {
                if (routableVersion <= this.lastRoutedVersion.getValue()) {
                    return;
                }
                this.lastRoutedVersion.setValue(routableVersion);
            }
        }
        this.processAllowedMessage(msg, addr, handler);
    }

    protected abstract void processAllowedMessage(Message var1, InetSocketAddress var2, ReplyHandler var3);

    private class SecureCallback
    implements SecureMessageCallback {
        private final InetSocketAddress addr;
        private final ReplyHandler handler;

        SecureCallback(InetSocketAddress addr, ReplyHandler handler) {
            this.addr = addr;
            this.handler = handler;
        }

        @Override
        public void handleSecureMessage(final SecureMessage sm, boolean passed) {
            if (!passed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Message: " + sm + "didn't verify");
                }
                return;
            }
            RestrictedResponder.this.messageExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    RestrictedResponder.this.processRoutableMessage((RoutableGGEPMessage)sm, SecureCallback.this.addr, SecureCallback.this.handler);
                }
            });
        }
    }
}

