/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MessageSentEvent;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.simpp.SimppManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.collection.Tuple;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.ServiceScheduler;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

@EagerSingleton
public class SimppSender {
    private static final Log LOG = LogFactory.getLog(SimppSender.class);
    private final Provider<SimppManager> simppManager;
    private final Object lock = new Object();
    private final Queue<Tuple<SimppRequestVM, ReplyHandler>> requestQueue = new LinkedList<Tuple<SimppRequestVM, ReplyHandler>>();
    private Tuple<SimppRequestVM, ReplyHandler> current;
    private ScheduledFuture<?> timeoutFuture;
    private final ScheduledExecutorService scheduledExecutorService;

    @Inject
    public SimppSender(Provider<SimppManager> simppManager, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService) {
        this.simppManager = simppManager;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Inject
    void register(MessageRouter messageRouter) {
        messageRouter.addMessageHandler(SimppRequestVM.class, new SimppRequestVMMessageHandler());
        messageRouter.addMessageHandler(CapabilitiesVM.class, new CapabilitiesVMMessageHandler());
    }

    @Inject
    void register(ConnectionManager connectionManager) {
        connectionManager.addEventListener(new ConnectionHandler());
    }

    @Inject
    void register(ListenerSupport<MessageSentEvent> messageSentListenerSupport) {
        messageSentListenerSupport.addListener(new SimppMessageSentHandler());
    }

    @Inject
    void register(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, ServiceScheduler serviceScheduler) {
        final AtomicReference snapshot = new AtomicReference();
        long delay = ConnectionSettings.SIMPP_SEND_TIMEOUT.getValue() * 2L;
        serviceScheduler.scheduleWithFixedDelay("simpp sender snapshot", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList list;
                LOG.debug("snapshotting");
                Object object = SimppSender.this.lock;
                synchronized (object) {
                    list = new ArrayList(SimppSender.this.requestQueue);
                }
                List old = (List)snapshot.get();
                if (!list.isEmpty() && old != null) assert (!((Object)list).equals(old));
                snapshot.set(list);
            }
        }, delay, delay, TimeUnit.MILLISECONDS, scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReplyHandlerFromQueue(ReplyHandler handler) {
        LOG.debug("remove handler from queue");
        Object object = this.lock;
        synchronized (object) {
            Iterator i = this.requestQueue.iterator();
            while (i.hasNext()) {
                Tuple tuple = (Tuple)i.next();
                ReplyHandler other = (ReplyHandler)tuple.getSecond();
                if (other != handler) continue;
                LOG.debugf("removing {0} from queue", (Object)handler);
                i.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToNextInQueue() {
        LOG.debug("send simpp to next in queue");
        SimppRequestVM simppRequest = null;
        ReplyHandler replyHandler = null;
        byte[] data = null;
        Object object = this.lock;
        synchronized (object) {
            ReplyHandler staleReplyHandler;
            while (true) {
                this.current = this.requestQueue.poll();
                if (this.current == null) {
                    LOG.debug("queue is empty");
                    return;
                }
                simppRequest = this.current.getFirst();
                replyHandler = this.current.getSecond();
                data = this.getDataToSend(simppRequest);
                if (data.length > 0) {
                    LOG.debugf("sending to {0}", (Object)replyHandler);
                    staleReplyHandler = replyHandler;
                    if (this.timeoutFuture != null) {
                        this.timeoutFuture.cancel(false);
                    }
                    break;
                }
                LOG.debugf("no data to send to: {0}", (Object)replyHandler);
            }
            this.timeoutFuture = this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    LOG.debugf("time out for {0}", (Object)staleReplyHandler);
                    SimppSender.this.sendToNextInQueueIfCurrent(staleReplyHandler);
                }
            }, ConnectionSettings.SIMPP_SEND_TIMEOUT.getValue(), TimeUnit.MILLISECONDS);
        }
        this.sendSimppVM(simppRequest, data, replyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToNextInQueueIfCurrent(ReplyHandler staleReplyHandler) {
        LOG.debug("send to next if current");
        boolean sendToNext = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.current != null && this.current.getSecond() == staleReplyHandler) {
                LOG.debug("stale handler is current one");
                sendToNext = true;
                if (this.timeoutFuture != null) {
                    LOG.debugf("cancel future", new Object[0]);
                    this.timeoutFuture.cancel(false);
                    this.timeoutFuture = null;
                }
            }
        }
        if (sendToNext) {
            this.sendToNextInQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStaleReplyHandler(ReplyHandler staleReplyHandler) {
        LOG.debug("remove stale reply handler");
        boolean sendToNext = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.current != null && this.current.getSecond() == staleReplyHandler) {
                LOG.debug("stale handler is current one");
                sendToNext = true;
            } else {
                this.removeReplyHandlerFromQueue(staleReplyHandler);
            }
        }
        if (sendToNext) {
            this.sendToNextInQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean queueContains(ReplyHandler handler) {
        Object object = this.lock;
        synchronized (object) {
            for (Tuple tuple : this.requestQueue) {
                if (tuple.getSecond() != handler) continue;
                LOG.debugf("queue contains: {0}", (Object)handler);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueSimppRequest(SimppRequestVM simppRequest, ReplyHandler handler) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("{0} handle request {1}", (Object)handler, (Object)this.simppManager.get().getVersion());
        }
        Tuple<SimppRequestVM, ReplyHandler> requestTuple = new Tuple<SimppRequestVM, ReplyHandler>(simppRequest, handler);
        boolean send = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.current != null && this.current.getSecond() == handler) {
                LOG.debugf("currently being serviced {0}", (Object)handler);
                return;
            }
            if (this.queueContains(handler)) {
                LOG.debugf("already in queue {0}", (Object)handler);
                return;
            }
            LOG.debugf("queuing simpp requestor: {0}", (Object)handler);
            this.requestQueue.add(requestTuple);
            send = this.current == null && this.requestQueue.size() == 1;
        }
        if (send) {
            LOG.debugf("sending immediately: {0}", (Object)handler);
            this.sendToNextInQueue();
        }
    }

    private byte[] getDataToSend(SimppRequestVM simppRequest) {
        return simppRequest.isOldRequest() ? this.simppManager.get().getOldUpdateResponse() : this.simppManager.get().getSimppBytes();
    }

    private void sendSimppVM(SimppRequestVM simppRequest, byte[] data, ReplyHandler replyHandler) {
        assert (data.length > 0);
        SimppVM simppVM = SimppVM.createSimppResponse(simppRequest, data);
        try {
            replyHandler.handleSimppVM(simppVM);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    private class SimppMessageSentHandler
    implements EventListener<MessageSentEvent> {
        private SimppMessageSentHandler() {
        }

        @Override
        public void handleEvent(MessageSentEvent event) {
            if (event.getData() instanceof SimppVM) {
                LOG.debugf("done sending to {0}", (Object)event);
                SimppSender.this.sendToNextInQueueIfCurrent(event.getSource());
            }
        }
    }

    private class ConnectionHandler
    implements ConnectionLifecycleListener {
        private ConnectionHandler() {
        }

        @Override
        public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent event) {
            if (event.isDisconnectedEvent() || event.isConnectionClosedEvent()) {
                LOG.debugf("disconnection event: {0}", (Object)event);
                SimppSender.this.removeStaleReplyHandler(event.getConnection());
            }
        }
    }

    private class CapabilitiesVMMessageHandler
    implements MessageHandler {
        private CapabilitiesVMMessageHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            int currentSimppVersion = ((SimppManager)SimppSender.this.simppManager.get()).getVersion();
            if (((CapabilitiesVM)msg).supportsSIMPP() >= currentSimppVersion) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("{0} already has version {1}", (Object)handler, (Object)currentSimppVersion);
                }
                SimppSender.this.removeReplyHandlerFromQueue(handler);
            }
        }
    }

    private class SimppRequestVMMessageHandler
    implements MessageHandler {
        private SimppRequestVMMessageHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            SimppSender.this.enqueueSimppRequest((SimppRequestVM)msg, handler);
        }
    }
}

