/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.Tokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.util.CommonUtils;
import org.limewire.util.GenericsUtils;

@EagerSingleton
public class RatingTable
implements Service {
    private static final Log LOG = LogFactory.getLog(RatingTable.class);
    private static final int MAX_SIZE = 5000;
    private static final int INITIAL_SIZE = 100;
    private final Map<Token, Token> tokenMap = new LinkedHashMap<Token, Token>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Token, Token> e) {
            if (this.size() > 5000) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Discarding token " + e.getValue());
                }
                return true;
            }
            return false;
        }
    };
    private final HashSet<Token> searchTokens = new HashSet();
    private final Tokenizer tokenizer;
    @InspectionPoint(value="spam token counts", category=DataCategory.USAGE)
    final Inspectable TOKEN_COUNTS = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object inspect() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("ver", 1);
            m.put("inp", "15287");
            RatingTable ratingTable = RatingTable.this;
            synchronized (ratingTable) {
                for (Token t : RatingTable.this.tokenMap.values()) {
                    String clazz = t.getClass().getSimpleName();
                    Integer i = (Integer)m.get(clazz);
                    if (i == null) {
                        m.put(clazz, 1);
                        continue;
                    }
                    m.put(clazz, i + 1);
                }
            }
            return m;
        }
    };

    @Inject
    RatingTable(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Spam Management");
    }

    @Override
    public void initialize() {
    }

    @Override
    public synchronized void start() {
        this.load();
    }

    @Override
    public synchronized void stop() {
        this.save();
    }

    protected synchronized void clear() {
        LOG.debug("Clearing ratings");
        this.tokenMap.clear();
    }

    protected synchronized float getRating(RemoteFileDesc desc) {
        float rating = this.getRating(this.lookup(this.tokenizer.getTokens(desc)));
        if (LOG.isDebugEnabled()) {
            String addr = desc.getAddress().getAddressDescription();
            LOG.debug("Result from " + addr + " rated " + rating);
        }
        return rating;
    }

    private float getRating(Set<Token> tokens) {
        float rating = 1.0f;
        for (Token t : tokens) {
            rating *= 1.0f - t.getRating();
        }
        return 1.0f - rating;
    }

    protected synchronized void rate(RemoteFileDesc[] descs, float rating) {
        this.rateInternal(this.lookup(this.tokenizer.getTokens(descs)), rating);
    }

    protected synchronized void rate(QueryReply qr, float rating) {
        this.rateInternal(this.lookup(this.tokenizer.getNonKeywordTokens(qr)), rating);
    }

    protected synchronized void clear(QueryRequest qr) {
        for (Token t : this.tokenizer.getTokens(qr)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clearing search token " + t);
            }
            this.searchTokens.add(t);
            this.tokenMap.remove(t);
        }
    }

    private void rateInternal(Set<Token> tokens, float rating) {
        for (Token t : tokens) {
            float before = t.getRating();
            t.updateRating(rating);
            float after = t.getRating();
            if (LOG.isDebugEnabled()) {
                LOG.debug(t + " was rated " + before + ", now rated " + after);
            }
            if (after == 0.0f) {
                this.tokenMap.remove(t);
                continue;
            }
            this.tokenMap.put(t, t);
        }
    }

    private Set<Token> lookup(Set<Token> tokens) {
        HashSet<Token> newTokens = new HashSet<Token>();
        for (Token t : tokens) {
            if (!this.searchTokens.contains(t)) {
                newTokens.add(this.lookup(t));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Ignoring search token " + t);
        }
        return newTokens;
    }

    private Token lookup(Token token) {
        Token stored = this.tokenMap.get(token);
        return stored == null ? token : stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        ObjectInputStream is;
        block8: {
            this.tokenMap.clear();
            is = null;
            try {
                is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(RatingTable.getSpamDat())));
                List<Token> list = GenericsUtils.scanForList(is.readObject(), Token.class, GenericsUtils.ScanMode.REMOVE);
                int zeroes = 0;
                for (Token t : list) {
                    if (t.getRating() > 0.0f) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Loading " + t + ", rated " + t.getRating());
                        }
                        this.tokenMap.put(t, t);
                        continue;
                    }
                    ++zeroes;
                }
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("Loaded " + this.tokenMap.size() + " entries, skipped " + zeroes + " with zero scores");
            }
            catch (Throwable t) {
                try {
                    LOG.debug("Error loading spam ratings: ", t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.close(is);
                }
            }
        }
        IOUtils.close(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        ArrayList<Token> list;
        RatingTable ratingTable = this;
        synchronized (ratingTable) {
            list = new ArrayList<Token>(this.tokenMap.size());
            for (Map.Entry<Token, Token> e : this.tokenMap.entrySet()) {
                Token t = e.getKey();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Saving " + t + ", rated " + t.getRating());
                }
                list.add(t);
            }
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(RatingTable.getSpamDat())));
            oos.writeObject(list);
            oos.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saved " + list.size() + " entries");
            }
            IOUtils.close(oos);
        }
        catch (IOException iox) {
            LOG.debug("Error saving spam ratings: ", iox);
        }
        finally {
            IOUtils.close(oos);
        }
    }

    protected int size() {
        return this.tokenMap.size();
    }

    protected Token getLeastRecentlyUsed() {
        Iterator<Map.Entry<Token, Token>> i$ = this.tokenMap.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<Token, Token> e = i$.next();
            return e.getKey();
        }
        return null;
    }

    private static File getSpamDat() {
        return new File(CommonUtils.getUserSettingsDir(), "spam.dat");
    }
}

