/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.uploader.UploadSlotListener;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import com.limegroup.gnutella.uploader.UploadSlotUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.MultiIterable;
import org.limewire.collection.NumericBuffer;
import org.limewire.collection.QueueCounter;
import org.limewire.core.settings.UploadSettings;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;

@Singleton
public class UploadSlotManagerImpl
implements UploadSlotManager {
    private static final Log LOG = LogFactory.getLog(UploadSlotManagerImpl.class);
    private static final int BT_SEED = 0;
    private static final int HTTP = 1;
    private static final int HIGH = 2;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    @InspectionPoint(value="active uploads")
    private final CountingList<UploadSlotRequest> active;
    @InspectionPoint(value="queued uploads", category=DataCategory.USAGE)
    private final CountingList<HTTPSlotRequest> queued;
    @InspectionPoint(value="queued resumable uploads", category=DataCategory.USAGE)
    private final CountingList<BTSlotRequest> queuedResumable;
    private final MultiIterable<UploadSlotRequest> allRequests;
    private final NumericBuffer<Float> bandwidth = new NumericBuffer(10);
    private float sessionAverage;
    private int numMeasures;

    @Inject
    public UploadSlotManagerImpl() {
        this.active = new CountingList();
        this.queued = new CountingList();
        this.queuedResumable = new CountingList();
        this.allRequests = new MultiIterable<BTSlotRequest>((Iterable<BTSlotRequest>)this.active, (Iterable<BTSlotRequest>)this.queued, (Iterable<BTSlotRequest>)this.queuedResumable);
    }

    @Override
    public int pollForSlot(UploadSlotUser user, boolean queue, boolean highPriority) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(user + " polling for slot, queuable " + queue);
        }
        return this.requestSlot(new HTTPSlotRequest(user, queue, highPriority));
    }

    @Override
    public int requestSlot(UploadSlotListener listener, boolean highPriority) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(listener + " requesting slot, high priority " + highPriority);
        }
        return this.requestSlot(new BTSlotRequest(listener, highPriority));
    }

    private synchronized int requestSlot(UploadSlotRequest request) {
        boolean existHigherPriority = this.existActiveHigherPriority(request.getPriority());
        int positionInQueue = this.positionInQueue(request);
        int freeableSlots = this.getPreemptible(request.getPriority());
        if (existHigherPriority || !this.hasFreeSlot(this.active.size() + Math.max(0, positionInQueue) - freeableSlots)) {
            if (!request.isQueuable()) {
                return -1;
            }
            if (positionInQueue >= 0) {
                return ++positionInQueue;
            }
            return this.queueRequest(request);
        }
        if (freeableSlots > 0) {
            this.killPreemptible(request.getPriority());
        }
        if (positionInQueue > -1) {
            this.removeIfQueued(request.getUser());
        }
        this.addActiveRequest(request);
        return 0;
    }

    private int positionInQueue(UploadSlotRequest request) {
        return this.getQueue(request.getUser()).indexOf(request);
    }

    @Override
    public synchronized int positionInQueue(UploadSlotUser user) {
        List<? extends UploadSlotRequest> queue = this.getQueue(user);
        for (int i = 0; i < queue.size(); ++i) {
            UploadSlotRequest request = queue.get(i);
            if (request.getUser() != user) continue;
            return i;
        }
        return -1;
    }

    private List<? extends UploadSlotRequest> getQueue(UploadSlotUser user) {
        return user instanceof UploadSlotListener ? this.queuedResumable : this.queued;
    }

    private boolean existActiveHigherPriority(int priority) {
        UploadSlotRequest max;
        if (priority == 2) {
            return false;
        }
        return !this.active.isEmpty() && (max = (UploadSlotRequest)this.active.get(0)).getPriority() > priority;
    }

    private int getPreemptible(int priority) {
        if (priority == 0) {
            return 0;
        }
        int ret = 0;
        for (int i = this.active.size() - 1; i >= 0; --i) {
            UploadSlotRequest request = (UploadSlotRequest)this.active.get(i);
            if (request.getPriority() >= priority || !request.isPreemptible()) continue;
            ++ret;
        }
        return ret;
    }

    private void killPreemptible(int priority) {
        for (int i = this.active.size() - 1; i >= 0; --i) {
            UploadSlotRequest request = (UploadSlotRequest)this.active.get(i);
            if (request.getPriority() >= priority || !request.isPreemptible()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("freeing slot from " + request.getUser());
            }
            this.active.remove(i);
            request.getUser().releaseSlot();
        }
    }

    @Override
    public synchronized boolean hasHTTPSlot(int current) {
        if (this.existActiveHigherPriority(1)) {
            return false;
        }
        return this.hasFreeSlot(current);
    }

    @Override
    public synchronized boolean hasHTTPSlotForMeta(int current) {
        return this.hasFreeSlot(current);
    }

    private boolean hasFreeSlot(int current) {
        if (current >= UploadSettings.HARD_MAX_UPLOADS.getValue()) {
            return false;
        }
        if (current < UploadSettings.SOFT_MAX_UPLOADS.getValue()) {
            return true;
        }
        float fastest = 0.0f;
        for (UploadSlotRequest request : this.active) {
            UploadSlotUser user = request.getUser();
            float speed = 0.0f;
            user.measureBandwidth();
            try {
                speed = user.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                // empty catch block
            }
            if (!((fastest = Math.max(fastest, speed)) > 3.0f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void measureBandwidth() {
        float bw = this.getTotalBandwidth();
        this.sessionAverage = (this.sessionAverage * (float)this.numMeasures + bw) / (float)(++this.numMeasures);
        this.bandwidth.add(Float.valueOf(bw));
    }

    @Override
    public synchronized float getMeasuredBandwidth() throws InsufficientDataException {
        if (this.bandwidth.size() < this.bandwidth.getCapacity()) {
            throw new InsufficientDataException();
        }
        return this.bandwidth.average().floatValue();
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.sessionAverage;
    }

    private float getTotalBandwidth() {
        float ret = 0.0f;
        for (UploadSlotRequest request : this.active) {
            UploadSlotUser user = request.getUser();
            user.measureBandwidth();
            try {
                ret += user.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {}
        }
        return ret;
    }

    private <Request_t extends UploadSlotRequest> int queueRequest(Request_t request) {
        List<? extends UploadSlotRequest> queue = this.getQueue(((UploadSlotRequest)request).user);
        if (queue.size() == UploadSettings.UPLOAD_QUEUE_SIZE.getValue()) {
            return -1;
        }
        queue.add(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("queued " + request.getUser() + " at position " + queue.size());
        }
        return queue.size();
    }

    private void addActiveRequest(UploadSlotRequest request) {
        UploadSlotRequest current;
        int i;
        for (i = 0; i < this.active.size() && (current = (UploadSlotRequest)this.active.get(i)).getPriority() >= request.getPriority(); ++i) {
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("added active request " + request.getUser() + " at position " + i);
        }
        this.active.add(i, request);
    }

    @Override
    public synchronized void cancelRequest(UploadSlotUser user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(user + " cancelling request");
        }
        if (!this.removeIfQueued(user)) {
            this.requestDone(user);
        }
    }

    private boolean removeIfQueued(UploadSlotUser user) {
        List<? extends UploadSlotRequest> queue = this.getQueue(user);
        Iterator<? extends UploadSlotRequest> iter = queue.iterator();
        while (iter.hasNext()) {
            UploadSlotRequest request = iter.next();
            if (request.getUser() != user) continue;
            iter.remove();
            if (LOG.isDebugEnabled()) {
                LOG.debug("remove queued request by " + user);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void requestDone(UploadSlotUser user) {
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            UploadSlotRequest request = (UploadSlotRequest)iter.next();
            if (request.getUser() != user) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("request finished for " + user);
            }
            iter.remove();
            this.resumeQueued();
            return;
        }
    }

    private void resumeQueued() {
        if (this.existActiveHigherPriority(0)) {
            return;
        }
        Iterator iter = this.queuedResumable.iterator();
        while (iter.hasNext() && this.hasFreeSlot(this.active.size())) {
            BTSlotRequest queuedRequest = (BTSlotRequest)iter.next();
            iter.remove();
            if (LOG.isDebugEnabled()) {
                LOG.debug("resuming queued request " + queuedRequest.getUser());
            }
            this.active.add(queuedRequest);
            queuedRequest.getListener().slotAvailable();
        }
    }

    @Override
    public synchronized int getNumActive() {
        return this.active.size();
    }

    @Override
    public synchronized int getNumQueued() {
        return this.queued.size();
    }

    @Override
    public synchronized int getNumQueuedResumable() {
        return this.queuedResumable.size();
    }

    @Override
    public synchronized int getNumUsersForHost(String host) {
        int ret = 0;
        for (UploadSlotRequest request : this.allRequests) {
            if (!host.equals(request.getUser().getHost())) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("active:");
        this.appendPriorities(this.active, ret);
        ret.append("queued:");
        this.appendPriorities(this.queued, ret);
        ret.append("resumable:");
        this.appendPriorities(this.queuedResumable, ret);
        ret.append("bw now:").append(this.getTotalBandwidth());
        ret.append(" session avg:").append(this.sessionAverage);
        return ret.toString();
    }

    private void appendPriorities(List<? extends UploadSlotRequest> l, StringBuilder dest) {
        int[] priorities = this.countPriorities(l);
        for (int i = 0; i < priorities.length; ++i) {
            dest.append(i).append(":").append(priorities[i]).append(" ");
        }
    }

    private int[] countPriorities(List<? extends UploadSlotRequest> l) {
        int[] ret = new int[3];
        for (UploadSlotRequest uploadSlotRequest : l) {
            int n = uploadSlotRequest.getPriority();
            ret[n] = ret[n] + 1;
        }
        return ret;
    }

    @Override
    public synchronized void cleanup() {
        this.active.clear();
        this.queued.clear();
        this.queuedResumable.clear();
    }

    private static class CountingList<E>
    extends ArrayList<E>
    implements Inspectable {
        private final QueueCounter counter = new QueueCounter(10);
        private volatile int maxSize;
        private volatile long lastMod;

        private CountingList() {
        }

        @Override
        public Object inspect() {
            HashMap<String, Number> ret = new HashMap<String, Number>();
            ret.put("avg", this.counter.getAverageSize());
            ret.put("max", this.maxSize);
            ret.put("cur", this.size());
            ret.put("mod", System.currentTimeMillis() - this.lastMod);
            return ret;
        }

        @Override
        public boolean add(E e) {
            this.lastMod = System.currentTimeMillis();
            this.counter.recordArrival();
            this.maxSize = Math.max(this.maxSize, 1 + this.size());
            return super.add(e);
        }

        @Override
        public void add(int index, E e) {
            this.lastMod = System.currentTimeMillis();
            this.counter.recordArrival();
            this.maxSize = Math.max(this.maxSize, 1 + this.size());
            super.add(index, e);
        }

        @Override
        public E remove(int index) {
            this.lastMod = System.currentTimeMillis();
            this.counter.recordDeparture();
            return super.remove(index);
        }

        @Override
        public boolean remove(Object e) {
            boolean ret = super.remove(e);
            if (ret) {
                this.lastMod = System.currentTimeMillis();
                this.counter.recordDeparture();
            }
            return ret;
        }
    }

    private class BTSlotRequest
    extends UploadSlotRequest {
        BTSlotRequest(UploadSlotListener listener, boolean highPriority) {
            super(listener, !highPriority, highPriority ? 2 : 0);
        }

        UploadSlotListener getListener() {
            return (UploadSlotListener)this.getUser();
        }

        @Override
        boolean isQueuable() {
            return this.getPriority() == 0;
        }
    }

    private class HTTPSlotRequest
    extends UploadSlotRequest {
        private final boolean queuable;

        HTTPSlotRequest(UploadSlotUser user, boolean queuable, boolean highPriority) {
            super(user, false, highPriority ? 2 : 1);
            this.queuable = queuable;
        }

        @Override
        boolean isQueuable() {
            return this.queuable;
        }
    }

    private abstract class UploadSlotRequest {
        private final UploadSlotUser user;
        private final boolean preempt;
        private final int priority;

        boolean isPreemptible() {
            return this.preempt;
        }

        int getPriority() {
            return this.priority;
        }

        UploadSlotUser getUser() {
            return this.user;
        }

        abstract boolean isQueuable();

        protected UploadSlotRequest(UploadSlotUser listener, boolean preempt, int priority) {
            this.user = listener;
            this.preempt = preempt;
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (!(o instanceof UploadSlotRequest)) {
                return false;
            }
            UploadSlotRequest other = (UploadSlotRequest)o;
            return this.getUser() == other.getUser();
        }

        public String toString() {
            return this.getClass().getName() + "[user=" + this.user + "]";
        }
    }
}

