/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.mozilla;

import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AbstractCoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.mozilla.MozillaDownload;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.core.api.Category;
import org.limewire.core.api.download.DownloadPiecesInfo;
import org.limewire.core.api.download.DownloadSourceInfo;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.SharingSettings;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.io.InvalidDataException;
import org.limewire.listener.EventListener;
import org.limewire.util.FileUtils;

public class MozillaDownloaderImpl
extends AbstractCoreDownloader
implements EventListener<DownloadStateEvent> {
    private final MozillaDownload download;
    private AtomicBoolean shouldBeRemoved = new AtomicBoolean(false);
    private final DownloadManager downloadManager;
    private final CategoryManager categoryManager;

    public MozillaDownloaderImpl(DownloadManager downloadManager, CategoryManager categoryManager, MozillaDownload download) {
        super(downloadManager, categoryManager);
        this.categoryManager = categoryManager;
        this.downloadManager = downloadManager;
        this.download = download;
        this.download.addListener(this);
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.MOZILLA;
    }

    @Override
    public GUID getQueryGUID() {
        return null;
    }

    @Override
    public void handleInactivity() {
    }

    @Override
    public boolean isAlive() {
        return false;
    }

    @Override
    public boolean isQueuable() {
        return false;
    }

    @Override
    public void discardUnscannedPreview(boolean delete) {
    }

    @Override
    public long getAmountLost() {
        return 0L;
    }

    @Override
    public int getAmountPending() {
        return (int)this.download.getAmountPending();
    }

    @Override
    public long getAmountRead() {
        return this.getAmountDownloaded();
    }

    private long getAmountDownloaded() {
        return this.download.getAmountDownloaded();
    }

    @Override
    public long getAmountVerified() {
        return this.getAmountDownloaded();
    }

    @Override
    public List<RemoteFileDesc> getRemoteFileDescs() {
        return Collections.emptyList();
    }

    @Override
    public int getChunkSize() {
        return 0;
    }

    @Override
    public long getContentLength() {
        return this.download.getContentLength();
    }

    @Override
    public File getDownloadFragment(Downloader.ScanListener listener) {
        return null;
    }

    @Override
    public File getFile() {
        if (this.isCompleted()) {
            return this.getSaveFile();
        }
        return this.getIncompleteFile();
    }

    @Override
    public int getNumHosts() {
        return 1;
    }

    @Override
    public List<Address> getSourcesAsAddresses() {
        return Collections.emptyList();
    }

    @Override
    public List<DownloadSourceInfo> getSourcesDetails() {
        return Collections.emptyList();
    }

    @Override
    public int getQueuePosition() {
        return 1;
    }

    @Override
    public int getQueuedHostCount() {
        return 0;
    }

    @Override
    public int getRemainingStateTime() {
        return 0;
    }

    @Override
    public File getSaveFile() {
        String fileName = this.getIncompleteFile().getName();
        Category category = this.categoryManager.getCategoryForFilename(fileName);
        File saveFile = new File(SharingSettings.getSaveDirectory(category), fileName);
        return saveFile;
    }

    private File getIncompleteFile() {
        return this.download.getIncompleteFile();
    }

    @Override
    public URN getSha1Urn() {
        return null;
    }

    @Override
    public Downloader.DownloadState getState() {
        return this.download.getDownloadStatus();
    }

    @Override
    public boolean isCompleted() {
        return this.download.isCompleted();
    }

    boolean isInactive() {
        return this.download.isInactive();
    }

    @Override
    public boolean isLaunchable() {
        return false;
    }

    @Override
    public boolean isPaused() {
        return this.download.isPaused();
    }

    @Override
    public boolean isRelocatable() {
        return false;
    }

    @Override
    public void pause() {
        if (!this.isPaused() && !this.isInactive() && !this.isCompleted() || this.isQueued()) {
            this.download.pauseDownload();
        }
    }

    private boolean isQueued() {
        return this.download.isQueued();
    }

    @Override
    public boolean resume() {
        if (this.isPaused() || this.isQueued()) {
            this.download.resumeDownload();
        }
        return true;
    }

    @Override
    public void stop() {
        this.finish();
        this.downloadManager.remove(this, true);
    }

    @Override
    protected File getDefaultSaveFile() {
        return null;
    }

    @Override
    public boolean conflicts(URN urn, long fileSize, File ... files) {
        return false;
    }

    @Override
    public boolean conflictsWithIncompleteFile(File incomplete) {
        return false;
    }

    @Override
    public void finish() {
        this.download.cancelDownload();
        this.download.removeDownload();
        this.shouldBeRemoved.set(true);
    }

    @Override
    public void addListener(EventListener<DownloadStateEvent> listener) {
        this.download.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadStateEvent> listener) {
        return this.download.removeListener(listener);
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean shouldBeRemoved() {
        return this.shouldBeRemoved.get();
    }

    @Override
    public boolean shouldBeRestarted() {
        return false;
    }

    @Override
    public void startDownload() {
    }

    @Override
    public float getAverageBandwidth() {
        return this.download.getAverageBandwidth();
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.download.getMeasuredBandwidth();
    }

    @Override
    public void measureBandwidth() {
        this.download.measureBandwidth();
    }

    @Override
    protected DownloadMemento createMemento() {
        return null;
    }

    @Override
    public void initFromMemento(DownloadMemento memento) throws InvalidDataException {
    }

    @Override
    public boolean isMementoSupported() {
        return false;
    }

    @Override
    public void handleEvent(DownloadStateEvent event) {
        Downloader.DownloadState status = (Downloader.DownloadState)((Object)event.getType());
        if (status == Downloader.DownloadState.COMPLETE || status == Downloader.DownloadState.INVALID || status == Downloader.DownloadState.ABORTED) {
            this.downloadManager.remove(this, false);
        }
        if (status == Downloader.DownloadState.COMPLETE) {
            File downloadedFile = this.getIncompleteFile();
            File savedFile = this.getSaveFile();
            FileUtils.forceDelete(savedFile);
            boolean success = FileUtils.forceRename(downloadedFile, savedFile);
            if (!success) {
                this.download.setDiskError();
            }
        }
    }

    @Override
    public void deleteIncompleteFiles() {
        FileUtils.delete(this.getIncompleteFile(), false);
    }

    @Override
    public DownloadPiecesInfo getPieceInfo() {
        return null;
    }
}

