/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.detector.MagicMimeEntry;

class MatchingMagicMimeEntry {
    private MagicMimeEntry magicMimeEntry;
    private double specificity = -1.0;

    public MatchingMagicMimeEntry(MagicMimeEntry magicMimeEntry) {
        this.magicMimeEntry = magicMimeEntry;
    }

    public MagicMimeEntry getMagicMimeEntry() {
        return this.magicMimeEntry;
    }

    private int getLevel() {
        int n = 0;
        for (MagicMimeEntry magicMimeEntry = this.magicMimeEntry.getParent(); magicMimeEntry != null; magicMimeEntry = magicMimeEntry.getParent()) {
            ++n;
        }
        return n;
    }

    private int getRecursiveSubEntryCount() {
        return this.getRecursiveSubEntryCount(this.magicMimeEntry, 0);
    }

    public int getRecursiveSubEntryCount(MagicMimeEntry magicMimeEntry, int n) {
        ++n;
        int n2 = 0;
        for (MagicMimeEntry magicMimeEntry2 : magicMimeEntry.getSubEntries()) {
            n2 += n * (1 + this.getRecursiveSubEntryCount(magicMimeEntry2, n));
        }
        return n2;
    }

    public double getSpecificity() {
        if (this.specificity < 0.0) {
            this.specificity = (double)(this.getLevel() + 1) / (double)(this.getRecursiveSubEntryCount() + 1);
        }
        return this.specificity;
    }

    public MimeType getMimeType() {
        return new MimeType(this.magicMimeEntry.getMimeType());
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.getMimeType() + ',' + this.getSpecificity() + ']';
    }
}

