/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.Serializable;
import net.sf.fmj.utility.FormatUtils;

public class Format
implements Cloneable,
Serializable {
    public static final int NOT_SPECIFIED = -1;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected String encoding;
    public static final Class byteArray = FormatUtils.byteArray;
    public static final Class shortArray = FormatUtils.shortArray;
    public static final Class intArray = FormatUtils.intArray;
    public static final Class formatArray = FormatUtils.formatArray;
    protected Class dataType;
    protected Class clz;
    private long encodingCode;

    public Format(String encoding) {
        this.encoding = encoding;
        this.dataType = byteArray;
        this.clz = this.getClass();
    }

    public Format(String encoding, Class dataType) {
        this.encoding = encoding;
        this.dataType = dataType;
        this.clz = this.getClass();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public boolean equals(Object format) {
        if (!(format instanceof Format)) {
            return false;
        }
        if (FormatUtils.isSubclass(format.getClass(), this.getClass())) {
            return format.equals(this);
        }
        Format oCast = (Format)format;
        return FormatUtils.nullSafeEquals(oCast.getDataType(), this.getDataType()) && (this.encoding == oCast.encoding || this.isSameEncoding(oCast));
    }

    public boolean matches(Format format) {
        if (format == null) {
            return false;
        }
        if (!FormatUtils.isOneAssignableFromTheOther(this.getClass(), format.getClass())) {
            return false;
        }
        return (this.encoding == format.encoding || this.encoding == null || format.encoding == null || this.isSameEncoding(format)) && FormatUtils.matches(format.dataType, this.dataType);
    }

    public Format intersects(Format other) {
        Format result;
        if (this.getClass().isAssignableFrom(other.getClass())) {
            result = (Format)other.clone();
            if (!FormatUtils.specified(result.encoding)) {
                result.encoding = this.encoding;
            }
            if (!FormatUtils.specified(result.dataType)) {
                result.dataType = this.dataType;
            }
        } else if (other.getClass().isAssignableFrom(this.getClass())) {
            result = (Format)this.clone();
            if (!FormatUtils.specified(result.encoding)) {
                result.encoding = other.encoding;
            }
            if (!FormatUtils.specified(result.dataType)) {
                result.dataType = other.dataType;
            }
        } else {
            result = null;
        }
        return result;
    }

    public boolean isSameEncoding(Format other) {
        if (other == null) {
            return false;
        }
        if (other.encoding == null) {
            return false;
        }
        if (this.encoding == null) {
            return false;
        }
        if (other.encoding == this.encoding) {
            return true;
        }
        if (this.encodingCode == 0L) {
            this.encodingCode = this.getEncodingCode(this.encoding);
        }
        if (other.encodingCode == 0L) {
            other.encodingCode = this.getEncodingCode(other.encoding);
        }
        return this.encodingCode == other.encodingCode;
    }

    public boolean isSameEncoding(String encoding) {
        if (encoding == null) {
            return false;
        }
        if (this.encoding == null) {
            return false;
        }
        if (encoding == this.encoding) {
            return true;
        }
        if (this.encodingCode == 0L) {
            this.encodingCode = this.getEncodingCode(this.encoding);
        }
        return this.encodingCode == this.getEncodingCode(encoding);
    }

    private long getEncodingCode(String enc) {
        if (enc == null) {
            return 0L;
        }
        return FormatUtils.stringEncodingCodeVal(enc);
    }

    public Format relax() {
        return (Format)this.clone();
    }

    public Object clone() {
        return new Format(this.encoding, this.dataType);
    }

    protected void copy(Format f) {
        this.dataType = f.dataType;
    }

    public String toString() {
        return this.getEncoding();
    }
}

