/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import com.lti.utils.synchronization.CloseableThread;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import net.sf.fmj.utility.LoggerSingleton;

public class ControllerEventQueue
extends CloseableThread {
    private static final Logger logger = LoggerSingleton.logger;
    Vector eventQueue = new Vector();
    Vector listeners;

    public ControllerEventQueue(Vector listeners, String threadName) {
        this.setName(threadName);
        this.listeners = listeners;
        this.setDaemon(true);
    }

    public synchronized void postEvent(ControllerEvent event) {
        this.dispatchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorEvents() throws InterruptedException {
        while (!this.isClosing()) {
            Vector v;
            ControllerEventQueue controllerEventQueue = this;
            synchronized (controllerEventQueue) {
                while (this.eventQueue.size() == 0) {
                    this.wait();
                }
                v = (Vector)this.eventQueue.clone();
                this.eventQueue.removeAllElements();
            }
            for (int i = 0; i < v.size(); ++i) {
                ControllerEvent event = (ControllerEvent)v.elementAt(i);
                this.dispatchEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(ControllerEvent event) {
        Vector l;
        Vector vector = this.listeners;
        synchronized (vector) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            Object o = l.elementAt(i);
            if (!(o instanceof ControllerListener)) continue;
            ControllerListener listener = (ControllerListener)o;
            try {
                listener.controllerUpdate(event);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception occurred during event dispatching:" + e, e);
            }
        }
    }

    public void run() {
        this.setClosed();
    }
}

