/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.Multiplexer;
import net.sf.fmj.filtergraph.InputPin;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.filtergraph.OutputPin;

public class MuxNode
extends Node {
    private final Multiplexer mux;

    public MuxNode(Multiplexer mux, Format inputFormat, int destTrack) {
        super(mux, 1, 0);
        this.setInputPin(0, new InputPin(this, 0, destTrack));
        this.getInputPin(0).setFormat(inputFormat);
        this.mux = mux;
    }

    public int getPlugInType() {
        return 5;
    }

    Format setPlugInInputFormat(InputPin pin, Format format) {
        return this.mux.setInputFormat(format, pin.getTrack());
    }

    Format setPlugInOutputFormat(OutputPin pin, Format format) {
        throw new UnsupportedOperationException();
    }

    public Node duplicate() {
        return this.propagateDuplicate(new MuxNode(this.getMultiplexer(), this.getInputFormat(), this.getInputPin(0).getTrack()));
    }

    public Format getInputFormat() {
        return this.getInputPin(0).getFormat();
    }

    public Multiplexer getMultiplexer() {
        return this.mux;
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        int processResult;
        if (input.getFormat() == null) {
            input.setFormat(this.getInputFormat());
        }
        if ((processResult = this.getMultiplexer().process(input, destTrackNumber)) != 0) {
            if (processResult == 4 || processResult == 2) {
                logger.finer("Multiplexer process result: " + processResult);
            } else {
                logger.warning("Multiplexer process result: " + processResult);
            }
        }
        return processResult;
    }

    public void addDestLink(Link n) {
        throw new UnsupportedOperationException();
    }
}

