/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.qt;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.util.ImageToBuffer;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.qt.QTSnapper;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;
import quicktime.QTException;

public class QTParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean ENABLE_AUDIO = false;
    private final boolean USE_DATASOURCE_URL_ONLY = true;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("video.x_msvideo"), new ContentDescriptor("video.quicktime")};
    private QTSnapper qtSnapper;
    private static final Object QT_SYNC_OBJ = new Boolean(true);
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        String protocol = source.getLocator().getProtocol();
        if (!protocol.equals("file") && !protocol.equals("http")) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        Object object = QT_SYNC_OBJ;
        synchronized (object) {
            try {
                String urlStr = this.source.getLocator().getProtocol().equals("file") ? URLUtils.createUrlStr(new File(URLUtils.extractValidPathFromFileUrl(this.source.getLocator().toExternalForm()))) : this.source.getLocator().toExternalForm();
                this.qtSnapper = new QTSnapper(urlStr);
                VideoTrack videoTrack = null;
                Object audioTrack = null;
                videoTrack = new VideoTrack();
                if (audioTrack == null && videoTrack == null) {
                    throw new ResourceUnavailableException("No audio or video track found");
                }
                this.tracks = audioTrack != null && videoTrack != null ? new PullSourceStreamTrack[]{videoTrack, audioTrack} : (audioTrack != null ? new PullSourceStreamTrack[]{audioTrack} : new PullSourceStreamTrack[]{videoTrack});
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new ResourceUnavailableException("" + e);
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = QT_SYNC_OBJ;
        synchronized (object) {
            if (this.tracks != null) {
                for (int i = 0; i < this.tracks.length; ++i) {
                    if (this.tracks[i] == null) continue;
                    this.tracks[i].deallocate();
                    this.tracks[i] = null;
                }
                this.tracks = null;
            }
        }
        super.close();
    }

    public void start() throws IOException {
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public static VideoFormat convertCodecPixelFormat(QTSnapper qtSnapper) {
        Dimension size = new Dimension(qtSnapper.getImageWidth(), qtSnapper.getImageHeight());
        float frameRate = -1.0f;
        boolean bufferedImageType = true;
        int maxDataLength = qtSnapper.getImageWidth() * qtSnapper.getImageHeight();
        Class dataType = Format.intArray;
        int bitsPerPixel = 32;
        int red = 0xFF0000;
        int green = 65280;
        int blue = 255;
        return new RGBFormat(size, maxDataLength, dataType, -1.0f, bitsPerPixel, red, green, blue);
    }

    private class AudioTrack
    extends PullSourceStreamTrack {
        private final AudioFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioTrack() throws ResourceUnavailableException {
            Object object = QT_SYNC_OBJ;
            synchronized (object) {
                this.format = null;
            }
        }

        public void deallocate() {
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        public void readFrame(Buffer buffer) {
            Object object = QT_SYNC_OBJ;
            synchronized (object) {
                throw new UnsupportedOperationException();
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final VideoFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoTrack() throws ResourceUnavailableException {
            Object object = QT_SYNC_OBJ;
            synchronized (object) {
                this.format = QTParser.convertCodecPixelFormat(QTParser.this.qtSnapper);
            }
        }

        public void deallocate() {
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = QT_SYNC_OBJ;
            synchronized (object) {
                BufferedImage bi;
                try {
                    QTParser.this.qtSnapper.next();
                    bi = QTParser.this.qtSnapper.getFrame();
                }
                catch (QTException e) {
                    throw new RuntimeException(e);
                }
                if (bi != null) {
                    Buffer b = ImageToBuffer.createBuffer(bi, this.format.getFrameRate());
                    buffer.setData(b.getData());
                    buffer.setLength(b.getLength());
                    buffer.setOffset(b.getOffset());
                    buffer.setEOM(false);
                    buffer.setDiscard(false);
                    buffer.setTimeStamp((long)QTParser.this.qtSnapper.getFrameTime() * 1000000000L / (long)QTParser.this.qtSnapper.getTimeScale());
                } else {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                }
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Time getDuration() {
            Object object = QT_SYNC_OBJ;
            synchronized (object) {
                if (QTParser.this.qtSnapper.getDuration() <= 0 || QTParser.this.qtSnapper.getTimeScale() <= 0) {
                    return Duration.DURATION_UNKNOWN;
                }
                return new Time((long)QTParser.this.qtSnapper.getDuration() * 1000000000L / (long)QTParser.this.qtSnapper.getTimeScale());
            }
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

