/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.io.IOException;
import java.util.logging.Logger;
import javax.media.DataSink;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.NoProcessorException;
import javax.media.NotRealizedError;
import javax.media.Processor;
import javax.media.control.TrackControl;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.util.StateWaiter;
import net.sf.fmj.ui.wizards.ProcessorWizardConfig;
import net.sf.fmj.ui.wizards.TrackConfig;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.LoggerSingleton;

public class ProcessorWizardResult {
    private static final Logger logger = LoggerSingleton.logger;
    public Processor processor;
    private StateWaiter stateWaiter;
    private DataSource destDataSource;
    private DataSink destDataSink;

    public void step1_createProcessorAndSetUrl(ProcessorWizardConfig config) throws WizardStepException {
        String url = config.url;
        if (url == null || url.equals("")) {
            throw new WizardStepException("Source URL may not be blank");
        }
        logger.fine("Creating processor");
        try {
            this.processor = Manager.createProcessor(new MediaLocator(url));
        }
        catch (IOException e) {
            throw new WizardStepException(e);
        }
        catch (NoProcessorException e) {
            throw new WizardStepException(e);
        }
        logger.fine("Created processor " + this.processor);
        logger.fine("Configuring processor");
        this.stateWaiter = new StateWaiter(this.processor);
        if (!this.stateWaiter.blockingConfigure()) {
            throw new WizardStepException("Failed to configure processor");
        }
        logger.fine("Configured processor");
    }

    public void step2_setContentDescriptor(ProcessorWizardConfig config) throws WizardStepException {
        if (this.processor.setContentDescriptor(config.contentDescriptor) == null) {
            throw new WizardStepException("Unable to set content descriptor to " + config.contentDescriptor);
        }
    }

    public void step3_setTrackConfigs(ProcessorWizardConfig config) throws WizardStepException {
        TrackConfig[] trackConfigs = config.trackConfigs;
        TrackControl[] trackControls = this.processor.getTrackControls();
        for (int i = 0; i < trackControls.length; ++i) {
            Format f;
            Format result;
            boolean enabled = trackConfigs[i].enabled;
            trackControls[i].setEnabled(enabled);
            if (!enabled || (result = trackControls[i].setFormat(f = trackConfigs[i].format)) != null) continue;
            throw new WizardStepException("Unable to set format of track " + i + " to " + f);
        }
    }

    public void step4_setDestUrlAndStart(ProcessorWizardConfig config) throws WizardStepException {
        if (!this.stateWaiter.blockingRealize()) {
            throw new WizardStepException("Failed to realize processor");
        }
        try {
            this.destDataSource = this.processor.getDataOutput();
        }
        catch (NotRealizedError e) {
            throw new WizardStepException(e);
        }
        try {
            String url = config.destUrl;
            logger.fine("Dest url: " + url);
            MediaLocator m = new MediaLocator(url);
            this.destDataSink = Manager.createDataSink(this.destDataSource, m);
            this.destDataSink.open();
            this.destDataSink.start();
            logger.fine("Starting processor");
            this.stateWaiter.blockingStart();
        }
        catch (IOException e) {
            throw new WizardStepException(e);
        }
        catch (NoDataSinkException e) {
            throw new WizardStepException(e);
        }
    }
}

