/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.annotation.AbstractProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;

public class BaseProxySubscriber
extends AbstractProxySubscriber
implements EventSubscriber {
    private Class subscriptionClass;

    public BaseProxySubscriber(Object object, Method method, ReferenceStrength referenceStrength, EventService eventService, Class clazz) {
        super(object, method, referenceStrength, eventService);
        this.subscriptionClass = clazz;
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray == null || classArray.length != 1 || classArray[0].isPrimitive()) {
            throw new IllegalArgumentException("The subscriptionMethod must have a single non-primitive parameter.");
        }
    }

    public void onEvent(Object object) {
        Object[] objectArray = new Object[]{object};
        try {
            Object object2 = this.getProxiedSubscriber();
            if (object2 == null) {
                return;
            }
            this.getSubscriptionMethod().invoke(object2, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("IllegalAccessException when invoking annotated method from EventService publication.  Event class:" + object.getClass() + ", Event:" + object + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("InvocationTargetException when invoking annotated method from EventService publication.  Event class:" + object.getClass() + ", Event:" + object + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod(), invocationTargetException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BaseProxySubscriber) {
            if (!super.equals(object)) {
                return false;
            }
            BaseProxySubscriber baseProxySubscriber = (BaseProxySubscriber)object;
            if (this.subscriptionClass != baseProxySubscriber.subscriptionClass) {
                if (this.subscriptionClass == null) {
                    return false;
                }
                if (!this.subscriptionClass.equals(baseProxySubscriber.subscriptionClass)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "BaseProxySubscriber{subscription=" + this.subscriptionClass + "realSubscriber=" + this.getProxiedSubscriber() + ", subscriptionMethod=" + this.getSubscriptionMethod() + ", referenceStrength=" + (Object)((Object)this.getReferenceStrength()) + ", eventService=" + this.getEventService() + '}';
    }
}

