/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamBitratePropertiesChunk
extends Chunk {
    private final ArrayList<Long> bitRates = new ArrayList();
    private final ArrayList<Integer> streamNumbers = new ArrayList();

    public StreamBitratePropertiesChunk(BigInteger chunkLen) {
        super(GUID.GUID_STREAM_BITRATE_PROPERTIES, chunkLen);
    }

    public void addBitrateRecord(int streamNum, long averageBitrate) {
        this.streamNumbers.add(new Integer(streamNum));
        this.bitRates.add(new Long(averageBitrate));
    }

    public long getAvgBitrate(int streamNumber) {
        Integer seach = new Integer(streamNumber);
        int index = this.streamNumbers.indexOf(seach);
        if (index != -1) {
            return this.bitRates.get(index);
        }
        return -1L;
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuffer result = new StringBuffer(super.prettyPrint(prefix));
        for (int i = 0; i < this.bitRates.size(); ++i) {
            result.append(prefix + "  |-> Stream no. \"" + this.streamNumbers.get(i) + "\" has an average bitrate of \"" + this.bitRates.get(i) + "\"" + Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }
}

