/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public abstract class StreamChunk
extends Chunk {
    private boolean contentEncrypted;
    private int streamNumber;
    private long streamSpecificDataSize;
    private long timeOffset;
    private GUID type;
    private long typeSpecificDataSize;

    public StreamChunk(GUID streamType, BigInteger chunkLen) {
        super(GUID.GUID_STREAM, chunkLen);
        assert (GUID.GUID_AUDIOSTREAM.equals(streamType) || GUID.GUID_VIDEOSTREAM.equals(streamType));
        this.type = streamType;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public long getStreamSpecificDataSize() {
        return this.streamSpecificDataSize;
    }

    public GUID getStreamType() {
        return this.type;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public long getTypeSpecificDataSize() {
        return this.typeSpecificDataSize;
    }

    public boolean isContentEncrypted() {
        return this.contentEncrypted;
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuffer result = new StringBuffer(super.prettyPrint(prefix));
        result.append(prefix + "  |-> Stream number: " + this.getStreamNumber() + Utils.LINE_SEPARATOR);
        result.append(prefix + "  |-> Type specific data size  : " + this.getTypeSpecificDataSize() + Utils.LINE_SEPARATOR);
        result.append(prefix + "  |-> Stream specific data size: " + this.getStreamSpecificDataSize() + Utils.LINE_SEPARATOR);
        result.append(prefix + "  |-> Time Offset              : " + this.getTimeOffset() + Utils.LINE_SEPARATOR);
        result.append(prefix + "  |-> Content Encryption       : " + this.isContentEncrypted() + Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setContentEncrypted(boolean cntEnc) {
        this.contentEncrypted = cntEnc;
    }

    public void setStreamNumber(int streamNum) {
        this.streamNumber = streamNum;
    }

    public void setStreamSpecificDataSize(long strSpecDataSize) {
        this.streamSpecificDataSize = strSpecDataSize;
    }

    public void setTimeOffset(long timeOffs) {
        this.timeOffset = timeOffs;
    }

    public void setTypeSpecificDataSize(long typeSpecDataSize) {
        this.typeSpecificDataSize = typeSpecDataSize;
    }
}

