/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.Collections;
import java.util.List;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.datatype.Artwork;

public abstract class GenericTag
extends AbstractTag {
    public static final int ALBUM = 1;
    public static final int ARTIST = 0;
    public static final int COMMENT = 6;
    public static final int GENRE = 5;
    private static final String[] keys = new String[]{"ARTIST", "ALBUM", "TITLE", "TRACK", "YEAR", "GENRE", "COMMENT"};
    public static final int TITLE = 2;
    public static final int TRACK = 3;
    public static final int YEAR = 4;

    @Override
    public TagField createAlbumField(String content) {
        return new GenericTagTextField(keys[1], content);
    }

    @Override
    public TagField createArtistField(String content) {
        return new GenericTagTextField(keys[0], content);
    }

    @Override
    public TagField createCommentField(String content) {
        return new GenericTagTextField(keys[6], content);
    }

    @Override
    public TagField createGenreField(String content) {
        return new GenericTagTextField(keys[5], content);
    }

    @Override
    public TagField createTitleField(String content) {
        return new GenericTagTextField(keys[2], content);
    }

    @Override
    public TagField createTrackField(String content) {
        return new GenericTagTextField(keys[3], content);
    }

    @Override
    public TagField createYearField(String content) {
        return new GenericTagTextField(keys[4], content);
    }

    @Override
    protected String getAlbumId() {
        return keys[1];
    }

    @Override
    protected String getArtistId() {
        return keys[0];
    }

    @Override
    protected String getCommentId() {
        return keys[6];
    }

    @Override
    protected String getGenreId() {
        return keys[5];
    }

    @Override
    protected String getTitleId() {
        return keys[2];
    }

    @Override
    protected String getTrackId() {
        return keys[3];
    }

    @Override
    protected String getYearId() {
        return keys[4];
    }

    @Override
    protected boolean isAllowedEncoding(String enc) {
        return true;
    }

    @Override
    public TagField createTagField(TagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        throw new UnsupportedOperationException("Not implemented for this format");
    }

    @Override
    public String getFirst(TagFieldKey genericKey) throws KeyNotFoundException {
        throw new UnsupportedOperationException("Not implemented for this format");
    }

    @Override
    public void deleteTagField(TagFieldKey tagFieldKey) throws KeyNotFoundException {
        throw new UnsupportedOperationException("Not implemented for this format");
    }

    @Override
    public TagField getFirstField(TagFieldKey genericKey) throws KeyNotFoundException {
        throw new UnsupportedOperationException("Not implemented for this format");
    }

    @Override
    public List<Artwork> getArtworkList() {
        return Collections.emptyList();
    }

    @Override
    public TagField createArtworkField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException("Not implemented for this format");
    }

    private class GenericTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public GenericTagTextField(String fieldId, String initialContent) {
            this.id = fieldId;
            this.content = initialContent;
        }

        @Override
        public void copyContent(TagField field) {
            if (field instanceof TagTextField) {
                this.content = ((TagTextField)field).getContent();
            }
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getEncoding() {
            return "ISO-8859-1";
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public byte[] getRawContent() {
            return this.content == null ? new byte[]{} : Utils.getDefaultBytes(this.content, this.getEncoding());
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public void isBinary(boolean b) {
        }

        @Override
        public boolean isCommon() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.content.equals("");
        }

        @Override
        public void setContent(String s) {
            this.content = s;
        }

        @Override
        public void setEncoding(String s) {
        }

        @Override
        public String toString() {
            return this.getId() + " : " + this.getContent();
        }
    }
}

