/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.frame;

import java.io.IOException;
import org.kc7bfi.jflac.frame.EntropyCodingMethod;
import org.kc7bfi.jflac.frame.EntropyPartitionedRiceContents;
import org.kc7bfi.jflac.frame.Header;
import org.kc7bfi.jflac.io.BitInputStream;

public class EntropyPartitionedRice
extends EntropyCodingMethod {
    private static final int ENTROPY_CODING_METHOD_PARTITIONED_RICE_PARAMETER_LEN = 4;
    private static final int ENTROPY_CODING_METHOD_PARTITIONED_RICE_RAW_LEN = 5;
    private static final int ENTROPY_CODING_METHOD_PARTITIONED_RICE_ESCAPE_PARAMETER = 15;
    protected int order;
    protected EntropyPartitionedRiceContents contents;

    void readResidual(BitInputStream is, int predictorOrder, int partitionOrder, Header header, int[] residual) throws IOException {
        int sample = 0;
        int partitions = 1 << partitionOrder;
        int partitionSamples = partitionOrder > 0 ? header.blockSize >> partitionOrder : header.blockSize - predictorOrder;
        this.contents.ensureSize(Math.max(6, partitionOrder));
        this.contents.parameters = new int[partitions];
        int partition = 0;
        while (partition < partitions) {
            int u;
            int riceParameter;
            this.contents.parameters[partition] = riceParameter = is.readRawUInt(4);
            if (riceParameter < 15) {
                u = partitionOrder == 0 || partition > 0 ? partitionSamples : partitionSamples - predictorOrder;
                is.readRiceSignedBlock(residual, sample, u, riceParameter);
                sample += u;
            } else {
                this.contents.rawBits[partition] = riceParameter = is.readRawUInt(5);
                u = partitionOrder == 0 || partition > 0 ? 0 : predictorOrder;
                while (u < partitionSamples) {
                    residual[sample] = is.readRawInt(riceParameter);
                    ++u;
                    ++sample;
                }
            }
            ++partition;
        }
    }
}

