/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.bittorrent.bencoding;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.limewire.bittorrent.bencoding.BELong;
import org.limewire.bittorrent.bencoding.Token;
import org.limewire.util.BEncoder;

class BEString
extends Token<byte[]> {
    private static final int MAX_STRING_SIZE = 0x100000;
    private final byte firstSizeByte;
    private BELong sizeToken;
    private int size = -1;
    private ByteBuffer buf;
    private static final ByteBuffer EMPTY_STRING = ByteBuffer.allocate(0);

    BEString(byte firstChar, ReadableByteChannel chan) {
        super(chan);
        this.firstSizeByte = firstChar;
    }

    @Override
    public void handleRead() throws IOException {
        if (this.size == -1 && !this.readSize()) {
            return;
        }
        if (this.size == 0) {
            return;
        }
        if (!this.buf.hasRemaining()) {
            throw new IllegalStateException("Token is done - don't read to it");
        }
        int read = 0;
        while (this.buf.hasRemaining() && (read = this.chan.read(this.buf)) > 0) {
        }
        if (read == -1 && this.buf.hasRemaining()) {
            throw new EOFException("Could not read String token");
        }
    }

    private boolean readSize() throws IOException {
        if (this.sizeToken == null) {
            this.sizeToken = new BELong(this.chan, BEncoder.COLON, this.firstSizeByte);
        }
        this.sizeToken.handleRead();
        Long l = (Long)this.sizeToken.getResult();
        if (l != null) {
            this.sizeToken = null;
            long l2 = l;
            if (l2 > 0L && l2 < 0x100000L) {
                this.size = (int)l2;
                this.result = new byte[this.size];
                this.buf = ByteBuffer.wrap((byte[])this.result);
                return true;
            }
            if (l2 == 0L) {
                this.size = 0;
                this.buf = EMPTY_STRING;
                this.result = new byte[0];
                return true;
            }
            throw new IOException("invalid string length");
        }
        return false;
    }

    @Override
    protected boolean isDone() {
        return this.buf != null && !this.buf.hasRemaining();
    }

    @Override
    public int getType() {
        return 1;
    }
}

