/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.connection;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.connection.ConnectionItem;
import org.limewire.core.api.connection.ConnectionLifecycleEventType;
import org.limewire.core.api.connection.ConnectionStrength;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.core.impl.connection.CoreConnectionItem;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.SwingSafePropertyChangeSupport;
import org.limewire.net.SocketsManager;
import org.limewire.util.Objects;

@EagerSingleton
public class GnutellaConnectionManagerImpl
implements GnutellaConnectionManager,
ConnectionLifecycleListener {
    private static final int STABLE_THRESHOLD = 5;
    private final ConnectionManager connectionManager;
    private final PropertyChangeSupport changeSupport = new SwingSafePropertyChangeSupport(this);
    private final ConnectionServices connectionServices;
    private final Map<RoutedConnection, ConnectionItem> connectionMap;
    private final EventList<ConnectionItem> connectionItemList;
    private volatile ConnectionStrength currentStrength = ConnectionStrength.DISCONNECTED;
    volatile ConnectionLifecycleEventType lastStrengthRelatedEvent;
    volatile long lastIdleTime;

    @Inject
    public GnutellaConnectionManagerImpl(ConnectionManager connectionManager, ConnectionServices connectionServices) {
        this.connectionManager = Objects.nonNull(connectionManager, "connectionManager");
        this.connectionServices = connectionServices;
        this.connectionMap = new HashMap<RoutedConnection, ConnectionItem>();
        this.connectionItemList = GlazedListsFactory.threadSafeList(new BasicEventList());
    }

    @Inject
    void registerListener() {
        this.connectionManager.addEventListener(this);
    }

    @Inject
    void registerService(ServiceRegistry registry, final @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        registry.register(new Service(){
            private volatile ScheduledFuture<?> meter;
            private volatile ConnectionLifecycleListener listener;

            @Override
            public String getServiceName() {
                return "Connection Strength Meter";
            }

            @Override
            public void initialize() {
                this.listener = new ConnectionLifecycleListener(){

                    @Override
                    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
                        switch (evt.getType()) {
                            case NO_INTERNET: 
                            case CONNECTION_INITIALIZED: 
                            case CONNECTED: {
                                GnutellaConnectionManagerImpl.this.lastStrengthRelatedEvent = evt.getType();
                            }
                        }
                    }
                };
                GnutellaConnectionManagerImpl.this.connectionManager.addEventListener(this.listener);
            }

            @Override
            public void start() {
                this.meter = backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        GnutellaConnectionManagerImpl.this.setConnectionStrength(GnutellaConnectionManagerImpl.this.calculateStrength());
                    }
                }, 0L, 1L, TimeUnit.SECONDS);
            }

            @Override
            public void stop() {
                if (this.meter != null) {
                    this.meter.cancel(false);
                    this.meter = null;
                }
                if (this.listener != null) {
                    GnutellaConnectionManagerImpl.this.connectionManager.removeEventListener(this.listener);
                    this.listener = null;
                }
            }
        });
    }

    private void setConnectionStrength(ConnectionStrength newStrength) {
        ConnectionStrength oldStrength = this.currentStrength;
        this.currentStrength = newStrength;
        this.changeSupport.firePropertyChange("strength", (Object)oldStrength, (Object)newStrength);
    }

    ConnectionStrength calculateStrength() {
        ConnectionStrength strength;
        int stable = this.connectionManager.countConnectionsWithNMessages(5);
        if (stable == 0) {
            int initializing = this.connectionManager.getNumFetchingConnections();
            int connections = this.connectionManager.getNumInitializedConnections();
            strength = initializing == 0 && connections == 0 ? (!this.connectionManager.isConnecting() ? ConnectionStrength.DISCONNECTED : ConnectionStrength.CONNECTING) : (connections == 0 ? ConnectionStrength.CONNECTING : ConnectionStrength.WEAK);
        } else if (this.connectionManager.isConnectionIdle()) {
            this.lastIdleTime = System.currentTimeMillis();
            strength = ConnectionStrength.FULL;
        } else {
            double percent;
            int preferred = this.connectionManager.getPreferredConnectionCount();
            if (LimeWireUtils.isPro()) {
                preferred -= 2;
            }
            if (this.connectionManager.isSupernode()) {
                preferred -= 5;
            }
            strength = (percent = (double)stable / (double)(preferred = Math.max(1, preferred))) <= 0.15 ? ConnectionStrength.WEAK : (percent <= 0.3 ? ConnectionStrength.WEAK_PLUS : (percent <= 0.5 ? ConnectionStrength.MEDIUM : (percent <= 0.75 ? ConnectionStrength.MEDIUM_PLUS : (percent <= 1.0 ? ConnectionStrength.FULL : ConnectionStrength.TURBO))));
        }
        switch (strength) {
            case DISCONNECTED: 
            case CONNECTING: {
                if (this.lastStrengthRelatedEvent != ConnectionLifecycleEventType.NO_INTERNET) break;
                strength = ConnectionStrength.NO_INTERNET;
            }
        }
        switch (strength) {
            case CONNECTING: 
            case WEAK: {
                long now = System.currentTimeMillis();
                if (now >= this.lastIdleTime + 15000L) break;
                strength = ConnectionStrength.MEDIUM;
            }
        }
        return strength;
    }

    @Override
    public boolean isConnected() {
        return this.connectionServices.isConnected();
    }

    @Override
    public boolean isUltrapeer() {
        return this.connectionManager.isSupernode();
    }

    @Override
    public void connect() {
        this.connectionServices.connect();
    }

    @Override
    public void disconnect() {
        this.connectionServices.disconnect();
    }

    @Override
    public void restart() {
        this.connectionManager.disconnect(true);
        this.connectionManager.connect();
    }

    @Override
    public ConnectionStrength getConnectionStrength() {
        return this.currentStrength;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public EventList<ConnectionItem> getConnectionList() {
        return this.connectionItemList;
    }

    @Override
    public void removeConnection(ConnectionItem item) {
        if (item instanceof CoreConnectionItem) {
            RoutedConnection connection = ((CoreConnectionItem)item).getRoutedConnection();
            this.connectionServices.removeConnection(connection);
        }
    }

    @Override
    public void tryConnection(String hostname, int portnum, boolean useTLS) {
        this.connectionServices.connectToHostAsynchronously(hostname, portnum, useTLS ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN);
    }

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
        RoutedConnection c = evt.getConnection();
        if (c != null) {
            if (evt.isConnectionInitializingEvent()) {
                this.addConnection(c);
            } else if (evt.isConnectionInitializedEvent()) {
                this.updateConnection(c);
            } else if (evt.isConnectionClosedEvent()) {
                this.removeConnection(c);
            }
        }
    }

    private void addConnection(RoutedConnection connection) {
        ConnectionItem connectionItem = this.connectionMap.get(connection);
        if (connectionItem == null) {
            connectionItem = new CoreConnectionItem(connection);
            this.connectionMap.put(connection, connectionItem);
            this.connectionItemList.add(connectionItem);
        }
    }

    private void updateConnection(RoutedConnection connection) {
        ConnectionItem connectionItem = this.connectionMap.get(connection);
        if (connectionItem != null) {
            connectionItem.update();
        }
    }

    private void removeConnection(RoutedConnection connection) {
        ConnectionItem connectionItem = this.connectionMap.get(connection);
        if (connectionItem != null) {
            this.connectionItemList.remove(connectionItem);
            this.connectionMap.remove(connection);
        }
    }
}

