/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.download;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.impl.ThreadSafeList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.Category;
import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.magnet.MagnetLink;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.core.impl.download.CoreDownloadItem;
import org.limewire.core.impl.download.DownloadListener;
import org.limewire.core.impl.download.DownloadListenerList;
import org.limewire.core.impl.download.QueueTimeCalculator;
import org.limewire.core.impl.download.listener.ItunesDownloadListenerFactory;
import org.limewire.core.impl.download.listener.RecentDownloadListener;
import org.limewire.core.impl.download.listener.TorrentDownloadListenerFactory;
import org.limewire.core.impl.magnet.MagnetLinkImpl;
import org.limewire.core.impl.search.CoreSearch;
import org.limewire.core.impl.search.RemoteFileDescAdapter;
import org.limewire.core.settings.SharingSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.lifecycle.ServiceScheduler;
import org.limewire.listener.SwingSafePropertyChangeSupport;
import org.limewire.setting.FileSetting;

@EagerSingleton
public class CoreDownloadListManager
implements DownloadListManager {
    private final EventList<DownloadItem> observableDownloadItems;
    private EventList<DownloadItem> swingThreadDownloadItems;
    private final DownloadManager downloadManager;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final SpamManager spamManager;
    private final ItunesDownloadListenerFactory itunesDownloadListenerFactory;
    private final TorrentDownloadListenerFactory torrentDownloadListenerFactory;
    private final CoreDownloadItem.Factory coreDownloadItemFactory;
    private final PropertyChangeSupport changeSupport = new SwingSafePropertyChangeSupport(this);
    private final ThreadSafeList<DownloadItem> threadSafeDownloadItems;
    private static final int PERIOD = 1000;
    private Map<URN, DownloadItem> urnMap = Collections.synchronizedMap(new HashMap());

    @Inject
    public CoreDownloadListManager(DownloadManager downloadManager, RemoteFileDescFactory remoteFileDescFactory, SpamManager spamManager, ItunesDownloadListenerFactory itunesDownloadListenerFactory, TorrentDownloadListenerFactory torrentDownloadListenerFactory, CoreDownloadItem.Factory coreDownloadItemFactory) {
        this.downloadManager = downloadManager;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.spamManager = spamManager;
        this.itunesDownloadListenerFactory = itunesDownloadListenerFactory;
        this.torrentDownloadListenerFactory = torrentDownloadListenerFactory;
        this.coreDownloadItemFactory = coreDownloadItemFactory;
        this.threadSafeDownloadItems = GlazedListsFactory.threadSafeList(new BasicEventList());
        ObservableElementList.Connector<DownloadItem> downloadConnector = GlazedLists.beanConnector(DownloadItem.class);
        this.observableDownloadItems = GlazedListsFactory.observableElementList(this.threadSafeDownloadItems, downloadConnector);
    }

    @Inject
    void registerDownloadListener(DownloadListenerList listenerList) {
        listenerList.addDownloadListener(new CoreDownloadListener(this.threadSafeDownloadItems, new QueueTimeCalculator(this.observableDownloadItems)));
    }

    @Inject
    void registerService(ServiceScheduler scheduler, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                CoreDownloadListManager.this.update();
            }
        };
        scheduler.scheduleWithFixedDelay("UI Download Status Monitor", command, 2000L, 1000L, TimeUnit.MILLISECONDS, backgroundExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        this.observableDownloadItems.getReadWriteLock().writeLock().lock();
        try {
            for (DownloadItem item : this.observableDownloadItems) {
                if (item.getState().isFinished() || !(item instanceof CoreDownloadItem)) continue;
                ((CoreDownloadItem)item).fireDataChanged();
            }
        }
        finally {
            this.observableDownloadItems.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public EventList<DownloadItem> getDownloads() {
        return this.observableDownloadItems;
    }

    @Override
    public EventList<DownloadItem> getSwingThreadSafeDownloads() {
        assert (EventQueue.isDispatchThread());
        if (this.swingThreadDownloadItems == null) {
            this.swingThreadDownloadItems = GlazedListsFactory.swingThreadProxyEventList(this.observableDownloadItems);
        }
        return this.swingThreadDownloadItems;
    }

    @Override
    public DownloadItem addDownload(Search search, List<? extends SearchResult> searchResults) throws DownloadException {
        return this.addDownload(search, searchResults, null, false);
    }

    @Override
    public DownloadItem addDownload(Search search, List<? extends SearchResult> searchResults, File saveFile, boolean overwrite) throws DownloadException {
        this.spamManager.handleUserMarkedGood(searchResults);
        ArrayList<RemoteFileDesc> alts = new ArrayList<RemoteFileDesc>();
        RemoteFileDesc[] files = this.createRfdsAndAltsFromSearchResults(searchResults, alts);
        GUID queryGUID = null;
        if (search != null && search instanceof CoreSearch) {
            queryGUID = ((CoreSearch)search).getQueryGuid();
        }
        Category category = searchResults.iterator().next().getCategory();
        return this.createDownloader(files, alts, queryGUID, saveFile, overwrite, category);
    }

    private DownloadItem createDownloader(RemoteFileDesc[] files, List<RemoteFileDesc> alts, GUID queryGuid, File saveFile, boolean overwrite, Category category) throws DownloadException {
        FileSetting fs;
        File saveDir = null;
        String fileName = null;
        if (saveFile != null) {
            if (saveFile.isDirectory()) {
                saveDir = saveFile;
            } else {
                saveDir = saveFile.getParentFile();
                fileName = saveFile.getName();
            }
        }
        if (!(fs = SharingSettings.getFileSettingForCategory(category)).isDefault()) {
            saveDir = fs.get();
        }
        Downloader downloader = this.downloadManager.download(files, alts, queryGuid, overwrite, saveDir, fileName);
        return (DownloadItem)downloader.getAttribute("limewire.download.glueItem");
    }

    private RemoteFileDesc[] createRfdsAndAltsFromSearchResults(List<? extends SearchResult> searchResults, List<RemoteFileDesc> altList) {
        RemoteFileDesc[] rfds = new RemoteFileDesc[searchResults.size()];
        IpPortSet alts = new IpPortSet();
        for (int i = 0; i < searchResults.size(); ++i) {
            RemoteFileDescAdapter rfdAdapter = (RemoteFileDescAdapter)searchResults.get(i);
            rfds[i] = rfdAdapter.getRfd();
            alts.addAll(rfdAdapter.getAlts());
        }
        RemoteFileDesc sha1RFD = null;
        for (int i = 0; i < rfds.length; ++i) {
            Address address;
            Object next = rfds[i];
            if (next.getSHA1Urn() != null) {
                sha1RFD = next;
            }
            if (!((address = next.getAddress()) instanceof IpPort)) continue;
            alts.remove(address);
        }
        if (sha1RFD == null) {
            sha1RFD = rfds[0];
        }
        for (Object next : alts) {
            altList.add(this.remoteFileDescFactory.createRemoteFileDesc(sha1RFD, (IpPort)next));
        }
        return rfds;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void updateDownloadsCompleted() {
        if (this.downloadManager.downloadsInProgress() == 0) {
            this.changeSupport.firePropertyChange("downloadsCompleted", false, true);
        }
    }

    @Override
    public DownloadItem addTorrentDownload(URI uri, boolean overwrite) throws DownloadException {
        Downloader downloader = this.downloadManager.downloadTorrent(uri, overwrite);
        DownloadItem downloadItem = (DownloadItem)downloader.getAttribute("limewire.download.glueItem");
        return downloadItem;
    }

    @Override
    public DownloadItem addDownload(MagnetLink magnet, File saveFile, boolean overwrite) throws DownloadException {
        File saveDir = null;
        String fileName = null;
        if (saveFile != null) {
            if (saveFile.isDirectory()) {
                saveDir = saveFile;
            } else {
                saveDir = saveFile.getParentFile();
                fileName = saveFile.getName();
            }
        }
        MagnetOptions magnetOptions = ((MagnetLinkImpl)magnet).getMagnetOptions();
        Downloader downloader = this.downloadManager.download(magnetOptions, overwrite, saveDir, fileName);
        DownloadItem downloadItem = (DownloadItem)downloader.getAttribute("limewire.download.glueItem");
        return downloadItem;
    }

    @Override
    public DownloadItem addTorrentDownload(File file, File saveDirectory, boolean overwrite) throws DownloadException {
        Downloader downloader = this.downloadManager.downloadTorrent(file, saveDirectory, overwrite);
        return (DownloadItem)downloader.getAttribute("limewire.download.glueItem");
    }

    @Override
    public boolean contains(URN urn) {
        return this.urnMap.containsKey(urn);
    }

    @Override
    public DownloadItem getDownloadItem(URN urn) {
        return this.urnMap.get(urn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFinished() {
        ArrayList<DownloadItem> finishedItems = new ArrayList<DownloadItem>();
        this.threadSafeDownloadItems.getReadWriteLock().writeLock().lock();
        try {
            for (DownloadItem item : this.threadSafeDownloadItems) {
                DownloadState state = item.getState();
                if (!state.isFinished()) continue;
                finishedItems.add(item);
            }
            for (DownloadItem item : finishedItems) {
                this.remove(item);
            }
        }
        finally {
            this.threadSafeDownloadItems.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void remove(DownloadItem item) {
        this.urnMap.remove(item.getUrn());
        this.threadSafeDownloadItems.remove(item);
    }

    class CoreDownloadListener
    implements DownloadListener {
        private final List<DownloadItem> list;
        private final QueueTimeCalculator queueTimeCalculator;

        public CoreDownloadListener(List<DownloadItem> list, QueueTimeCalculator queueTimeCalculator) {
            this.list = list;
            this.queueTimeCalculator = queueTimeCalculator;
        }

        @Override
        public void downloadAdded(Downloader downloader) {
            if (downloader.getAttribute("limewire.download.startDate") == null) {
                downloader.setAttribute("limewire.download.startDate", new Date(), true);
            }
            CoreDownloadItem item = CoreDownloadListManager.this.coreDownloadItemFactory.create(downloader, this.queueTimeCalculator);
            downloader.setAttribute("limewire.download.glueItem", item, false);
            downloader.addListener(CoreDownloadListManager.this.torrentDownloadListenerFactory.createListener(downloader, this.list));
            downloader.addListener(new RecentDownloadListener(downloader));
            downloader.addListener(CoreDownloadListManager.this.itunesDownloadListenerFactory.createListener(downloader));
            CoreDownloadListManager.this.threadSafeDownloadItems.add(item);
            CoreDownloadListManager.this.changeSupport.firePropertyChange("downloadAdded", false, true);
            URN urn = item.getUrn();
            if (urn != null) {
                CoreDownloadListManager.this.urnMap.put(item.getUrn(), item);
            }
        }

        @Override
        public void downloadRemoved(Downloader downloader) {
            DownloadItem item = this.getDownloadItem(downloader);
            DownloadState state = item.getState();
            if (state.isFinished()) {
                CoreDownloadListManager.this.changeSupport.firePropertyChange("downloadCompleted", null, item);
            }
            if (item.getDownloadItemType() == DownloadItem.DownloadItemType.ANTIVIRUS) {
                CoreDownloadListManager.this.remove(item);
            } else if (state != DownloadState.ERROR && state != DownloadState.DANGEROUS && state != DownloadState.THREAT_FOUND && (SharingSettings.CLEAR_DOWNLOAD.getValue() || !state.isFinished())) {
                CoreDownloadListManager.this.remove(item);
            }
        }

        @Override
        public void downloadsCompleted() {
            CoreDownloadListManager.this.changeSupport.firePropertyChange("downloadsCompleted", false, true);
        }

        DownloadItem getDownloadItem(Downloader downloader) {
            DownloadItem item = (DownloadItem)downloader.getAttribute("limewire.download.glueItem");
            return item;
        }
    }
}

